/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.CircleD;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanDerGrinten4
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Van der Grinten IV";
    public static final int PROPERTIES = 4096;
    private static final double THREE_PI_OVER_2 = 4.71238898038469;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.9634954084936207;

    public VanDerGrinten4(int width, int height) {
        this(width, height, 0, 0);
    }

    public VanDerGrinten4(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public VanDerGrinten4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, Math.PI, 1.9634954084936207);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double absLambdaRad = Math.abs(lambdaRad);
        double absPhiRad = Math.abs(phiRad);
        double x = 0.0;
        double y = 0.0;
        if (absLambdaRad < 1.0E-5) {
            x = 0.0;
            y = absPhiRad;
        } else if (absPhiRad < 1.0E-5) {
            x = absLambdaRad;
            y = 0.0;
        } else if (absPhiRad > 1.5707963266948965) {
            x = 0.0;
            y = 1.5707963267948966;
        } else {
            double b = absPhiRad * 0.6366197723675814;
            double b2 = b * b;
            double c = 0.5 * (b * (8.0 - b * (2.0 + b2)) - 5.0) / (b2 * (b - 1.0));
            double c2 = c * c;
            double dz = 0.6366197723675814 * absLambdaRad + 1.5707963267948966 / absLambdaRad;
            double d2 = dz * dz - 4.0;
            double d = Math.sqrt(d2);
            if (absLambdaRad - 1.5707963267948966 < 0.0) {
                d = -d;
            }
            double bc2 = (b + c) * (b + c);
            double bPlus3C = b + 3.0 * c;
            double ff = bc2 * (b2 + c2 * d2 - 1.0) + (1.0 - b2) * (b2 * (bPlus3C * bPlus3C + 4.0 * c2) + c2 * (12.0 * b * c + 4.0 * c2));
            double x1 = (d * (bc2 + c2 - 1.0) + 2.0 * Math.sqrt(ff)) / (4.0 * bc2 + d2);
            x = 1.5707963267948966 * x1;
            y = 1.5707963267948966 * Math.sqrt(1.0 + d * Math.abs(x1) - x1 * x1);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (phiRad < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = Math.abs(x * this.invRS_);
        double yOverRS = Math.abs(y * this.invRS_);
        if (y == 0.0) {
            if (xOverRS > Math.PI) {
                return null;
            }
            lambdaRad = xOverRS;
            phiRad = 0.0;
        } else if (xOverRS < 1.0E-10) {
            if (yOverRS > 1.5707963267948966) {
                return null;
            }
            lambdaRad = 0.0;
            phiRad = yOverRS;
        } else {
            CircleD cc1 = CircleD.from3Points(0.0, 1.5707963267948966, xOverRS, yOverRS, 0.0, -1.5707963267948966);
            lambdaRad = cc1.getX() + cc1.getRadius();
            if (Double.isNaN(lambdaRad)) {
                return null;
            }
            phiRad = yOverRS;
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        VanDerGrinten4 vanDerGrinten4 = this;
        synchronized (vanDerGrinten4) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = Math.abs(y * this.invRS_);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = Math.abs(x * this.invRS_);
                    CircleD cc = CircleD.from3Points(0.0, 1.5707963267948966, xOverRS, yOverRS, 0.0, -1.5707963267948966);
                    double lambdaRad = cc.getX() + cc.getRadius();
                    if (Math.abs(lambdaRad) > Math.PI) continue;
                    double phiRad = yOverRS;
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        double lona = this.lambdaC_ + 179.99999;
        double lonb = this.lambdaC_ + -179.99999;
        Point2D.Double dot1 = this.transformLL2XY(lona, 90.0);
        Point2D.Double dot2e = this.transformLL2XY(lona, 0.0);
        Point2D.Double dot2w = this.transformLL2XY(lonb, 0.0);
        Point2D.Double dot3 = this.transformLL2XY(lona, -90.0);
        GraphicUtils.drawCircularArc(g2d, dot1, dot2e, dot3);
        GraphicUtils.drawCircularArc(g2d, dot1, dot2w, dot3);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double lon1 = this.lambdaC_ + -179.99999;
        double lon2 = this.lambdaC_;
        double lon3 = this.lambdaC_ + 179.99999;
        Point2D.Double dot1 = this.transformLL2XY(lon1, lat);
        Point2D.Double dot2 = this.transformLL2XY(lon2, lat);
        Point2D.Double dot3 = this.transformLL2XY(lon3, lat);
        if (Math.abs(lat) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dot1.x, dot1.y, dot3.x, dot3.y);
        } else {
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        Point2D.Double dot1 = this.transformLL2XY(lon, 90.0);
        Point2D.Double dot2 = this.transformLL2XY(lon, 0.0);
        Point2D.Double dot3 = this.transformLL2XY(lon, -90.0);
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dot1.x, dot1.y, dot3.x, dot3.y);
        } else {
            if (absLambda > 179.99999) {
                return;
            }
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        }
    }
}

