/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.math;

import java.awt.geom.Point2D;

public class CircleD {
    private double xc_;
    private double yc_;
    private double radius_;

    public CircleD(double radius) {
        this(0.0, 0.0, radius);
    }

    public CircleD(CircleD cc) {
        this(cc.getX(), cc.getY(), cc.getRadius());
    }

    public CircleD(Point2D.Double center, double radius) {
        this.xc_ = center.x;
        this.yc_ = center.y;
        this.radius_ = radius;
    }

    public CircleD(double x, double y, double radius) {
        this.xc_ = x;
        this.yc_ = y;
        this.radius_ = radius;
    }

    public double getX() {
        return this.xc_;
    }

    public double getY() {
        return this.yc_;
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double(this.xc_, this.yc_);
    }

    public double getRadius() {
        return this.radius_;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CircleD) {
            CircleD cc = (CircleD)obj;
            return this.xc_ == cc.getX() && this.yc_ == cc.getY() && this.radius_ == cc.getRadius();
        }
        return false;
    }

    public int hashCode() {
        return Double.valueOf(this.xc_).hashCode() + Double.valueOf(this.yc_).hashCode() + Double.valueOf(this.radius_).hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.xc_ + ",y=" + this.yc_ + ",r=" + this.radius_ + "]";
    }

    public static final CircleD from3Points(double x1, double y1, double x2, double y2, double x3, double y3) {
        double dd = 2.0 * (x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2));
        double x1SqPlusY1Sq = x1 * x1 + y1 * y1;
        double x2SqPlusY2Sq = x2 * x2 + y2 * y2;
        double x3SqPlusY3Sq = x3 * x3 + y3 * y3;
        double x0 = (x1SqPlusY1Sq * (y2 - y3) + x2SqPlusY2Sq * (y3 - y1) + x3SqPlusY3Sq * (y1 - y2)) / dd;
        double y0 = (x1SqPlusY1Sq * (x3 - x2) + x2SqPlusY2Sq * (x1 - x3) + x3SqPlusY3Sq * (x2 - x1)) / dd;
        double dx1 = x1 - x0;
        double dy1 = y1 - y0;
        double rr = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        return new CircleD(x0, y0, rr);
    }
}

