/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.math;

public final class MathUtils {
    public static final double sq(double val) {
        return val * val;
    }

    public static int max(int ... intvals) {
        int max = Integer.MIN_VALUE;
        for (int ival : intvals) {
            max = Math.max(max, ival);
        }
        return max;
    }

    public static double max(double ... dvals) {
        double max = Double.MIN_VALUE;
        for (double dval : dvals) {
            if (Double.isNaN(dval)) {
                return Double.NaN;
            }
            max = Math.max(max, dval);
        }
        return max;
    }

    public static int min(int ... intvals) {
        int min = Integer.MAX_VALUE;
        for (int ival : intvals) {
            min = Math.min(min, ival);
        }
        return min;
    }

    public static float min(float ... fvals) {
        float min = Float.MAX_VALUE;
        for (float fval : fvals) {
            if (Float.isNaN(fval)) {
                return Float.NaN;
            }
            min = Math.min(min, fval);
        }
        return min;
    }

    public static double min(double ... dvals) {
        double min = Double.MAX_VALUE;
        for (double dval : dvals) {
            if (Double.isNaN(dval)) {
                return Double.NaN;
            }
            min = Math.min(min, dval);
        }
        return min;
    }

    public static int minmax(int min, int max, int value) {
        int result = Math.min(value, max);
        result = Math.max(result, min);
        return result;
    }

    public static float minmax(float min, float max, float value) {
        float result = Math.min(value, max);
        result = Math.max(result, min);
        return result;
    }

    public static double minmax(double min, double max, double value) {
        double result = Math.min(value, max);
        result = Math.max(result, min);
        return result;
    }

    public static int sum(int ... intvals) {
        int sum = 0;
        for (int ival : intvals) {
            sum += ival;
        }
        return sum;
    }

    public static float sum(float ... fvals) {
        float sum = 0.0f;
        for (float fval : fvals) {
            if (Float.isNaN(fval)) {
                return Float.NaN;
            }
            sum += fval;
        }
        return sum;
    }

    public static double sum(double ... dvals) {
        double sum = 0.0;
        for (double dval : dvals) {
            if (Double.isNaN(dval)) {
                return Double.NaN;
            }
            sum += dval;
        }
        return sum;
    }

    public static double average(double ... dvals) {
        if (dvals.length == 0) {
            throw new IllegalArgumentException("No values to average.");
        }
        int icount = 0;
        double sum = 0.0;
        for (double dval : dvals) {
            if (Double.isNaN(dval)) {
                return Double.NaN;
            }
            sum += dval;
            ++icount;
        }
        if (icount == 0) {
            return Double.NaN;
        }
        return sum / (double)icount;
    }

    public static double average2(double ... dvals) {
        if (dvals.length == 0) {
            throw new IllegalArgumentException("No values to average.");
        }
        int icount = 0;
        double sum = 0.0;
        for (double dval : dvals) {
            if (Double.isNaN(dval)) continue;
            sum += dval;
            ++icount;
        }
        if (icount == 0) {
            return Double.NaN;
        }
        return sum / (double)icount;
    }

    private MathUtils() {
    }
}

