/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.action.dialog.PanExportKmzDialog;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.io.PanKmzUtils;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanKmlOption;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportKmzAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String KMZ_EXT = "kmz";
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("export-kmz");
    private final PanPlotFrame parent_;
    private String fnameRoot_;

    public PanExportKmzAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        PanExportKmzDialog kod = new PanExportKmzDialog(this.parent_);
        kod.setVisible(true);
        if (!kod.isSuccessful()) {
            return;
        }
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle();
        }
        if ((file = PanFileUtils.showSingleTypeSaveFileChooser(this.parent_, "Export as\u2026", "kml", this.fnameRoot_, KMZ_EXT)) == null) {
            return;
        }
        this.fnameRoot_ = FileUtils.extractFnameRoot(file);
        Hashtable<PanKmlOption, Object> opts = kod.getOptions();
        try {
            PanLonLatPlot llplot = (PanLonLatPlot)this.parent_.getPlot();
            PanKmzUtils.save(file, llplot, opts);
        }
        catch (Exception exc) {
            LOGGER.error("Could not write KMZ info to a file.");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            GuiUtils.showSlowMessage(this.parent_, "Save Error", "Unable to write KMZ file. " + exc.toString());
        }
    }
}

