/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanTogglePlotSectionAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame pframe_;
    private final String actionID_;
    private long last_;
    private boolean busy_;

    public PanTogglePlotSectionAction(PanPlotFrame f, String actionID) {
        super(PanProperties.MENU_PROPS.getString(actionID));
        this.pframe_ = f;
        this.actionID_ = actionID;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOGGER.trace("busy {}", (Object)this.busy_);
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        String pkey = null;
        switch (this.actionID_) {
            case "include-titles": {
                pkey = "include.title";
                break;
            }
            case "include-axes": {
                pkey = "include.axes";
                break;
            }
            case "include-scale": {
                pkey = "include.scale";
                break;
            }
            case "include-footnotes": {
                pkey = "include.footnotes";
                break;
            }
            case "include-margins": {
                pkey = "include.margins";
            }
        }
        if (pkey == null) {
            this.busy_ = false;
            throw new RuntimeException("Unknown action ID");
        }
        long now = System.currentTimeMillis();
        if (now - this.last_ < 200L && e.getSource() instanceof JCheckBoxMenuItem) {
            LOGGER.debug("Too soon, {}; do nothing", (Object)(now - this.last_));
        } else {
            PanPlotMeta pmeta = this.pframe_.getMeta();
            boolean oldValue = pmeta.getBoolean(pkey);
            boolean newValue = !oldValue;
            pmeta.setBoolean(pkey, newValue);
        }
        this.pframe_.resizeToFitDisplay();
        this.pframe_.refreshMenu("plot-menu");
        this.last_ = now;
        this.busy_ = false;
    }
}

