/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action.task;

import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.task.Task;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanOpenCatalogTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final Object address_;
    private String errorMsg_;

    public PanOpenCatalogTask(Object address) {
        super("Opening remote catalog");
        Objects.requireNonNull(address, "Address cannot be null.");
        if (!(address instanceof URI) && !(address instanceof URL)) {
            throw new IllegalArgumentException("Address object must be a URI or URL.");
        }
        this.address_ = address;
    }

    @Override
    protected Object beginTask() {
        block12: {
            try {
                PanSourcesFrame sourcesFrame = PanSourcesFrame.getSharedInstance();
                URL url = null;
                if (this.address_ instanceof URL) {
                    url = (URL)this.address_;
                } else if (this.address_ instanceof URI) {
                    url = ((URI)this.address_).toURL();
                }
                sourcesFrame.addCatalog(url);
            }
            catch (Exception exc) {
                this.errorMsg_ = exc.toString().replaceFirst(".*HTTP", "HTTP");
                if (this.errorMsg_.contains("Connection refused")) {
                    this.errorMsg_ = "Connection was refused.";
                }
                if (this.errorMsg_.contains("FileNotFound") || this.errorMsg_.contains("404")) {
                    this.errorMsg_ = "No catalog was found at that address.";
                }
                if (this.errorMsg_.contains("401")) {
                    this.errorMsg_ = "User authentication is required.";
                }
                if (this.errorMsg_.contains("502")) {
                    this.errorMsg_ = "Unable to fulfill request, possibly due to an  upstream server error.";
                }
                if (this.errorMsg_.contains("503")) {
                    this.errorMsg_ = "Server seems to be refusing connection.";
                }
                if (this.errorMsg_.contains("ParseException") || this.errorMsg_.contains("parser")) {
                    this.errorMsg_ = "Unable to parse catalog XML.";
                }
                if (this.errorMsg_.contains("NcException")) {
                    this.errorMsg_ = exc.toString().replaceFirst(".*NcException: ", "");
                }
                LOGGER.warn("Unknown addCatalog response -\n{}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block12;
                exc.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.errorMsg_ != null) {
            GuiUtils.showSlowMessage(null, "File Error", "There was an error opening the remote address: " + this.errorMsg_);
            return;
        }
        PanSourcesFrame sourcesFrame = PanSourcesFrame.getSharedInstance();
        sourcesFrame.reveal();
        sourcesFrame.refresh();
    }
}

