/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.authentication;

import gov.nasa.giss.panoply.authentication.PanBasicAuthenticationDialog;
import gov.nasa.giss.panoply.authentication.PanCredentials;
import gov.nasa.giss.panoply.ui.PanFrame;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanAuthenticationManager
implements CredentialsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Hashtable<String, PanCredentials> cache_ = new Hashtable(5);
    private static String lastkey_;

    @Override
    public void clear() {
    }

    @Override
    public synchronized Credentials getCredentials(AuthScope scope) {
        LOGGER.trace("scope {}", (Object)scope);
        String key = scope.getHost() + ":" + scope.getPort() + ":" + scope.getRealm();
        PanCredentials creds = cache_.get(key);
        if (creds == null) {
            LOGGER.trace("credentials were chached {}", (Object)creds);
            if (!EventQueue.isDispatchThread()) {
                throw new RuntimeException("Authorization failed. Credentials request is only coded via dialog on Event Dispatch Thread.");
            }
            PanFrame aframe = PanFrame.getActiveFrame();
            PanBasicAuthenticationDialog dialog = new PanBasicAuthenticationDialog(aframe, scope);
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (!dialog.isSuccessful()) {
                return null;
            }
            creds = new PanCredentials(key, dialog.getUserid(), dialog.getPasswd());
            cache_.put(key, creds);
            lastkey_ = key;
        }
        try {
            return new UsernamePasswordCredentials(creds.getUserid(), creds.getPasswd());
        }
        catch (Exception exc) {
            LOGGER.trace("Exception cuilding UsernamePasswordCredentials");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        LOGGER.trace("");
    }

    public static void setLastCredentialsRejected() {
        LOGGER.trace("lastKey {}", (Object)lastkey_);
        if (lastkey_ != null) {
            cache_.remove(lastkey_);
        }
    }
}

