/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.cl;

import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.cl.PCLDimension;

public final class PCLVariable {
    private final NcVariable ncv_;

    public PCLVariable(NcVariable ncv) {
        this.ncv_ = ncv;
    }

    public NcVariable getNcVariable() {
        return this.ncv_;
    }

    public String getName() {
        return this.ncv_.getName();
    }

    public String getLongName() {
        return this.ncv_.getLongName();
    }

    public String getUnitsString() {
        return this.ncv_.getUnitsString();
    }

    public int getRank() {
        return this.ncv_.getRank();
    }

    public PCLDimension getDimension(int index) {
        return new PCLDimension(this.ncv_.getDimension(index - 1));
    }

    public double valueAt(int ... indices) {
        int[] shifted = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            shifted[i] = indices[i] - 1;
        }
        return this.ncv_.doubleValueAt(shifted);
    }
}

