/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.time.PatternTime;
import gov.nasa.giss.time.TimeFormatter;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanDataXTime
extends PanDataGeneral2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String timeFormat_;

    public PanDataXTime(NcArray nca, Dimension size) {
        this(nca, size.width, size.height);
    }

    public PanDataXTime(NcArray nca, int gridWidth, int gridHeight) {
        super(nca, gridWidth, gridHeight);
        this.setGridLeftAndRight(90.0, -90.0);
    }

    @Override
    protected void prepareXAxisUnits() {
    }

    @Override
    public void setXAxisUnits(String unitsStr) {
        LOGGER.trace("Cannot set X-axis units for [X]-time data grid.");
    }

    @Override
    public PanAxisMethod getXAxisMethod() {
        return PanAxisMethod.SCALAR;
    }

    @Override
    public void setXAxisMethod(PanAxisMethod method) {
        LOGGER.trace("Cannot set X-axis method for [X]-time data grid. Using SCALAR.");
    }

    @Override
    protected void prepareYAxisUnits() {
    }

    @Override
    public String getYAxisName() {
        return "Time";
    }

    @Override
    public String getYAxisUnits() {
        return "";
    }

    @Override
    public void setYAxisUnits(String unitsStr) {
        LOGGER.trace("Cannot set Y-axis units for [X]-time data grid.");
    }

    @Override
    public PanAxisMethod getYAxisMethod() {
        return PanAxisMethod.SCALAR;
    }

    @Override
    public void setYAxisMethod(PanAxisMethod method) {
        LOGGER.trace("Cannot set Y-axis method for degree-time data grid. Using SCALAR.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArray(int vindex, NcArray nca) {
        PanDataXTime panDataXTime = this;
        synchronized (panDataXTime) {
            NcArray2D nca2D;
            NcTimeAxis tax;
            super.setArray(vindex, nca);
            if (this.timeFormat_ == null && (tax = (NcTimeAxis)(nca2D = (NcArray2D)nca).getYAxis()).isPatternTime()) {
                PatternTime tt = (PatternTime)((Object)tax.getFormatter());
                this.timeFormat_ = tt.getPattern();
            }
        }
        this.updateTimeFormats();
    }

    public void setTimeFormat(String format) {
        this.timeFormat_ = format;
        this.updateTimeFormats();
    }

    private final void updateTimeFormats() {
        if (this.timeFormat_ == null) {
            return;
        }
        for (NcArray nca : this.ncArrays_) {
            TimeFormatter formatter;
            NcTimeAxis tax;
            if (nca == null || !(tax = (NcTimeAxis)((NcArray2D)nca).getYAxis()).isFormattedTime() || !((formatter = tax.getFormatter()) instanceof PatternTime)) continue;
            ((PatternTime)((Object)formatter)).applyPattern(this.timeFormat_);
        }
    }
}

