/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.help;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanHelpFrame
extends PanFrame
implements DocumentListener,
HyperlinkListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String HELP_PATH = "resources/";
    private static final String START_PAGE = "index.html";
    private static final String ERROR_PAGE = "error404.html";
    private static final int INIT_WIDTH = 640;
    private static final int INIT_HEIGHT = 480;
    private static final int MIN_WIDTH = 200;
    private static final int MIN_HEIGHT = 200;
    private JPanel contentBox_;
    private JEditorPane editorPane_;

    public static PanHelpFrame getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanHelpFrame() {
        super("Help");
        this.setName(this.getTitle());
        if (PlatformUtils.isWindows()) {
            this.setTitle("Panoply: " + this.getTitle());
        }
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.setPanMenuBar(new PanMenuBar(this));
        this.createLayout();
        this.placeOnScreen();
    }

    private final void createLayout() {
        String rpath = "resources/index.html";
        URL url = PanHelpFrame.class.getResource("resources/index.html");
        try {
            this.editorPane_ = new JEditorPane(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.editorPane_ == null) {
            this.editorPane_ = new JEditorPane("text/html", "<html><head><title>Error</title><head><body><p>Could not load start page.</p><pre></pre></body></html>");
        }
        this.editorPane_.setEditable(false);
        this.editorPane_.addHyperlinkListener(this);
        HTMLDocument doc = (HTMLDocument)this.editorPane_.getDocument();
        doc.addDocumentListener(this);
        Rectangle rr = GuiUtils.getActiveScreenBounds();
        if (rr == null) {
            this.editorPane_.setPreferredSize(new Dimension(400, 460));
        } else {
            this.editorPane_.setPreferredSize(new Dimension(Math.min(2 * rr.width / 3, 720), 2 * rr.height / 3));
        }
        JScrollPane scrollPane = new JScrollPane(this.editorPane_);
        scrollPane.setBorder(PanGuiConstants.NO_BORDER);
        if (PlatformUtils.isMacintosh()) {
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setHorizontalScrollBarPolicy(30);
        }
        this.contentBox_ = new JPanel();
        this.contentBox_.setLayout(new BoxLayout(this.contentBox_, 1));
        this.contentBox_.setBorder(PanGuiConstants.NO_BORDER);
        this.contentBox_.add(scrollPane);
        this.contentBox_.add(this.getStatusBar());
        this.contentBox_.setPreferredSize(new Dimension(640, 480));
        this.getContentPane().add(this.contentBox_);
        this.pack();
        this.setMinimumSize(new Dimension(200, 200));
        this.setPreferredSize(new Dimension(640, 480));
    }

    @Override
    public void doLayout() {
        if (this.getWidth() < 200 || this.getHeight() < 200) {
            int w = Math.max(this.getWidth(), 200);
            int h = Math.max(this.getHeight(), 200);
            this.setSize(new Dimension(w, h));
        }
        super.doLayout();
    }

    public void setPage(String fname) {
        URL url = PanHelpFrame.class.getResource(HELP_PATH + fname);
        try {
            this.setPage(url);
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.displayExcMessage(exc.toString());
        }
    }

    public void setPage(URL url) {
        try {
            this.editorPane_.setPage(url);
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.displayExcMessage(exc.toString());
        }
        HTMLDocument doc = (HTMLDocument)this.editorPane_.getDocument();
        doc.addDocumentListener(this);
    }

    private void displayExcMessage(String excMessage) {
        this.editorPane_.setText("<html><head><title>Error</title><head><body><p>Could not load page.</p><pre>" + excMessage + "</pre></body></html>");
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        Document doc = this.editorPane_.getDocument();
        if (doc instanceof HTMLDocument) {
            this.setTitle((String)((HTMLDocument)doc).getProperty("title"));
        } else if (PlatformUtils.isWindows()) {
            this.setTitle("Panoply: Help");
        } else {
            this.setTitle("Help");
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (e instanceof HTMLFrameHyperlinkEvent) {
            return;
        }
        try {
            String s = e.getURL().toString();
            if (s.matches("(https|https|ftp|file):.*")) {
                FileUtils.openBrowserURL(s);
            } else if (s.startsWith("mailto:")) {
                FileUtils.openMailtoURL(s);
            } else if (s.startsWith("jar:file:")) {
                this.setPage(e.getURL());
            }
            return;
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            try {
                this.setPage(PanHelpFrame.class.getResource("resources/error404.html"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public void resizeToFitDisplay() {
        if (this.contentBox_ == null) {
            LOGGER.trace("sp is null");
            return;
        }
        Dimension dd = this.getSize();
        Rectangle rr = this.isVisible() ? GuiUtils.getFrameScreenBounds(this) : GuiUtils.getActiveScreenBounds();
        Insets ins = this.isVisible() ? GuiUtils.getFrameScreenInsets(this) : GuiUtils.getActiveScreenInsets();
        int insW = Math.max(24, ins.left + ins.right);
        int insH = Math.max(24, ins.top + ins.bottom);
        int availW = rr.width - insW;
        int availH = rr.height - insH;
        int excessW = Math.max(0, dd.width - availW);
        int excessH = Math.max(0, dd.height - availH);
        Dimension bbSize = this.contentBox_.getSize();
        bbSize.width -= excessW;
        bbSize.height -= excessH;
        this.contentBox_.setPreferredSize(bbSize);
        this.contentBox_.invalidate();
        this.contentBox_.validate();
        this.pack();
        this.repaint();
    }

    private static class Singleton {
        private static final PanHelpFrame INSTANCE = new PanHelpFrame();

        private Singleton() {
        }
    }
}

