/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanBiggerPlotAction;
import gov.nasa.giss.panoply.action.PanPlotSizeAction;
import gov.nasa.giss.panoply.action.PanSmallerPlotAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotSize;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.menu.GissCheckBoxMenuItem;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public class PanPlotSizeMenu
extends PanMenu {
    private final JMenuItem miCurrentSize_;
    private final JMenuItem miBigger_;
    private final JMenuItem miSmaller_;
    private final Hashtable<String, JCheckBoxMenuItem> miPresetsHash_ = new Hashtable(20);

    public PanPlotSizeMenu(PanFrame parent) {
        super(parent, "plot-size-menu");
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        this.miCurrentSize_ = this.makeItemFromProperties("current-size", null);
        this.add(this.miCurrentSize_).setEnabled(false);
        this.addSeparator();
        AbstractAction a = parentIsPlot ? new PanBiggerPlotAction((PanPlotFrame)parent) : null;
        this.miBigger_ = this.makeItemFromProperties("show-bigger", a);
        this.add(this.miBigger_).setEnabled(false);
        a = parentIsPlot ? new PanSmallerPlotAction((PanPlotFrame)parent) : null;
        this.miSmaller_ = this.makeItemFromProperties("show-smaller", a);
        this.add(this.miSmaller_).setEnabled(false);
        this.addSeparator();
        for (PanPlotSize psize : PanPlotSize.values()) {
            String aid = psize.getActionID();
            if (aid == null) continue;
            String atext = psize.toString();
            PanPlotSizeAction a2 = parentIsPlot && aid != null ? new PanPlotSizeAction((PanPlotFrame)parent, psize) : null;
            GissCheckBoxMenuItem mi = aid != null ? this.makeCheckBoxItemFromProperties(aid, a2) : this.makeCheckBoxItem(atext, a2);
            this.miPresetsHash_.put(aid, mi);
            this.add(mi).setEnabled(parentIsPlot);
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        if (this.pframe_ == null) {
            return;
        }
        if (this.pframe_ instanceof PanPlotFrame) {
            int sf = ((PanPlotFrame)this.pframe_).getSizeFactor();
            this.miCurrentSize_.setText(PanProperties.MENU_PROPS.getString("current-size") + " = " + sf);
            this.miBigger_.setEnabled(sf < 300);
            this.miSmaller_.setEnabled(sf > 80);
            for (String key : this.miPresetsHash_.keySet()) {
                JCheckBoxMenuItem mi = this.miPresetsHash_.get(key);
                String text = mi.getText();
                PanPlotSize psize = PanPlotSize.matching(text);
                boolean matches = psize != null && psize.getSizeFactor() == sf;
                mi.setSelected(matches);
            }
        }
    }
}

