/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.panoply.data.PanDataTime1D;
import gov.nasa.giss.panoply.plot.PanLinePlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanScaleMeta;
import gov.nasa.giss.panoply.plot.PanScaleTick;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanHorizontalLinePlot
extends PanLinePlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PrintfFormat xaxisFormatter_ = new PrintfFormat("%.0f");
    protected boolean hasPatternTimeAxis_ = this.data1D_ instanceof PanDataTime1D;

    public PanHorizontalLinePlot(PanPlotMeta pmeta) {
        super(pmeta);
        if (this.hasPatternTimeAxis_) {
            String s = ((PanDataTime1D)this.data1D_).getAxisPattern();
            this.pmeta_.setString("xaxis.tick.format", s);
        }
        this.parameterChangedPrivate("all");
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        double yval;
        double xval;
        this.prepareToPaint();
        if (x < (double)this.gridLeft_ || x > (double)this.gridRight_) {
            return null;
        }
        if (y < (double)this.gridTop_ || y > (double)this.gridBottom_) {
            return null;
        }
        switch (this.xaxisMethod_) {
            case LOG10: {
                xval = this.logLeft_ + (this.logRight_ - this.logLeft_) * (x - (double)this.gridLeft_) / (double)this.gridWidth_;
                xval = Math.pow(10.0, xval);
                break;
            }
            default: {
                xval = this.lBound_ + (this.rBound_ - this.lBound_) * (x - (double)this.gridLeft_) / (double)this.gridWidth_;
            }
        }
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                yval = scaleMin - (logScaleMax - logScaleMin) * (y - (double)this.gridBottom_) / (double)this.gridHeight_;
                yval = Math.pow(10.0, yval);
                break;
            }
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                yval = logScaleMin - (logScaleMax - logScaleMin) * (y - (double)this.gridBottom_) / (double)this.gridHeight_;
                yval = Math.pow(Math.E, yval);
                break;
            }
            default: {
                yval = scaleMin - (scaleMax - scaleMin) * (y - (double)this.gridBottom_) / (double)this.gridHeight_;
            }
        }
        return new Point2D.Double(xval, yval);
    }

    @Override
    protected void drawXAxis(Graphics2D g2d) {
        if (this.axesOffset_ && this.includesAxes_) {
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.borderStroke_);
            GraphicUtils.drawLine(g2d, this.gridLeft_, this.xAxisY_, this.gridRight_, this.xAxisY_);
        }
        switch (this.xaxisMethod_) {
            case LOG10: {
                this.drawLogXAxisTicks(g2d);
                break;
            }
            default: {
                this.drawScalarXAxisTicks(g2d);
            }
        }
    }

    private final void drawScalarXAxisTicks(Graphics2D g2d) {
        NcTimeAxis timeAxis = null;
        if (this.hasPatternTimeAxis_) {
            timeAxis = (NcTimeAxis)this.data1D_.getAxis();
        }
        int divs = this.xMajorDiv_ * this.xMinorDiv_;
        float invDivs = 1.0f / (float)divs;
        double delta = (this.rBound_ - this.lBound_) * (double)invDivs;
        for (int i = 0; i <= divs; ++i) {
            boolean isMajor;
            double value = this.lBound_ + (double)i * delta;
            float x = this.gridLeft_ + (float)i * this.gridWidth_ * invDivs;
            boolean isNearEdge = Math.abs(x - this.gridLeft_) < EDGE_TOLERANCE || Math.abs(x - this.gridRight_) < EDGE_TOLERANCE;
            boolean bl = isMajor = i % this.xMinorDiv_ == 0;
            if (isMajor) {
                String label = null;
                label = timeAxis == null ? this.xaxisFormatter_.sprintg(value) : timeAxis.formatValue(value);
                this.drawXAxisTickLabel(g2d, label, x);
                if (this.gridStroke_ != null && !isNearEdge) {
                    g2d.setColor(this.gridColor_);
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridBottom_);
                }
            }
            float tt = isMajor ? this.tickLengthMajor_ : this.tickLengthMinor_;
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.tickStroke_);
            if (this.axesOffset_ && this.includesAxes_) {
                GraphicUtils.drawLine(g2d, x, this.xAxisY_ + 0.5f * tt, x, this.xAxisY_ - 0.5f * tt);
                continue;
            }
            if (isNearEdge) continue;
            GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridTop_ + tt);
            GraphicUtils.drawLine(g2d, x, this.gridBottom_, x, this.gridBottom_ - tt);
        }
    }

    protected final void drawLogXAxisTicks(Graphics2D g2d) {
        if (this.hasPatternTimeAxis_) {
            LOGGER.warn("Cannot draw log ticks for a time axis.");
            return;
        }
        double logrange = this.logRight_ - this.logLeft_;
        double logmin = Math.min(this.logLeft_, this.logRight_);
        double logmax = Math.max(this.logLeft_, this.logRight_);
        int iMin = (int)Math.floor(logmin) - 1;
        int iMax = (int)Math.floor(logmax) + 1;
        int intDiv = iMax - iMin;
        int intStep = (intDiv - 2) / 10 + 1;
        boolean majorMarked = false;
        block0: for (int j = iMin; j <= iMax; ++j) {
            double value0 = Math.pow(10.0, j);
            for (int k = 0; k < 9; ++k) {
                boolean isNearEdge;
                double value;
                double logval;
                if (k > 0 && intDiv > 20 || (logval = Math.log10(value = value0 * (1.0 + (double)k))) < logmin) continue;
                if (logval > logmax) continue block0;
                float pct = (float)((logval - this.logLeft_) / logrange);
                float x = this.gridLeft_ + pct * this.gridWidth_;
                if (x < this.gridLeft_ || x > this.gridRight_) continue;
                boolean bl = isNearEdge = Math.abs(x - this.gridLeft_) < EDGE_TOLERANCE || Math.abs(x - this.gridRight_) < EDGE_TOLERANCE;
                if (k == 0 && j % intStep == 0) {
                    String label = this.xaxisFormatter_.sprintg(Math.pow(10.0, j));
                    this.drawXAxisTickLabel(g2d, label, x);
                    if (this.gridStroke_ != null && !isNearEdge) {
                        g2d.setColor(this.gridColor_);
                        g2d.setStroke(this.gridStroke_);
                        GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridBottom_);
                    }
                    majorMarked = true;
                }
                float tt = k == 0 ? this.tickLengthMajor_ : this.tickLengthMinor_;
                g2d.setColor(this.getForeground());
                g2d.setStroke(this.tickStroke_);
                if (this.axesOffset_ && this.includesAxes_) {
                    GraphicUtils.drawLine(g2d, x, this.xAxisY_ + 0.5f * tt, x, this.xAxisY_ - 0.5f * tt);
                    continue;
                }
                if (isNearEdge) continue;
                GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridTop_ + tt);
                GraphicUtils.drawLine(g2d, x, this.gridBottom_, x, this.gridBottom_ - tt);
            }
        }
        if (!majorMarked) {
            g2d.setColor(this.getForeground());
            if (this.axesOffset_) {
                g2d.setStroke(this.tickStroke_);
                float tt = this.tickLengthMinor_;
                GraphicUtils.drawLine(g2d, this.gridLeft_, this.xAxisY_ + 0.5f * tt, this.gridLeft_, this.xAxisY_ - 0.5f * tt);
                GraphicUtils.drawLine(g2d, this.gridRight_, this.xAxisY_ + 0.5f * tt, this.gridRight_, this.xAxisY_ - 0.5f * tt);
            }
            String label = this.xaxisFormatter_.sprintg(Math.pow(10.0, this.logTop_));
            this.drawXAxisTickLabel(g2d, label, this.gridLeft_);
            label = this.xaxisFormatter_.sprintg(Math.pow(10.0, this.logBottom_));
            this.drawXAxisTickLabel(g2d, label, this.gridRight_);
        }
    }

    @Override
    protected String getXAxisLabel() {
        return this.xaxisLabelText_ == null ? this.data1D_.getAxisLabel() : this.xaxisLabelText_;
    }

    @Override
    protected int drawYAxis(Graphics2D g2d) {
        return this.drawScaleTicks(g2d);
    }

    private int drawScaleTicks(Graphics2D g2d) {
        PanScaleTick[] ticks;
        double ydelta;
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        PrintfFormat formatter = smeta.getFormatter();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            default: {
                ydelta = (scaleMax - scaleMin) / (double)this.gridHeight_;
            }
        }
        double yscale = 1.0 / ydelta;
        int maxLabelWidth = 0;
        if (this.axesOffset_ && this.includesAxes_) {
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.borderStroke_);
            GraphicUtils.drawLine(g2d, this.yAxisX_, this.gridTop_, this.yAxisX_, this.gridBottom_);
        }
        for (PanScaleTick tick : ticks = smeta.getTicks()) {
            boolean isNearEdge;
            float y;
            double value = tick.getValue();
            double logValue = tick.getAlternativeValue();
            switch (smethod) {
                case LOG10: 
                case LOG_E: {
                    y = (float)((logValue - logScaleMin) * yscale);
                    break;
                }
                default: {
                    y = (float)((value - scaleMin) * yscale);
                }
            }
            y = this.gridBottom_ - y;
            boolean bl = isNearEdge = Math.abs(y - this.gridTop_) < EDGE_TOLERANCE || Math.abs(y - this.gridBottom_) < EDGE_TOLERANCE;
            if (tick.isMajor()) {
                Object label;
                switch (smethod) {
                    case LOG_E: {
                        label = PanGraphicUtils.getSuperscriptedE(logValue, this.yAxisTickFont_);
                        break;
                    }
                    default: {
                        label = formatter.sprintg(value);
                    }
                }
                int labelWidth = this.drawYAxisTickLabel(g2d, label, y);
                maxLabelWidth = Math.max(maxLabelWidth, labelWidth);
                if (this.gridStroke_ != null && !isNearEdge) {
                    g2d.setColor(this.gridColor_);
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridRight_, y);
                }
            }
            float tt = tick.isMajor() ? this.tickLengthMajor_ : this.tickLengthMinor_;
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.tickStroke_);
            if (this.axesOffset_ && this.includesAxes_) {
                GraphicUtils.drawLine(g2d, this.yAxisX_ - 0.5f * tt, y, this.yAxisX_ + 0.5f * tt, y);
                continue;
            }
            if (isNearEdge) continue;
            GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridLeft_ + tt, y);
            GraphicUtils.drawLine(g2d, this.gridRight_, y, this.gridRight_ - tt, y);
        }
        return maxLabelWidth;
    }

    @Override
    protected String getYAxisLabel() {
        return this.scaleCaption_;
    }

    @Override
    protected void drawCurve(Graphics2D g2d) {
        double ydelta;
        Rectangle oldClip = g2d.getClipBounds();
        Rectangle rr = new Rectangle((int)this.gridLeft_, (int)this.gridTop_ - 8, (int)this.gridWidth_, (int)this.gridHeight_ + 16);
        Rectangle ri = oldClip.intersection(rr);
        g2d.setClip(ri);
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        boolean isLogScale = false;
        boolean isLogAxis = this.xaxisMethod_ == PanAxisMethod.LOG10;
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                isLogScale = true;
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            case LOG_E: {
                isLogScale = true;
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            default: {
                isLogScale = false;
                ydelta = (scaleMax - scaleMin) / (double)this.gridHeight_;
            }
        }
        double yscale = 1.0 / ydelta;
        double xdelta = isLogAxis ? (this.logRight_ - this.logLeft_) / (double)this.gridWidth_ : (this.rBound_ - this.lBound_) / (double)this.gridWidth_;
        double xscale = 1.0 / xdelta;
        double value = this.data1D_.valueAt(0, 0);
        int istrokes = this.isCompare_ ? 2 : 1;
        for (int istroke = 0; istroke < istrokes; ++istroke) {
            if (this.lineStrokes_[istroke] == null) continue;
            g2d.setColor(this.lineColors_[istroke]);
            g2d.setStroke(this.lineStrokes_[istroke]);
            boolean lastPtWasGood = false;
            GeneralPath path = new GeneralPath();
            int numPts = this.data1D_.getAxisLength(istroke);
            for (int j = 0; j < numPts; ++j) {
                float x;
                value = this.data1D_.valueAt(istroke, j);
                double axisX = this.data1D_.axisValueAt(istroke, j);
                if (!Double.isNaN(value) && !Double.isInfinite(value)) {
                    switch (smethod) {
                        case LOG10: {
                            value = Math.log10(value);
                            break;
                        }
                        case LOG_E: {
                            value = Math.log(value);
                            break;
                        }
                    }
                }
                if (Double.isNaN(value)) {
                    if (lastPtWasGood) {
                        g2d.draw(path);
                        path.reset();
                    }
                    lastPtWasGood = false;
                    continue;
                }
                float y = Double.isInfinite(value) ? (value < 0.0 ? -1.0E9f : 1.0E9f) : (isLogScale ? (float)((value - logScaleMin) * yscale) : (float)((value - scaleMin) * yscale));
                if (isLogAxis) {
                    if (Double.isNaN(axisX = Math.log10(axisX))) {
                        if (lastPtWasGood) {
                            g2d.draw(path);
                            path.reset();
                        }
                        lastPtWasGood = false;
                        continue;
                    }
                    x = (float)((axisX - this.logLeft_) * xscale);
                } else {
                    x = (float)((axisX - this.lBound_) * xscale);
                }
                if (lastPtWasGood) {
                    path.lineTo(this.gridLeft_ + x, this.gridBottom_ - y);
                } else {
                    path.moveTo(this.gridLeft_ + x, this.gridBottom_ - y);
                }
                lastPtWasGood = true;
            }
            g2d.draw(path);
            path.reset();
        }
        g2d.setClip(oldClip);
    }

    @Override
    public String describePoint(int x, int y) {
        NcTimeAxis tax;
        Point2D.Double p2dClose;
        double ydelta;
        Point2D.Double p2d = this.transformXY2GridCoords(x, y);
        if (p2d == null) {
            return null;
        }
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            default: {
                ydelta = (scaleMax - scaleMin) / (double)this.gridHeight_;
            }
        }
        double yscale = 1.0 / ydelta;
        double leastDY = -1.0;
        int dixForLeast = -1;
        int istrokes = this.isCompare_ ? 2 : 1;
        for (int istroke = 0; istroke < istrokes; ++istroke) {
            for (int dix = -3; dix <= 3; ++dix) {
                float dy;
                double value;
                p2dClose = this.transformXY2GridCoords(x + dix, y);
                if (p2dClose == null || Double.isNaN(value = this.data1D_.valueAtAxisPt(istroke, p2dClose.x)) || Double.isInfinite(value)) continue;
                switch (smethod) {
                    case LOG10: {
                        value = Math.log10(value);
                        break;
                    }
                    case LOG_E: {
                        value = Math.log(value);
                        break;
                    }
                }
                if (Double.isNaN(value)) continue;
                switch (smethod) {
                    case LOG10: 
                    case LOG_E: {
                        dy = Double.isNaN(value) ? 1000.0f : (float)((double)y - ((double)this.gridBottom_ - (value - logScaleMin) * yscale));
                        break;
                    }
                    default: {
                        dy = Double.isNaN(value) ? 1000.0f : (float)((double)y - ((double)this.gridBottom_ - (value - scaleMin) * yscale));
                    }
                }
                double absDY = Math.abs(dy);
                if (!(leastDY < 0.0) && !(absDY < leastDY)) continue;
                leastDY = absDY;
                dixForLeast = dix;
            }
        }
        if (leastDY < 0.0 || leastDY > 10.0) {
            return null;
        }
        p2dClose = this.transformXY2GridCoords(x + dixForLeast, y);
        StringBuilder sb = new StringBuilder();
        sb.append("X: ").append(PrintfFormat.PFORMAT_7G.sprintg(p2dClose.x));
        if (this.hasPatternTimeAxis_ && (tax = (NcTimeAxis)this.data1D_.getAxis()) != null) {
            sb.append(" (Time ").append(tax.formatValue(p2dClose.x)).append(")");
        }
        sb.append('\n');
        this.data1D_.describeDataAtAxisPt(sb, p2dClose.x);
        return sb.toString();
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("xaxis.tick.format")) {
            String s = this.pmeta_.getString("xaxis.tick.format");
            if (s == null) {
                LOGGER.debug("Property {} has null value", (Object)"xaxis.tick.format");
                throw new RuntimeException("Null format string");
            }
            if (this.hasPatternTimeAxis_) {
                ((PanDataTime1D)this.data_).setAxisPattern(s);
            } else {
                this.xaxisFormatter_ = new PrintfFormat(s);
            }
        }
    }
}

