/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.TextUtils;
import gov.nasa.giss.graphics.plot.PlotPieceMargins;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class PanPlotLabel
extends PanPlotPiece {
    private String text_;
    private HAlignment hAlignment_ = HAlignment.CENTER;
    private VAlignment vAlignment_ = VAlignment.TOP;

    public PanPlotLabel(PanPlotMeta pmeta) {
        this(pmeta, "");
    }

    public PanPlotLabel(PanPlotMeta pmeta, String text) {
        this(pmeta, text, HAlignment.CENTER, VAlignment.TOP);
    }

    public PanPlotLabel(PanPlotMeta pmeta, String text, HAlignment hAlignment) {
        this(pmeta, text, hAlignment, VAlignment.TOP);
    }

    public PanPlotLabel(PanPlotMeta pmeta, String text, HAlignment hAlignment, VAlignment vAlignment) {
        super(pmeta);
        this.setText(text);
        this.setHorizontalAlignment(hAlignment);
        this.setVerticalAlignment(vAlignment);
        this.setOpaque(false);
        this.parameterChangedPrivate("all");
    }

    public String getText() {
        return this.text_;
    }

    public final void setText(String text) {
        this.text_ = text;
    }

    public HAlignment getHorizontalAlignment() {
        return this.hAlignment_;
    }

    public final void setHorizontalAlignment(HAlignment alignment) {
        this.hAlignment_ = alignment;
    }

    public VAlignment getVerticalAlignment() {
        return this.vAlignment_;
    }

    public final void setVerticalAlignment(VAlignment alignment) {
        this.vAlignment_ = alignment;
    }

    public void setFontSize(float fh) {
        this.setFont(this.getFont().deriveFont(fh));
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(gx);
        PlotPieceMargins margins = this.getMargins();
        int width = this.getWidth();
        int height = this.getHeight();
        Font f = this.getFont();
        g2d.setFont(f);
        g2d.setColor(this.getForeground());
        FontMetrics fm = g2d.getFontMetrics(f);
        String ttt = TextUtils.trimStringToFit(this.text_, fm, width);
        int tascent = fm.getAscent();
        int twidth = fm.stringWidth(ttt);
        int theight = fm.getHeight();
        int x = this.hAlignment_ == HAlignment.CENTER ? (width - twidth) / 2 : (this.hAlignment_ == HAlignment.RIGHT ? width - margins.right - twidth : margins.left);
        int y = this.vAlignment_ == VAlignment.MIDDLE ? (height - theight) / 2 : (this.vAlignment_ == VAlignment.BOTTOM ? height - margins.bottom : margins.top + tascent);
        g2d.drawString(ttt, x, y);
        g2d.dispose();
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("color.background")) {
            this.setBackground(this.pmeta_.getColor("color.background"));
        }
        if (changeAll || pname.contains("font.master") || pname.contains("size.factor")) {
            String fn = this.pmeta_.getString("font.master");
            Font f = this.getFont();
            float fhgt = f != null ? f.getSize2D() : 9.0f;
            this.setFont(PanGraphicUtils.getFont(fn, fhgt));
        }
    }

    public static enum VAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    public static enum HAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

