/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.util.PanPlotType;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotLayoutMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int GWIDTH100 = 720;
    private static final int MARGIN100 = 6;
    private static final int GAP100 = 5;
    private boolean needsUpdate_ = true;
    private final Hashtable<String, Object> layoutHash_ = new Hashtable(25);
    private final PanPlotMeta pmeta_;

    PanPlotLayoutMeta(PanPlotMeta pmeta) {
        this.pmeta_ = pmeta;
    }

    private synchronized void update() {
        PanPlot pplot;
        int sfactor = (Integer)this.layoutHash_.get("size.factor");
        float scaling = 0.01f * (float)sfactor;
        float hfactor = 0.01f * (float)((Integer)this.layoutHash_.get("size.height")).intValue();
        float wfactor = 0.01f * (float)((Integer)this.layoutHash_.get("size.width")).intValue();
        boolean includeTitles = (Boolean)this.layoutHash_.get("include.title");
        boolean includeScale = (Boolean)this.layoutHash_.get("include.scale");
        boolean includeAxes = (Boolean)this.layoutHash_.get("include.axes");
        boolean includeNotes = (Boolean)this.layoutHash_.get("include.footnotes");
        boolean includeMargins = (Boolean)this.layoutHash_.get("include.margins");
        float titleFHeight = scaling * ((Float)this.layoutHash_.get("title.size")).floatValue();
        float subtitleFHeight = scaling * ((Float)this.layoutHash_.get("subtitle.size")).floatValue();
        float axesFHeight = 12.0f * scaling;
        float notesFHeight = scaling * ((Float)this.layoutHash_.get("footnote.size")).floatValue();
        int wmain = (int)(720.0f * scaling + 4.0f * scaling);
        if (wmain % 2 > 0) {
            ++wmain;
        }
        int wgridding = (int)(720.0f * scaling * wfactor);
        int hgridding = (int)(720.0f * scaling * hfactor);
        if (wgridding % 2 > 0) {
            ++wgridding;
        }
        if (hgridding % 2 > 0) {
            ++hgridding;
        }
        int hmain = (int)((float)hgridding + 4.0f * scaling);
        PanPlotType plotType = this.pmeta_.getType();
        if (includeAxes && (plotType != PanPlotType.LON_LAT || plotType == PanPlotType.LL_TRAJ)) {
            hmain += (int)(3.5 * (double)axesFHeight);
        }
        if (hmain % 2 > 0) {
            ++hmain;
        }
        if (wmain % 2 > 0) {
            ++wmain;
        }
        int xmargin = 0;
        int ymargin = 0;
        int wtotal = wmain;
        if (includeMargins) {
            int minMargin = (int)(6.0f * scaling);
            wtotal += minMargin;
            ymargin = minMargin;
        }
        wtotal = wtotal / 16 * 16 + (wtotal % 16 > 0 ? 16 : 0);
        xmargin = (wtotal - wmain) / 2;
        int vgap = (int)(5.0f * scaling);
        Rectangle titleBounds = new Rectangle();
        Rectangle subtitleBounds = new Rectangle();
        Rectangle figureBounds = new Rectangle();
        Rectangle scaleBounds = new Rectangle();
        Rectangle noteBounds = new Rectangle();
        int y = 0;
        if (includeMargins) {
            y += ymargin;
        }
        if (includeTitles) {
            titleBounds.x = xmargin;
            titleBounds.y = y;
            titleBounds.width = wmain;
            titleBounds.height = (int)(1.25 * (double)titleFHeight);
            y += titleBounds.height;
            subtitleBounds.x = xmargin;
            subtitleBounds.y = y += vgap / 2;
            subtitleBounds.width = wmain;
            subtitleBounds.height = (int)(1.25 * (double)subtitleFHeight);
            y += subtitleBounds.height;
            y += vgap;
        }
        figureBounds.x = xmargin;
        figureBounds.y = y;
        figureBounds.width = wmain;
        figureBounds.height = hmain;
        y += figureBounds.height;
        if (includeScale) {
            scaleBounds.x = xmargin;
            scaleBounds.y = y += vgap;
            scaleBounds.width = wmain;
            scaleBounds.height = plotType.isLinePlot() ? (int)(2.0f * axesFHeight) : (int)Math.max(32.0, 48.0 * (double)scaling);
            y += scaleBounds.height;
        } else {
            scaleBounds.x = xmargin;
            scaleBounds.y = y;
            scaleBounds.width = wmain;
            scaleBounds.height = plotType.isLinePlot() ? (int)(2.0f * axesFHeight) : (int)Math.max(32.0, 48.0 * (double)scaling);
            scaleBounds.y = -scaleBounds.height;
        }
        if (includeNotes) {
            noteBounds.x = xmargin;
            noteBounds.y = y += vgap;
            noteBounds.width = wmain / 2;
            noteBounds.height = (int)(1.25 * (double)notesFHeight);
            y += noteBounds.height;
        }
        if (includeMargins) {
            y += ymargin;
        }
        int htotal = y / 16 * 16 + (y % 16 > 0 ? 16 : 0);
        int yextra = htotal - y;
        if (includeNotes) {
            if (yextra > 6) {
                noteBounds.y += 4;
                yextra -= 4;
            } else if (yextra > 2) {
                noteBounds.y += 2;
                yextra -= 2;
            }
        }
        int yshift = yextra / 2;
        if (includeTitles) {
            titleBounds.y += yshift;
            subtitleBounds.y += yshift;
        }
        figureBounds.y += yshift;
        if (includeScale) {
            scaleBounds.y += yshift;
        }
        if (includeNotes) {
            noteBounds.y += yshift;
        }
        Rectangle noteBoundsLeft = (Rectangle)noteBounds.clone();
        Rectangle noteBoundsCenter = (Rectangle)noteBounds.clone();
        Rectangle noteBoundsRight = (Rectangle)noteBounds.clone();
        if (includeNotes) {
            noteBoundsLeft.width = wmain / 2;
            noteBoundsCenter.width = wmain / 2;
            noteBoundsRight.width = wmain / 2;
            int ddy = htotal - (noteBounds.y + noteBounds.height);
            noteBoundsCenter.x = xmargin + wmain / 4;
            noteBoundsLeft.x = ddy;
            noteBoundsRight.x = wtotal - ddy - noteBoundsRight.width;
        }
        int vlength = (int)(20.0 * (double)scaling);
        Dimension plotSize = new Dimension(wtotal, htotal);
        Dimension gridSize = new Dimension(wgridding, hgridding);
        this.layoutHash_.put("size.pixels", plotSize);
        this.layoutHash_.put("size.gridding", gridSize);
        this.layoutHash_.put("bounds.figure", figureBounds);
        this.layoutHash_.put("bounds.title", titleBounds);
        this.layoutHash_.put("bounds.subtitle", subtitleBounds);
        this.layoutHash_.put("bounds.scale", scaleBounds);
        this.layoutHash_.put("bounds.note.left", noteBoundsLeft);
        this.layoutHash_.put("bounds.note.center", noteBoundsCenter);
        this.layoutHash_.put("bounds.note.right", noteBoundsRight);
        this.layoutHash_.put("vector.length", vlength);
        this.needsUpdate_ = false;
        PanData pdata = this.pmeta_.getData();
        if (pdata instanceof PanData2D) {
            ((PanData2D)pdata).setSize(wgridding, hgridding);
        }
        if ((pplot = this.pmeta_.getPlot()) != null) {
            pplot.setSize(plotSize);
        }
    }

    public Object getParam(String pkey) {
        if (this.needsUpdate_) {
            this.update();
        }
        return this.layoutHash_.get(pkey);
    }

    public void setParam(String pkey, Object pvalue) {
        this.needsUpdate_ = true;
        this.layoutHash_.put(pkey, pvalue);
    }
}

