/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableOutlierShape;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.TextUtils;
import gov.nasa.giss.graphics.plot.PlotPieceMargins;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.plot.PanScaleMeta;
import gov.nasa.giss.panoply.plot.PanScaleTick;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanScaleCaptionLocation;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.panoply.util.PanVectorStyle;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.lang.invoke.MethodHandles;
import java.text.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanScaleColorbar
extends PanPlotPiece {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double COS45 = Math.cos(Math.toRadians(45.0));
    private final PanData data_;
    private AbstractColorTable colortable_;
    private float widthFactor_ = 0.5f;
    private boolean reversed_;
    private boolean useDefaultCaption_ = true;
    private String userCaption_ = "";
    private PanScaleCaptionLocation captionLoc_ = PanScaleCaptionLocation.ABOVE;
    private String formatString_ = "%.0f";
    private PrintfFormat formatter_;
    private Font captionFont_;
    private int captionY_;
    private int barHeight_;
    private int barTopY_;
    private int barBottomY_;
    private Font ticksFont_;
    private int ticksY_;
    private PanColorbarOutlierSide oside_;
    private ColorTableOutlierShape oshape_;
    private PanColorbarOutlierGap ogap_;
    private boolean outlierOnLeft_;
    private boolean outlierOnRight_;
    private boolean outlierFlushLeft_;
    private boolean outlierFlushRight_;
    private float outlierGap_;
    private float outlierWidth_;
    private float minX_;
    private float maxX_;
    private float barWidth_;
    private float barLeft_;
    private float barRight_;
    private float vectorLeft_;
    private float vectorLength_;
    private BasicStroke borderStroke_;
    private PanVectorStyle vectorStyle_;
    private int vectorWeight_;
    private BasicStroke vectorStroke_;
    private boolean needsResize_ = true;

    public PanScaleColorbar(PanPlotMeta pmeta, PanData data) {
        super(pmeta);
        this.data_ = data;
        this.setOpaque(false);
        this.formatter_ = new PrintfFormat(this.formatString_);
        this.parameterChangedPrivate("all");
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.needsResize_ = true;
    }

    @Override
    protected void prepareToPaint() {
        String caption;
        LOGGER.trace("");
        super.prepareToPaint();
        if (!this.needsResize_) {
            return;
        }
        String fn = this.pmeta_.getString("font.master");
        int width = this.getWidth();
        PlotPieceMargins margins = this.getMargins();
        float scaling = 0.01f * (float)this.pmeta_.getInt("size.factor");
        this.barHeight_ = (int)((double)scaling * 14.0 + 0.5);
        float tickBaseSize = this.pmeta_.getFloat("scale.tick.size");
        float captionBaseSize = 24.0f - tickBaseSize;
        float captionFHeight = scaling * captionBaseSize + 0.5f;
        float ticksFHeight = scaling * tickBaseSize + 0.5f;
        int gap1 = Math.max(4, (int)(scaling * 4.0f + 0.5f));
        int gap2 = Math.max(2, (int)(scaling * 2.0f + 0.5f));
        this.captionFont_ = PanGraphicUtils.getFont(fn, captionFHeight);
        this.ticksFont_ = PanGraphicUtils.getFont(fn, ticksFHeight);
        String string = caption = this.useDefaultCaption_ ? this.userCaption_ : this.data_.getDescription();
        if (this.captionLoc_ == PanScaleCaptionLocation.NONE || caption == null || caption.isEmpty()) {
            this.captionY_ = (int)((double)margins.top + 0.5 * (double)captionFHeight);
            this.barTopY_ = this.captionY_ + gap1;
            this.barBottomY_ = this.barTopY_ + this.barHeight_;
            this.ticksY_ = (int)((float)(this.barBottomY_ + gap2) + ticksFHeight);
        } else if (this.captionLoc_ == PanScaleCaptionLocation.ABOVE) {
            this.captionY_ = (int)((float)margins.top + captionFHeight);
            this.barTopY_ = this.captionY_ + gap1;
            this.barBottomY_ = this.barTopY_ + this.barHeight_;
            this.ticksY_ = (int)((float)(this.barBottomY_ + gap2) + ticksFHeight);
        } else if (this.captionLoc_ == PanScaleCaptionLocation.BELOW) {
            this.barTopY_ = margins.top + 1;
            this.barBottomY_ = this.barTopY_ + this.barHeight_;
            this.ticksY_ = (int)((float)(this.barBottomY_ + gap2) + ticksFHeight);
            this.captionY_ = (int)((float)(this.ticksY_ + gap1) + captionFHeight);
        }
        switch (this.oshape_) {
            case TRIANGLE: {
                this.outlierWidth_ = this.barHeight_;
                break;
            }
            case TRIANGLE_2: {
                this.outlierWidth_ = 2.0f * (float)this.barHeight_;
                break;
            }
            case TRIANGLE_3: {
                this.outlierWidth_ = 3.0f * (float)this.barHeight_;
                break;
            }
            case RECTANGLE: {
                this.outlierWidth_ = 0.5f * (float)this.barHeight_;
                break;
            }
            default: {
                this.outlierWidth_ = this.barHeight_;
            }
        }
        LOGGER.trace("outlierWidth {}", (Object)Float.valueOf(this.outlierWidth_));
        switch (this.ogap_) {
            case NONE: {
                this.outlierGap_ = 0.0f * (float)this.barHeight_;
                break;
            }
            case THIN: {
                this.outlierGap_ = 0.25f * (float)this.barHeight_;
                break;
            }
            case WIDE: {
                this.outlierGap_ = 0.5f * (float)this.barHeight_;
                break;
            }
        }
        Rectangle mfBounds = (Rectangle)this.pmeta_.getLayout().getParam("bounds.figure");
        this.minX_ = 0.5f * (float)(width - mfBounds.width);
        this.maxX_ = this.minX_ + (float)mfBounds.width;
        this.barWidth_ = this.widthFactor_ * (float)mfBounds.width - 2.0f * (this.outlierGap_ + this.outlierWidth_ + 2.0f);
        this.barLeft_ = 0.5f * ((float)width - this.barWidth_);
        this.barRight_ = this.barLeft_ + this.barWidth_;
        if (this.pmeta_.getType().supportsVectorPlots()) {
            if (this.vectorWeight_ > 0 && this.vectorStyle_ != PanVectorStyle.NONE && this.pmeta_.getBoolean("vector.sample")) {
                float vectorGap = this.barHeight_;
                this.vectorLeft_ = this.barRight_ + this.outlierGap_ + this.outlierWidth_ + vectorGap;
                this.vectorLength_ = ((Integer)this.pmeta_.getLayout().getParam("vector.length")).intValue();
                if (this.vectorLeft_ + this.vectorLength_ > this.maxX_) {
                    float excess = this.vectorLeft_ + this.vectorLength_ - this.maxX_;
                    this.barLeft_ -= excess;
                    this.vectorLeft_ -= excess;
                    if (this.minX_ > this.barLeft_ - this.outlierGap_ - this.outlierWidth_) {
                        excess = this.minX_ - (this.barLeft_ - this.outlierGap_ - this.outlierWidth_);
                        this.barWidth_ -= excess;
                        this.barLeft_ += excess;
                    }
                    this.barRight_ = this.barLeft_ + this.barWidth_;
                    this.vectorLeft_ = this.barRight_ + this.outlierGap_ + this.outlierWidth_ + vectorGap;
                }
            }
        } else {
            this.vectorWeight_ = 0;
            this.vectorStyle_ = PanVectorStyle.NONE;
            this.vectorLength_ = 0.0f;
        }
        this.needsResize_ = false;
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        if (this.colortable_ == null) {
            return;
        }
        this.drawCaption(gx);
        this.drawColorbar(gx);
        PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
        switch (smethod) {
            case LOG10: 
            case LOG_E: {
                this.drawLogTicks(gx, smethod);
                break;
            }
            default: {
                this.drawStandardTicks(gx);
            }
        }
        if (this.pmeta_.getType().supportsVectorPlots()) {
            this.drawSampleVector(gx);
        }
    }

    private final void drawCaption(Graphics2D g2d) {
        String caption;
        if (this.captionLoc_ == PanScaleCaptionLocation.NONE) {
            return;
        }
        String string = caption = this.useDefaultCaption_ ? this.userCaption_ : this.data_.getDescription();
        if (caption == null || caption.isEmpty()) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.captionFont_);
        FontMetrics fm = g2d.getFontMetrics();
        caption = TextUtils.trimStringToFit(caption, fm, this.getWidth());
        g2d.drawString(caption, (int)(0.5 * (double)(this.getWidth() - fm.stringWidth(caption))), this.captionY_);
    }

    private final void drawColorbar(Graphics2D g2d) {
        if (this.colortable_ == null) {
            LOGGER.warn("Unable to draw the colorbar because the color table is null.");
            return;
        }
        float xleft = this.barLeft_ - this.outlierGap_;
        float xright = this.barRight_ + this.outlierGap_;
        GeneralPath path = new GeneralPath();
        switch (this.oshape_) {
            case TRIANGLE: 
            case TRIANGLE_2: 
            case TRIANGLE_3: {
                if (this.outlierOnLeft_) {
                    path.reset();
                    path.moveTo(xleft, this.barTopY_);
                    path.lineTo(xleft - this.outlierWidth_, (float)this.barTopY_ + 0.5f * (float)this.barHeight_);
                    path.lineTo(xleft, this.barBottomY_);
                    path.lineTo(xleft, this.barTopY_);
                    path.closePath();
                    g2d.setColor(this.colortable_.getMinOutlierColor(this.reversed_));
                    g2d.fill(path);
                }
                if (!this.outlierOnRight_) break;
                path.reset();
                path.moveTo(xright, this.barTopY_);
                path.lineTo(xright + this.outlierWidth_, (float)this.barTopY_ + 0.5f * (float)this.barHeight_);
                path.lineTo(xright, this.barBottomY_);
                path.lineTo(xright, this.barTopY_);
                path.closePath();
                g2d.setColor(this.colortable_.getMaxOutlierColor(this.reversed_));
                g2d.fill(path);
                break;
            }
            case RECTANGLE: {
                if (this.outlierOnLeft_) {
                    g2d.setColor(this.colortable_.getMinOutlierColor(this.reversed_));
                    GraphicUtils.fillRect(g2d, xleft - this.outlierWidth_, this.barTopY_, this.outlierWidth_, this.barHeight_);
                }
                if (!this.outlierOnRight_) break;
                g2d.setColor(this.colortable_.getMaxOutlierColor(this.reversed_));
                GraphicUtils.fillRect(g2d, xright, this.barTopY_, this.outlierWidth_, this.barHeight_);
                break;
            }
            default: {
                LOGGER.trace("Switch - How did we get here? {}", (Object)this.oshape_);
            }
        }
        int colorCount = this.colortable_.getColorCount();
        float binWidth = this.barWidth_ / (float)colorCount;
        for (int i = 0; i < colorCount; ++i) {
            Color c2;
            float binOffset = binWidth * (float)i;
            float binLeft = this.barLeft_ + binOffset;
            Color c1 = this.colortable_.getColorAt(i, this.reversed_);
            int iwidth = 1;
            for (int j = i + 1; j < colorCount && (c2 = this.colortable_.getColorAt(j, this.reversed_)).equals(c1); ++j) {
                ++iwidth;
            }
            float colorWidth = binWidth * (float)iwidth;
            i += iwidth - 1;
            if (binLeft + (colorWidth += 0.75f) > this.barRight_) {
                colorWidth = this.barRight_ - binLeft;
            }
            g2d.setColor(this.colortable_.getColorAt(i, this.reversed_));
            GraphicUtils.fillRect(g2d, binLeft, this.barTopY_, colorWidth, this.barHeight_);
        }
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.borderStroke_);
        if (this.oside_ == PanColorbarOutlierSide.NONE) {
            GraphicUtils.drawRect(g2d, this.barLeft_, this.barTopY_, this.barWidth_, this.barHeight_);
        } else if (this.ogap_ == PanColorbarOutlierGap.NONE) {
            switch (this.oshape_) {
                case TRIANGLE: 
                case TRIANGLE_2: 
                case TRIANGLE_3: {
                    path.reset();
                    path.moveTo(this.barLeft_, this.barTopY_);
                    path.lineTo(this.barRight_, this.barTopY_);
                    if (this.outlierOnRight_) {
                        path.lineTo(this.barRight_ + this.outlierWidth_, (float)this.barTopY_ + 0.5f * (float)this.barHeight_);
                    }
                    path.lineTo(this.barRight_, this.barBottomY_);
                    path.lineTo(this.barLeft_, this.barBottomY_);
                    if (this.outlierOnLeft_) {
                        path.lineTo(this.barLeft_ - this.outlierWidth_, (float)this.barTopY_ + 0.5f * (float)this.barHeight_);
                    }
                    path.closePath();
                    g2d.draw(path);
                    break;
                }
                case RECTANGLE: {
                    path.reset();
                    path.moveTo(this.barLeft_, this.barTopY_);
                    path.lineTo(this.barRight_, this.barTopY_);
                    if (this.outlierOnRight_) {
                        path.lineTo(this.barRight_ + this.outlierWidth_, this.barTopY_);
                        path.lineTo(this.barRight_ + this.outlierWidth_, this.barBottomY_);
                    }
                    path.lineTo(this.barRight_, this.barBottomY_);
                    path.lineTo(this.barLeft_, this.barBottomY_);
                    if (this.outlierOnLeft_) {
                        path.lineTo(this.barLeft_ - this.outlierWidth_, this.barBottomY_);
                        path.lineTo(this.barLeft_ - this.outlierWidth_, this.barTopY_);
                    }
                    path.closePath();
                    g2d.draw(path);
                    break;
                }
            }
        } else {
            GraphicUtils.drawRect(g2d, this.barLeft_, this.barTopY_, this.barWidth_, this.barHeight_);
            switch (this.oshape_) {
                case TRIANGLE: 
                case TRIANGLE_2: 
                case TRIANGLE_3: {
                    if (this.outlierOnLeft_) {
                        path.reset();
                        path.moveTo(xleft, this.barTopY_);
                        path.lineTo(xleft - this.outlierWidth_, (float)this.barTopY_ + 0.5f * (float)this.barHeight_);
                        path.lineTo(xleft, this.barBottomY_);
                        path.lineTo(xleft, this.barTopY_);
                        path.closePath();
                        g2d.setColor(this.getForeground());
                        g2d.draw(path);
                    }
                    if (!this.outlierOnRight_) break;
                    path.reset();
                    path.moveTo(xright, this.barTopY_);
                    path.lineTo(xright + this.outlierWidth_, (float)this.barTopY_ + 0.5f * (float)this.barHeight_);
                    path.lineTo(xright, this.barBottomY_);
                    path.lineTo(xright, this.barTopY_);
                    path.closePath();
                    g2d.setColor(this.getForeground());
                    g2d.draw(path);
                    break;
                }
                case RECTANGLE: {
                    if (this.outlierOnLeft_) {
                        g2d.setColor(this.getForeground());
                        GraphicUtils.drawRect(g2d, xleft - this.outlierWidth_, this.barTopY_, this.outlierWidth_, this.barHeight_);
                    }
                    if (!this.outlierOnRight_) break;
                    g2d.setColor(this.getForeground());
                    GraphicUtils.drawRect(g2d, xright, this.barTopY_, this.outlierWidth_, this.barHeight_);
                    break;
                }
            }
        }
    }

    private final void drawStandardTicks(Graphics2D g2d) {
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double scaleRange = Math.max(scaleMax - scaleMin, 1.0E-25);
        double mstep = (double)this.barWidth_ / scaleRange;
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.borderStroke_);
        g2d.setFont(this.ticksFont_);
        FontMetrics fm = g2d.getFontMetrics();
        for (PanScaleTick tick : smeta.getTicks()) {
            float tbot;
            float ttop;
            double value = tick.getValue();
            float tickX = (float)((double)this.barLeft_ + (value - scaleMin) * mstep);
            boolean longTick = false;
            longTick = tick.getType() == PanScaleTick.TickType.ENDPOINT ? (value - scaleMin == 0.0 ? this.outlierFlushLeft_ : this.outlierFlushRight_) : tick.isMajor();
            if (longTick) {
                ttop = (float)this.barBottomY_ - 0.25f * (float)this.barHeight_;
                tbot = (float)this.barBottomY_ + 0.2f * (float)this.barHeight_;
            } else {
                ttop = (float)this.barBottomY_ - 0.2f * (float)this.barHeight_;
                tbot = this.barBottomY_;
            }
            GraphicUtils.drawLine(g2d, tickX, ttop, tickX, tbot);
            if (!tick.isMajor()) continue;
            String label = this.formatter_.sprintg(value);
            float labelWidth = fm.stringWidth(label);
            float x = tickX - (float)((int)(0.5 * (double)labelWidth));
            if (x < this.minX_) {
                x = this.minX_;
            }
            if (x + labelWidth > this.maxX_) {
                x = this.maxX_ - labelWidth;
            }
            if (this.pmeta_.getType().supportsVectorPlots() && this.vectorWeight_ > 0 && x + labelWidth > this.barRight_ + this.outlierGap_ + this.outlierWidth_) {
                x = this.barRight_ + this.outlierGap_ + this.outlierWidth_ - labelWidth;
            }
            g2d.drawString(label, x, (float)this.ticksY_);
        }
    }

    private final void drawLogTicks(Graphics2D g2d, PanScaleMethod smethod) {
        double logScaleMax;
        double logScaleMin;
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        switch (smethod) {
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                break;
            }
            default: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
            }
        }
        double scaleRange = Math.max(logScaleMax - logScaleMin, 1.0E-25);
        double mstep = (double)this.barWidth_ / scaleRange;
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.borderStroke_);
        g2d.setFont(this.ticksFont_);
        block11: for (PanScaleTick tick : smeta.getTicks()) {
            double value = tick.getValue();
            double logValue = tick.getAlternativeValue();
            float tickX = (float)((double)this.barLeft_ + (logValue - logScaleMin) * mstep);
            switch (tick.getType()) {
                case MAJOR: {
                    Object label;
                    GraphicUtils.drawLine(g2d, tickX, (float)this.barBottomY_ - 0.23f * (float)this.barHeight_, tickX, (float)this.barBottomY_ + 0.2f * (float)this.barHeight_);
                    switch (smethod) {
                        case LOG_E: {
                            label = PanGraphicUtils.getSuperscriptedE(logValue, this.ticksFont_);
                            break;
                        }
                        default: {
                            label = this.formatter_.sprintg(value);
                        }
                    }
                    float labelWidth = GraphicUtils.getStringWidth(g2d, label);
                    float x = tickX - (float)((int)(0.5 * (double)labelWidth));
                    if (x < this.minX_) {
                        x = this.minX_;
                    }
                    if (x + labelWidth > this.maxX_) {
                        x = this.maxX_ - labelWidth;
                    }
                    if (this.vectorWeight_ > 0 && x + labelWidth > this.barRight_ + this.outlierGap_ + this.outlierWidth_) {
                        x = this.barRight_ + this.outlierGap_ + this.outlierWidth_ - labelWidth;
                    }
                    if (label instanceof String) {
                        g2d.drawString((String)label, x, (float)this.ticksY_);
                        continue block11;
                    }
                    GraphicUtils.drawAttributedString(g2d, (AttributedString)label, x, this.ticksY_);
                    continue block11;
                }
                case MINOR: {
                    GraphicUtils.drawLine(g2d, tickX, (float)this.barBottomY_ - 0.2f * (float)this.barHeight_, tickX, (float)this.barBottomY_ + 0.2f * (float)this.barHeight_);
                    continue block11;
                }
                case LEAST: {
                    GraphicUtils.drawLine(g2d, tickX, (float)this.barBottomY_ - 0.2f * (float)this.barHeight_, tickX, this.barBottomY_);
                    continue block11;
                }
            }
        }
    }

    private final void drawSampleVector(Graphics2D g2d) {
        if (this.vectorWeight_ == 0 || this.vectorStyle_ == PanVectorStyle.NONE) {
            return;
        }
        if (!this.pmeta_.getBoolean("vector.sample")) {
            return;
        }
        double referenceVal = this.pmeta_.getDouble("vector.refvalue");
        if (referenceVal <= 0.0) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.vectorStroke_);
        String vtext = this.formatter_.sprintg(referenceVal);
        FontMetrics fm = g2d.getFontMetrics();
        int twidth = fm.stringWidth(vtext);
        int dtext = (int)(this.vectorLength_ - (float)twidth) / 2;
        float textLeft = this.vectorLeft_ + (float)dtext;
        if (textLeft + (float)twidth > this.maxX_) {
            textLeft = this.maxX_ - (float)twidth;
        }
        g2d.drawString(vtext, textLeft, (float)this.ticksY_);
        int vecy = this.barBottomY_ - 4;
        if (this.vectorStyle_ == PanVectorStyle.UPDOT) {
            double radius = Math.sqrt(0.2 * (double)this.vectorLength_);
            if (radius < 1.25) {
                radius = 1.25;
            }
            Ellipse2D.Double dot = new Ellipse2D.Double((double)this.vectorLeft_ - radius, (double)vecy - radius, radius * 2.0, radius * 2.0);
            g2d.fill(dot);
            GeneralPath line = new GeneralPath();
            line.moveTo(this.vectorLeft_, vecy);
            line.lineTo(this.vectorLeft_ + this.vectorLength_, vecy);
            g2d.draw(line);
        } else {
            int hlength = (int)(0.25 * (double)this.vectorLength_);
            float hlengthX = (float)((double)hlength * COS45);
            GeneralPath arrow = new GeneralPath();
            arrow.moveTo(this.vectorLeft_, vecy);
            arrow.lineTo(this.vectorLeft_ + this.vectorLength_, vecy);
            arrow.moveTo(this.vectorLeft_ + this.vectorLength_ - hlengthX, (float)vecy - hlengthX);
            arrow.lineTo(this.vectorLeft_ + this.vectorLength_, vecy);
            arrow.lineTo(this.vectorLeft_ + this.vectorLength_ - hlengthX, (float)vecy + hlengthX);
            g2d.draw(arrow);
        }
    }

    public PrintfFormat getFormatter() {
        return this.formatter_;
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        String s;
        boolean changeAll = pname == null || "all".equals(pname);
        int sfactor = this.pmeta_.getInt("size.factor");
        if (changeAll || pname.contains("color.background")) {
            this.setBackground(this.pmeta_.getColor("color.background"));
        }
        if (changeAll || pname.contains("size.factor")) {
            this.borderStroke_ = PanGraphicUtils.solidStroke(100, sfactor);
        }
        if (changeAll || pname.contains("scale.label.custom") || pname.contains("scale.label.text")) {
            this.useDefaultCaption_ = this.pmeta_.getBoolean("scale.label.custom");
            this.userCaption_ = this.pmeta_.getString("scale.label.text");
            this.needsResize_ = true;
        }
        if (changeAll || pname.contains("scale.label.location")) {
            s = this.pmeta_.getString("scale.label.location");
            this.captionLoc_ = PanScaleCaptionLocation.matching(s);
            this.needsResize_ = true;
        }
        if (changeAll || pname.contains("scale.colorbar")) {
            Object o = this.pmeta_.get("scale.colorbar");
            if (o == null) {
                LOGGER.warn("Color table object is null.");
            } else if (o instanceof AbstractColorTable) {
                this.colortable_ = (AbstractColorTable)o;
            } else {
                LOGGER.warn("Object is not a color table.");
            }
        }
        if (changeAll || pname.contains("scale.width")) {
            this.widthFactor_ = 0.01f * (float)this.pmeta_.getInt("scale.width");
            this.widthFactor_ = Math.max(0.25f, this.widthFactor_);
            this.widthFactor_ = Math.min(1.0f, this.widthFactor_);
            this.needsResize_ = true;
        }
        if (changeAll || pname.contains("scale.reverse")) {
            this.reversed_ = this.pmeta_.getBoolean("scale.reverse");
        }
        if (changeAll || pname.contains("scale.tick.format")) {
            s = this.pmeta_.getString("scale.tick.format");
            if (s == null) {
                LOGGER.debug("Property {} has null value", (Object)"scale.tick.format");
                throw new RuntimeException("Null format string");
            }
            this.formatString_ = s;
            this.formatter_ = new PrintfFormat(this.formatString_);
        }
        if (changeAll || pname.contains("font.master") || pname.contains("size.factor") || pname.contains("scale.tick.size")) {
            this.needsResize_ = true;
        }
        if (changeAll || pname.contains("scale.outlier.side") || pname.contains("scale.outlier.shape") || pname.contains("scale.outlier.gap") || pname.contains("vector.sample")) {
            this.oside_ = PanColorbarOutlierSide.matching(this.pmeta_.getString("scale.outlier.side"));
            this.oshape_ = ColorTableOutlierShape.matching(this.pmeta_.getString("scale.outlier.shape"));
            this.ogap_ = PanColorbarOutlierGap.matching(this.pmeta_.getString("scale.outlier.gap"));
            this.outlierOnLeft_ = this.oside_ == PanColorbarOutlierSide.BOTH || this.oside_ == PanColorbarOutlierSide.LEFT;
            this.outlierOnRight_ = this.oside_ == PanColorbarOutlierSide.BOTH || this.oside_ == PanColorbarOutlierSide.RIGHT;
            this.outlierFlushLeft_ = this.outlierOnLeft_ && this.ogap_ == PanColorbarOutlierGap.NONE;
            this.outlierFlushRight_ = this.outlierOnRight_ && this.ogap_ == PanColorbarOutlierGap.NONE;
            this.needsResize_ = true;
        }
        if (changeAll || pname.contains("combination") || pname.contains("vector.color") || pname.contains("vector.weight") || pname.contains("vector.style")) {
            boolean vectorsEnabled;
            PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
            boolean bl = vectorsEnabled = ctype != null && ctype == PanCombinationType.VECTOR;
            if (vectorsEnabled) {
                String vs = this.pmeta_.getString("vector.style").toLowerCase();
                if (PanVectorStyle.ARROW.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.ARROW;
                    this.vectorWeight_ = PanUtils.min0max(500, this.pmeta_.getInt("vector.weight"));
                } else if (PanVectorStyle.UPDOT.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.UPDOT;
                    this.vectorWeight_ = PanUtils.min0max(500, this.pmeta_.getInt("vector.weight"));
                } else {
                    this.vectorStyle_ = PanVectorStyle.NONE;
                    this.vectorWeight_ = 0;
                }
            } else {
                this.vectorWeight_ = 0;
            }
            this.vectorStroke_ = this.vectorWeight_ > 0 ? GraphicUtils.buttMiterStroke(this.vectorWeight_) : null;
            this.needsResize_ = true;
        }
    }
}

