/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanDataLonLat;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanScaleTick;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanAlphaMethod;
import gov.nasa.giss.panoply.util.PanContourLocation;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanScaleMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final PanData data_;
    private final PanPlotMeta pmeta_;
    private double scaleMin_;
    private double scaleMax_;
    private AbstractColorTable ctable_;
    private boolean ctReversed_;
    private int invalidsRgba_;
    private int colorCount_;
    private double invDelta_;
    private boolean alphaEnabled_;
    private PanAlphaMethod alphaMethod_;
    private int alpha1_;
    private int alpha2_;
    private int alphaDiff_;

    public PanScaleMeta(PanPlotMeta pmeta, PanData data) {
        this.data_ = data;
        this.pmeta_ = pmeta;
    }

    public PrintfFormat getFormatter() {
        String s = this.pmeta_.getString("scale.tick.format");
        if (s == null) {
            LOGGER.debug("Property {} has null value", (Object)"scale.tick.format");
            throw new RuntimeException("Null format string");
        }
        return new PrintfFormat(s);
    }

    public PanScaleMethod getMethod() {
        return PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
    }

    public double getDataMinimum() {
        if (this.pmeta_.isLonLatZonal()) {
            return ((PanDataLonLat)this.data_).getMinimumRowAverage();
        }
        return this.data_.getMinValue();
    }

    public double getDataMaximum() {
        if (this.pmeta_.isLonLatZonal()) {
            return ((PanDataLonLat)this.data_).getMaximumRowAverage();
        }
        return this.data_.getMaxValue();
    }

    public double getScaleMinimum() {
        return this.getScaleMinMax()[0];
    }

    public double getScaleMaximum() {
        return this.getScaleMinMax()[1];
    }

    private double[] getScaleMinMax() {
        double max;
        double min = this.pmeta_.getBoolean("scale.autofit") ? this.getDataMinimum() : this.pmeta_.getDouble("scale.min");
        double d = max = this.pmeta_.getBoolean("scale.autofit") ? this.getDataMaximum() : this.pmeta_.getDouble("scale.max");
        if (Double.isNaN(min)) {
            min = -0.1;
        }
        switch (this.getMethod()) {
            case LOG10: 
            case LOG_E: {
                if (!(min <= 1.0E-50)) break;
                min = 1.0E-50;
                break;
            }
        }
        if (Double.isNaN(max)) {
            max = 0.1;
        }
        switch (this.getMethod()) {
            case LOG10: 
            case LOG_E: {
                if (!(max <= 1.0E-50)) break;
                max = 1.0E-25;
                break;
            }
        }
        if (max < min && !this.pmeta_.getType().isLinePlot()) {
            max = min + 0.05;
            min -= 0.05;
        } else if (max == min) {
            max = min + 0.05;
            min -= 0.05;
        }
        return new double[]{min, max};
    }

    public PanScaleTick[] getTicks() {
        PanScaleMethod smethod = this.getMethod();
        switch (smethod) {
            case LOG10: 
            case LOG_E: {
                return this.getLogarithmicTicks(smethod);
            }
        }
        return this.getStandardTicks();
    }

    private PanScaleTick[] getStandardTicks() {
        double scaleMin = this.getScaleMinimum();
        double scaleMax = this.getScaleMaximum();
        int majorDiv = MathUtils.minmax(1, 20, this.pmeta_.getInt("scale.div.major"));
        int minorDiv = MathUtils.minmax(1, 20, this.pmeta_.getInt("scale.div.minor"));
        int totalDivs = minorDiv * majorDiv;
        double divSize = scaleMax - scaleMin == 0.0 ? 1.0E-25 : (scaleMax - scaleMin) / (double)totalDivs;
        PanScaleTick[] ticks = new PanScaleTick[totalDivs + 1];
        for (int i = 0; i <= totalDivs; ++i) {
            double value = scaleMin + (double)i * divSize;
            ticks[i] = i == 0 || i == totalDivs ? new PanScaleTick(value, value, PanScaleTick.TickType.ENDPOINT) : (i % minorDiv == 0 ? new PanScaleTick(value, value, PanScaleTick.TickType.MAJOR) : new PanScaleTick(value, value, PanScaleTick.TickType.MINOR));
        }
        return ticks;
    }

    private PanScaleTick[] getLogarithmicTicks(PanScaleMethod smethod) {
        double logScaleMax;
        double logScaleMin;
        double scaleMin = this.getScaleMinimum();
        double scaleMax = this.getScaleMaximum();
        double realMin = Math.min(scaleMin, scaleMax);
        double realMax = Math.max(scaleMin, scaleMax);
        switch (smethod) {
            case LOG_E: {
                logScaleMin = Math.log(realMin);
                logScaleMax = Math.log(realMax);
                break;
            }
            default: {
                logScaleMin = Math.log10(realMin);
                logScaleMax = Math.log10(realMax);
            }
        }
        ArrayList<PanScaleTick> ticks = new ArrayList<PanScaleTick>();
        int iMin = (int)Math.floor(logScaleMin) - 1;
        int iMax = (int)Math.floor(logScaleMax) + 1;
        int intDiv = iMax - iMin;
        int intStep = (intDiv - 2) / 10 + 1;
        block12: for (int j = iMin; j <= iMax; ++j) {
            int kmaxp1;
            double value0;
            switch (smethod) {
                case LOG_E: {
                    value0 = Math.pow(Math.E, j);
                    kmaxp1 = 1;
                    break;
                }
                default: {
                    value0 = Math.pow(10.0, j);
                    kmaxp1 = 9;
                }
            }
            for (int k = 0; k < kmaxp1; ++k) {
                double logValue;
                double value;
                if (k > 0 && intDiv > 20 || (value = value0 + value0 * (double)k) < realMin) continue;
                if (value > realMax) continue block12;
                switch (smethod) {
                    case LOG_E: {
                        logValue = Math.log(value);
                        break;
                    }
                    default: {
                        logValue = Math.log10(value);
                    }
                }
                if (k == 0) {
                    if (j % intStep == 0) {
                        ticks.add(new PanScaleTick(value, logValue, PanScaleTick.TickType.MAJOR));
                        continue;
                    }
                    ticks.add(new PanScaleTick(value, logValue, PanScaleTick.TickType.LEAST));
                    continue;
                }
                ticks.add(new PanScaleTick(value, logValue, PanScaleTick.TickType.LEAST));
            }
        }
        PanScaleTick[] result = ticks.toArray(new PanScaleTick[0]);
        if (result.length == 0) {
            double logValue;
            double value = 0.5 * (scaleMin + scaleMax);
            switch (smethod) {
                case LOG_E: {
                    logValue = Math.log(value);
                    break;
                }
                default: {
                    logValue = Math.log10(value);
                }
            }
            PanScaleTick tick = new PanScaleTick(value, logValue, PanScaleTick.TickType.MAJOR);
            return new PanScaleTick[]{tick};
        }
        if (result.length == 1) {
            result[0].setType(PanScaleTick.TickType.MAJOR);
            return result;
        }
        if (result.length == 2) {
            result[0].setType(PanScaleTick.TickType.MAJOR);
            result[1].setType(PanScaleTick.TickType.MAJOR);
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            if (result[i].getType() != PanScaleTick.TickType.MAJOR) continue;
            return result;
        }
        int steps = (int)Math.sqrt(2.0 + (double)result.length);
        for (int i = 0; i < result.length; i += steps) {
            result[i].setType(PanScaleTick.TickType.MAJOR);
        }
        return result;
    }

    public double[] getContourTickValues() {
        boolean includeMinor = PanContourLocation.MINOR.matches(this.pmeta_.getString("contour.location"));
        ArrayList<Double> dlist = new ArrayList<Double>();
        for (PanScaleTick tick : this.getTicks()) {
            if (tick.getType() != PanScaleTick.TickType.MAJOR && (!includeMinor || tick.getType() != PanScaleTick.TickType.MINOR)) continue;
            dlist.add(tick.getValue());
        }
        Stream dstream = dlist.stream();
        double[] dcopy = dstream.mapToDouble(Double::doubleValue).toArray();
        return dcopy;
    }

    public double[] getMajorTickValues() {
        ArrayList<Double> dlist = new ArrayList<Double>();
        for (PanScaleTick tick : this.getTicks()) {
            if (tick.getType() != PanScaleTick.TickType.MAJOR) continue;
            dlist.add(tick.getValue());
        }
        Stream dstream = dlist.stream();
        double[] dcopy = dstream.mapToDouble(Double::doubleValue).toArray();
        return dcopy;
    }

    public void prepareColorTable(boolean knockout) {
        this.scaleMin_ = this.getScaleMinimum();
        this.scaleMax_ = this.getScaleMaximum();
        switch (this.getMethod()) {
            case LOG10: {
                this.scaleMin_ = Math.log10(this.scaleMin_);
                this.scaleMax_ = Math.log10(this.scaleMax_);
                break;
            }
            case LOG_E: {
                this.scaleMin_ = Math.log(this.scaleMin_);
                this.scaleMax_ = Math.log(this.scaleMax_);
                break;
            }
        }
        this.ctable_ = (AbstractColorTable)this.pmeta_.get("scale.colorbar");
        if (this.ctable_ == null) {
            LOGGER.warn("Unable to paint the data image because the color table is null.");
            return;
        }
        this.ctReversed_ = this.pmeta_.getBoolean("scale.reverse");
        this.colorCount_ = this.ctable_.getColorCount();
        this.invDelta_ = (double)this.colorCount_ / (this.scaleMax_ - this.scaleMin_);
        this.invalidsRgba_ = this.pmeta_.getColor("scale.invalids").getRGB();
        if (knockout) {
            this.invalidsRgba_ &= 0xFFFFFF;
        }
        this.alphaEnabled_ = false;
        PanPreferences prefs = PanPreferences.getSharedInstance();
        if (prefs.getBoolean("beta:underlays") && this.pmeta_.isLonLatMap() && this.pmeta_.containsKey("lonlat.underlay.name") && this.pmeta_.get("lonlat.underlay.name") != null && this.pmeta_.containsKey("main.alpha.method")) {
            this.alphaMethod_ = PanAlphaMethod.matching(this.pmeta_.getString("main.alpha.method"));
            int alpha1pct = this.pmeta_.getInt("main.alpha.1");
            int alpha2pct = Math.max(this.pmeta_.getInt("main.alpha.2"), alpha1pct);
            this.alphaEnabled_ = alpha1pct < 100 || alpha2pct < 100;
            this.alpha1_ = (int)(2.5500000000000003 * (double)alpha1pct);
            this.alpha2_ = (int)(2.5500000000000003 * (double)alpha2pct);
            this.alphaDiff_ = this.alpha2_ - this.alpha1_;
        }
    }

    public int rgbaForValue(double val) {
        if (Double.isNaN(val)) {
            return this.invalidsRgba_;
        }
        double vval = val;
        if (Double.isInfinite(vval)) {
            return this.invalidsRgba_;
        }
        switch (this.getMethod()) {
            case LOG10: {
                if (val <= 0.0) {
                    return this.invalidsRgba_;
                }
                vval = Math.log10(val);
                break;
            }
            case LOG_E: {
                if (val <= 0.0) {
                    return this.invalidsRgba_;
                }
                vval = Math.log(val);
                break;
            }
            default: {
                vval = val;
            }
        }
        int rgb = 0;
        float pct = 0.0f;
        if (vval < this.scaleMin_) {
            rgb = this.ctable_.getMinOutlierRgb(this.ctReversed_);
            pct = 0.0f;
        } else if (vval > this.scaleMax_) {
            rgb = this.ctable_.getMaxOutlierRgb(this.ctReversed_);
            pct = 1.0f;
        } else {
            int cbin = (int)((vval - this.scaleMin_) * this.invDelta_);
            cbin = Math.min(cbin, this.colorCount_ - 1);
            cbin = Math.max(cbin, 0);
            rgb = this.ctable_.getRgbAt(cbin, this.ctReversed_);
            pct = ((float)cbin + 0.5f) / (float)this.colorCount_;
        }
        int rgba = rgb;
        if (this.alphaEnabled_) {
            int alpha = 255;
            switch (this.alphaMethod_) {
                case CONSTANT: {
                    alpha = this.alpha1_;
                    break;
                }
                case MINMAX: {
                    alpha = (int)((float)this.alpha1_ + (float)this.alphaDiff_ * pct);
                    break;
                }
                case MAXMIN: {
                    alpha = (int)((double)this.alpha1_ + (double)this.alphaDiff_ * (1.0 - (double)pct));
                    break;
                }
                case DIVERGE: {
                    if ((double)pct < 0.5) {
                        alpha = (int)((double)this.alpha2_ - (double)this.alphaDiff_ * 2.0 * (double)pct);
                        break;
                    }
                    alpha = (int)((double)this.alpha1_ + (double)this.alphaDiff_ * 2.0 * ((double)pct - 0.5));
                    break;
                }
                case SATURATION: {
                    alpha = (int)((float)this.alpha1_ + (float)this.alphaDiff_ * this.hsbArray(rgb)[1]);
                    break;
                }
                case BRIGHTNESS: {
                    alpha = (int)((float)this.alpha1_ + (float)this.alphaDiff_ * this.hsbArray(rgb)[2]);
                    break;
                }
                case DARKNESS: {
                    alpha = (int)((double)this.alpha1_ + (double)this.alphaDiff_ * (1.0 - (double)this.hsbArray(rgb)[2]));
                    break;
                }
                default: {
                    LOGGER.trace("Switch - How did we get here? {}", (Object)this.alphaMethod_);
                }
            }
            alpha = MathUtils.minmax(0, 255, alpha);
            alpha = alpha << 24 | 0xFFFFFF;
            rgba = rgb & alpha;
        }
        return rgba;
    }

    private float[] hsbArray(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return Color.RGBtoHSB(red, green, blue, null);
    }
}

