/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.data.PanDataTimeY;
import gov.nasa.giss.panoply.plot.PanGeneral2DPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.time.PatternTime;
import gov.nasa.giss.time.TimeFormatter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanTimeYPlot
extends PanGeneral2DPlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String timeAxisFormat_;
    private NcTimeAxis timeAxis_;
    private boolean formattedTime_;

    public PanTimeYPlot(PanPlotMeta pmeta) {
        super(pmeta);
        PanData2D data = (PanData2D)pmeta.getData();
        NcTimeAxis tax = (NcTimeAxis)data.getXAxis();
        LOGGER.trace("X/time axis is formatted {}", (Object)tax.isFormattedTime());
        if (tax.isFormattedTime()) {
            TimeFormatter formatter = tax.getFormatter();
            this.timeAxisFormat_ = null;
            if (formatter instanceof PatternTime) {
                this.timeAxisFormat_ = ((PatternTime)((Object)formatter)).getPattern();
            }
            if (this.timeAxisFormat_ != null) {
                if (this.timeAxisFormat_.endsWith(" Z")) {
                    this.timeAxisFormat_ = this.timeAxisFormat_.replace(" Z", "");
                }
                this.pmeta_.setString("xaxis.tick.format", this.timeAxisFormat_);
            }
        }
        this.parameterChangedPrivate("all");
    }

    @Override
    protected void prepareToPaint() {
        block2: {
            super.prepareToPaint();
            try {
                NcAxis xax = ((PanData2D)this.data_).getXAxis();
                this.timeAxis_ = (NcTimeAxis)xax;
                this.formattedTime_ = this.timeAxis_.isFormattedTime();
            }
            catch (Exception exc) {
                LOGGER.debug("Exception creating X (time) axis {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }

    @Override
    protected String getXAxisTickLabel(double val) {
        return this.formattedTime_ ? this.timeAxis_.formatValue(val) : Double.toString(val);
    }

    @Override
    protected String getXAxisLabel() {
        if (this.xaxisLabelText_ != null) {
            return this.xaxisLabelText_;
        }
        if (this.formattedTime_) {
            return "Time";
        }
        NcAxis xaxis = ((PanData2D)this.data_).getXAxis();
        String unitsStr = xaxis.getUnitsString();
        if (unitsStr == null || unitsStr.isEmpty()) {
            return "Time";
        }
        return "Time (" + unitsStr + ")";
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("xaxis.tick.format")) {
            this.timeAxisFormat_ = this.pmeta_.getString("xaxis.tick.format");
            if (this.timeAxisFormat_ == null || this.timeAxisFormat_.isEmpty()) {
                this.timeAxisFormat_ = null;
            } else {
                ((PanDataTimeY)this.data_).setTimeFormat(this.timeAxisFormat_);
            }
        }
    }
}

