/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.panoply.action.PanInterpolateAction;
import gov.nasa.giss.panoply.action.PanLinkDimensionsAction;
import gov.nasa.giss.panoply.action.PanLonLatPlotTypeAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.plotui.PanArraySlicePanel;
import gov.nasa.giss.panoply.plotui.PanArraySlicer;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanCommonComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanLinkButton;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.invoke.MethodHandles;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanArrayControls
extends PanAbstractControlsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Box combinationBox_;
    private PanStringComboBox lonlatTypeCombo_;
    private PanCommonComboBox combinationCombo_;
    private PanCheckBox interpolateCB_;
    private PanArraySlicePanel[] spanels_ = new PanArraySlicePanel[2];
    private final PanLinkButton linkButton_;
    private boolean linked_;

    public PanArrayControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("array-controls", pmeta, mbar);
        this.setLayout(null);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.addCombinationPanel(mbar);
        this.addSlicePanel(0);
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        PanLinkDimensionsAction a = new PanLinkDimensionsAction(this);
        this.pmeta_.putAction("link-dimensions", a);
        plotMenu.getItemByName("link-dimensions").setAction(a);
        a.setEnabled(false);
        this.linkButton_ = new PanLinkButton(a);
        this.add(this.linkButton_);
    }

    private final void addCombinationPanel(PanMenuBar mbar) {
        PanLabel plotLabel = PanLabel.createSmall("Plot ");
        if (this.plotType_ == PanPlotType.LON_LAT) {
            boolean isMap;
            String m1 = PanProperties.MENU_PROPS.getString("plot-type-m1");
            String m2 = PanProperties.MENU_PROPS.getString("plot-type-m2");
            String z1 = PanProperties.MENU_PROPS.getString("plot-type-z1");
            String z2 = PanProperties.MENU_PROPS.getString("plot-type-z2");
            this.lonlatTypeCombo_ = PanStringComboBox.createSmall("lonlat.lltype");
            PanLonLatPlotTypeAction pta = new PanLonLatPlotTypeAction(this.pmeta_, this.lonlatTypeCombo_);
            this.lonlatTypeCombo_.addItem(m1);
            this.lonlatTypeCombo_.addItem(z1);
            GuiUtils.restrictSize(this.lonlatTypeCombo_);
            JMenuItem jmi = mbar.getItemByName("plot-menu", "plot-type");
            String current = this.pmeta_.getString("lonlat.lltype");
            boolean bl = isMap = current.equalsIgnoreCase(m1) || current.equalsIgnoreCase(m2);
            if (isMap) {
                jmi.setText(z2);
                this.lonlatTypeCombo_.setSelectedItem(m1);
            } else {
                jmi.setText(m2);
                this.lonlatTypeCombo_.setSelectedItem(z1);
            }
            this.lonlatTypeCombo_.setAction(pta);
            jmi.setAction(pta);
            jmi.setEnabled(true);
        }
        this.combinationCombo_ = new PanCommonComboBox(PanGuiSize.SMALL, "combination", PanCombinationType.A1_ONLY);
        this.combinationCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PanCombinationType ctype = (PanCombinationType)this.combinationCombo_.getSelectedItem();
            this.pmeta_.setDataCombination(ctype.name(), null);
        });
        if (this.plotType_.isColorFill()) {
            boolean isInterpolated = this.pmeta_.getBoolean("interpolate");
            this.interpolateCB_ = PanCheckBox.createSmall("interpolate", "interpolate");
            this.interpolateCB_.setSelected(isInterpolated);
            this.interpolateCB_.setToolTipText("Enable/disable interpolation");
            PanInterpolateAction a = new PanInterpolateAction(this.pmeta_, this.interpolateCB_);
            this.interpolateCB_.setAction(a);
            this.pmeta_.putAction("interpolate", a);
            GissMenu plotMenu = mbar.getMenuByName("plot-menu");
            plotMenu.getItemByName("interpolate").setAction(a);
        }
        this.combinationBox_ = Box.createHorizontalBox();
        this.combinationBox_.add(plotLabel);
        if (this.lonlatTypeCombo_ != null) {
            this.combinationBox_.add(this.lonlatTypeCombo_);
            this.combinationBox_.add(PanLabel.createSmall(" of "));
        }
        this.combinationBox_.add(this.combinationCombo_);
        if (this.plotType_.isColorFill()) {
            this.combinationBox_.add(Box.createHorizontalStrut(2));
            this.combinationBox_.add(this.interpolateCB_);
        }
        this.add(this.combinationBox_);
    }

    private final void addSlicePanel(int vnum) {
        NcArray ncarray = this.data_.getArray(vnum);
        if (this.spanels_[vnum] != null) {
            this.remove(this.spanels_[vnum]);
            this.spanels_[vnum].flush();
        }
        this.spanels_[vnum] = new PanArraySlicePanel(this.pmeta_, this.mbar_, ncarray, vnum);
        this.add(this.spanels_[vnum]);
        this.validate();
        PanPlotFrame pf = this.getParentFrame();
        if (pf == null) {
            return;
        }
        PanMenuBar mbar = pf.getPanMenuBar();
        if (mbar == null) {
            return;
        }
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        Action a = plotMenu.getItemActionByName("link-dimensions");
        if (a != null) {
            a.setEnabled(this.canLinkDimensions());
        }
    }

    public void updateSlicePanel(int vnum) {
        this.addSlicePanel(vnum);
        this.resetLinkedDimensions();
        if (this.combinationCombo_.getItemCount() > 1) {
            return;
        }
        if (this.plotType_.isLinePlot()) {
            for (PanCombinationType ct : PanCombinationType.values()) {
                if (ct == PanCombinationType.A1_ONLY || ct == PanCombinationType.VECTOR) continue;
                this.combinationCombo_.addItem(ct);
            }
        } else if (this.pmeta_.getType() == PanPlotType.LL_TRAJ) {
            this.combinationCombo_.addItem(PanCombinationType.A2_ONLY);
            this.combinationCombo_.addItem(PanCombinationType.COMPARE);
        } else {
            for (PanCombinationType ct : PanCombinationType.values()) {
                if (ct == PanCombinationType.A1_ONLY || ct == PanCombinationType.COMPARE) continue;
                this.combinationCombo_.addItem(ct);
            }
        }
        this.combinationCombo_.setMaximumSize(this.combinationCombo_.getPreferredSize());
        if (this.plotType_.isLinePlot() || this.pmeta_.getType() == PanPlotType.LL_TRAJ) {
            this.combinationCombo_.setSelectedItem(PanCombinationType.COMPARE);
        } else {
            this.combinationCombo_.setSelectedItem(PanCombinationType.A1_MINUS_A2);
        }
        this.validate();
    }

    public void setCombinationType(PanCombinationType ctype) {
        try {
            this.combinationCombo_.setSelectedItem(ctype);
        }
        catch (Exception exc) {
            LOGGER.warn("Combination failed - {}", (Object)exc.toString());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        Dimension d0 = this.spanels_[0].getPreferredSize();
        if (this.spanels_[1] == null) {
            int w = ins.left + 2 * d0.width + 12 + ins.right;
            int h = ins.top + this.combinationBox_.getPreferredSize().height + 2 + d0.height + ins.bottom;
            return new Dimension(w, h);
        }
        Dimension d1 = this.spanels_[1].getPreferredSize();
        Dimension d2 = this.linkButton_.getPreferredSize();
        int w = ins.left + 2 * Math.max(d0.width, d1.width) + 4 + d2.width + 4 + ins.right;
        int h = ins.top + this.combinationBox_.getPreferredSize().height + 2 + Math.max(d0.height, d1.height) + ins.bottom;
        return new Dimension(w, h);
    }

    @Override
    public void doLayout() {
        Insets ins = this.getInsets();
        int w = this.getWidth();
        int tw = this.combinationBox_.getPreferredSize().width;
        int th = this.combinationBox_.getPreferredSize().height;
        int ptop = ins.top + th + 2;
        int lbw = this.linkButton_.getPreferredSize().width;
        int lbh = this.linkButton_.getPreferredSize().height;
        this.combinationBox_.setBounds((w - tw) / 2, ins.top, tw, th);
        if (this.spanels_[1] == null) {
            int pw1 = (w - ins.left - ins.right) / 2;
            int pw2 = (w - ins.left - ins.right) * 3 / 5;
            int ww = Math.min(pw2, Math.max(pw1, this.spanels_[0].getPreferredSize().width));
            this.spanels_[0].setBounds((w - ww) / 2, ptop, ww, this.spanels_[0].getPreferredSize().height);
        } else {
            int pw = (w - ins.left - ins.right - (4 + lbw + 4)) / 2;
            int hh = Math.max(this.spanels_[0].getPreferredSize().height, this.spanels_[1].getPreferredSize().height);
            this.spanels_[0].setBounds(ins.left, ptop, pw, hh);
            this.linkButton_.setBounds(ins.left + pw + 4, ptop + (hh - lbh) / 2, lbw, lbh);
            this.spanels_[1].setBounds(w - ins.right - pw, ptop, pw, hh);
        }
    }

    public PanArraySlicePanel getSlicePanel(int index) {
        return this.spanels_[index];
    }

    public void resetLinkedDimensions() {
        for (int vnum = 0; vnum < 2; ++vnum) {
            if (this.spanels_[vnum] == null) continue;
            for (int i = 0; i < this.spanels_[vnum].getItemCount(); ++i) {
                PanArraySlicer slicer = this.spanels_[vnum].getSlicer(i);
                if (slicer == null) continue;
                slicer.setCompanion(null);
            }
        }
        this.linkButton_.setLinked(false);
        this.linked_ = false;
        PanPlotFrame pf = this.getParentFrame();
        if (pf == null) {
            return;
        }
        PanMenuBar mbar = pf.getPanMenuBar();
        mbar.getItemByName("plot-menu", "link-dimensions").setText(PanProperties.MENU_PROPS.getString("link-dimensions"));
    }

    public void linkDimensions() {
        if (this.spanels_[0] == null || this.spanels_[1] == null) {
            LOGGER.debug("No matching pair of dimensions because a slicer is null.");
            return;
        }
        int size0 = this.spanels_[0].getItemCount();
        int size1 = this.spanels_[1].getItemCount();
        for (int i = 0; i < size0; ++i) {
            PanArraySlicer slicer0 = this.spanels_[0].getSlicer(i);
            if (slicer0 == null || slicer0.getLength() < 2) continue;
            for (int j = 0; j < size1; ++j) {
                PanArraySlicer slicer1 = this.spanels_[1].getSlicer(j);
                if (slicer1 == null || slicer1.getLength() <= 1 || !slicer0.isSameLength(slicer1)) continue;
                this.linkDimensions(slicer0, slicer1);
                return;
            }
        }
    }

    public void linkDimensions(PanArraySlicer slicer0, PanArraySlicer slicer1) {
        this.resetLinkedDimensions();
        if (slicer0 == null || slicer1 == null) {
            return;
        }
        slicer0.setCompanion(slicer1);
        slicer1.setCompanion(slicer0);
        slicer1.setSelectedIndex(slicer0.getSelectedIndex());
        this.linkButton_.setLinked(true);
        this.linked_ = true;
        PanPlotFrame pf = this.getParentFrame();
        if (pf == null) {
            return;
        }
        PanMenuBar mbar = pf.getPanMenuBar();
        mbar.getItemByName("plot-menu", "link-dimensions").setText(PanProperties.MENU_PROPS.getString("unlink-dimensions"));
    }

    public boolean isLinked() {
        return this.linked_;
    }

    public final boolean canLinkDimensions() {
        boolean canLink = this.getPossibleLinkCount() > 0;
        this.linkButton_.setEnabled(canLink);
        return canLink;
    }

    public final int getPossibleLinkCount() {
        if (this.spanels_[0] == null || this.spanels_[1] == null) {
            return 0;
        }
        int size0 = this.spanels_[0].getItemCount();
        int size1 = this.spanels_[1].getItemCount();
        int count = 0;
        for (int i = 0; i < size0; ++i) {
            PanArraySlicer slicer0 = this.spanels_[0].getSlicer(i);
            if (slicer0 == null || slicer0.getLength() < 2) continue;
            for (int j = 0; j < size1; ++j) {
                PanArraySlicer slicer1 = this.spanels_[1].getSlicer(j);
                if (slicer1 == null || slicer1.getLength() <= 1 || !slicer0.isSameLength(slicer1)) continue;
                ++count;
            }
        }
        return count;
    }
}

