/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatNumberlayControls
extends PanAbstractControlsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanCheckBox showNumbersCB_;
    private PanCheckBox hideInvalidsCB_;
    private PanTextField lonSpacingTF_;
    private PanTextField latSpacingTF_;
    private PanCheckBox lonOffsetCB_;
    private PanCheckBox latOffsetCB_;
    private PanFloatComboBox labelSizeCombo_;
    private PanColorComboBox labelColorCombo_;

    public PanLonLatNumberlayControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("numberlay-controls", pmeta, mbar);
        this.createLayout();
        this.attachListeners();
    }

    private final void createLayout() {
        this.showNumbersCB_ = PanCheckBox.createSmall("lonlat.numbers.vis", "Show overlay of data values", this.pmeta_.getBoolean("lonlat.numbers.vis"));
        QuickBox cbox11 = QuickBox.createLeftBox(this.showNumbersCB_);
        this.hideInvalidsCB_ = PanCheckBox.createSmall("lonlat.numbers.invalids", "Omit invalid values", !this.pmeta_.getBoolean("lonlat.numbers.invalids"));
        QuickBox cbox12 = QuickBox.createLeftBox(this.hideInvalidsCB_);
        PanLabel s1Label = PanLabel.createSmall("Spacing: ");
        PanLabel s2Label = PanLabel.createSmall("Lon: ");
        PanLabel s3Label = PanLabel.createSmall("\u00d7 Lat: ");
        this.lonSpacingTF_ = PanTextField.createSmallDoubleField("lonlat.numbers.spacing.lon", this.pmeta_.getDouble("lonlat.numbers.spacing.lon"));
        this.latSpacingTF_ = PanTextField.createSmallDoubleField("lonlat.numbers.spacing.lat", this.pmeta_.getDouble("lonlat.numbers.spacing.lat"));
        QuickBox cbox13 = QuickBox.createLeftBox(s1Label, s2Label, this.lonSpacingTF_, s3Label, this.latSpacingTF_);
        this.lonOffsetCB_ = PanCheckBox.createSmall("lonlat.numbers.offset.lon", "Numbers on lon axis are offset from prime meridian", this.pmeta_.getBoolean("lonlat.numbers.offset.lon"));
        QuickBox cbox14 = QuickBox.createLeftBox(this.lonOffsetCB_);
        this.latOffsetCB_ = PanCheckBox.createSmall("lonlat.numbers.offset.lat", "Numbers on lat axis are offset from equator", this.pmeta_.getBoolean("lonlat.numbers.offset.lat"));
        QuickBox cbox15 = QuickBox.createLeftBox(this.latOffsetCB_);
        PanLabel labelSizeLabel = PanLabel.createSmall("Size: ");
        this.labelSizeCombo_ = PanFloatComboBox.createSmall("lonlat.numbers.size", 2.0f, 10.0f);
        this.labelSizeCombo_.setValue(this.pmeta_.getFloat("lonlat.numbers.size"));
        QuickBox cbox21 = QuickBox.createLeftBox(labelSizeLabel, this.labelSizeCombo_);
        PanLabel colorLabel = PanLabel.createSmall("Color: ");
        this.labelColorCombo_ = PanColorComboBox.createSmallRainbow("lonlat.numbers.color");
        this.labelColorCombo_.setSelectedColor(this.pmeta_.getColor("lonlat.numbers.color"));
        QuickBox cbox22 = QuickBox.createLeftBox(colorLabel, this.labelColorCombo_);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)cbox11, new FGConstraint(0, 0));
        this.add((Component)cbox12, new FGConstraint(0, 1));
        this.add((Component)cbox13, new FGConstraint(0, 2));
        this.add((Component)cbox14, new FGConstraint(0, 3));
        this.add((Component)cbox15, new FGConstraint(0, 4));
        this.add((Component)cbox21, new FGConstraint(1, 0));
        this.add((Component)cbox22, new FGConstraint(1, 1));
        GuiUtils.matchLabelWidths(labelSizeLabel, colorLabel);
    }

    private final void attachListeners() {
        this.showNumbersCB_.addItemListener(e -> this.pmeta_.setBoolean("lonlat.numbers.vis", this.showNumbersCB_.isSelected()));
        this.hideInvalidsCB_.addItemListener(e -> this.pmeta_.setBoolean("lonlat.numbers.invalids", !this.hideInvalidsCB_.isSelected()));
        FocusAdapter lonSpacingFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatNumberlayControls.this.handleLonSpacing();
            }
        };
        FocusAdapter latSpacingFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatNumberlayControls.this.handleLatSpacing();
            }
        };
        this.lonSpacingTF_.addFocusListener(lonSpacingFL);
        this.latSpacingTF_.addFocusListener(latSpacingFL);
        this.lonSpacingTF_.addActionListener(e -> this.handleLonSpacing());
        this.latSpacingTF_.addActionListener(e -> this.handleLatSpacing());
        this.lonOffsetCB_.addItemListener(e -> this.pmeta_.setBoolean("lonlat.numbers.offset.lon", e.getStateChange() == 1));
        this.latOffsetCB_.addItemListener(e -> this.pmeta_.setBoolean("lonlat.numbers.offset.lat", e.getStateChange() == 1));
        this.labelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.labelSizeCombo_.getValue();
            this.pmeta_.setFloat("lonlat.numbers.size", value);
        });
        this.labelColorCombo_.addItemListener(e -> {
            Color cold;
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.labelColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("lonlat.numbers.color"))) {
                this.pmeta_.setColor("lonlat.numbers.color", cnew);
            }
        });
    }

    private final void handleLonSpacing() {
        if (this.lonSpacingTF_ == null) {
            return;
        }
        String s = this.lonSpacingTF_.getText();
        double oldSpacing = this.pmeta_.getDouble("lonlat.numbers.spacing.lon");
        try {
            double spacing = StringUtils.parseDouble(s);
            if (spacing <= 0.001) {
                if (spacing < 0.0) {
                    LOGGER.warn("Spacing cannot be less than 0.");
                } else if (spacing == 0.0) {
                    LOGGER.warn("Spacing cannot be 0.");
                } else {
                    LOGGER.warn("Spacing is too fine.");
                }
                this.lonSpacingTF_.setText(PrintfFormat.PFORMAT_7G.sprintg(oldSpacing));
                return;
            }
            this.pmeta_.setDouble("lonlat.numbers.spacing.lon", spacing);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lon spacing TF '{}'", (Object)s);
            this.lonSpacingTF_.setText(PrintfFormat.PFORMAT_7G.sprintg(oldSpacing));
        }
    }

    private final void handleLatSpacing() {
        if (this.latSpacingTF_ == null) {
            return;
        }
        String s = this.latSpacingTF_.getText();
        double oldSpacing = this.pmeta_.getDouble("lonlat.numbers.spacing.lat");
        try {
            double spacing = StringUtils.parseDouble(s);
            if (spacing <= 0.001) {
                if (spacing < 0.0) {
                    LOGGER.warn("Spacing cannot be less than 0.");
                } else if (spacing == 0.0) {
                    LOGGER.warn("Spacing cannot be 0.");
                } else {
                    LOGGER.warn("Spacing is too fine.");
                }
                this.latSpacingTF_.setText(PrintfFormat.PFORMAT_7G.sprintg(oldSpacing));
                return;
            }
            this.pmeta_.setDouble("lonlat.numbers.spacing.lat", spacing);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lat spacing TF '{}'", (Object)s);
            this.latSpacingTF_.setText(PrintfFormat.PFORMAT_7G.sprintg(oldSpacing));
        }
    }
}

