/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatShadingControls
extends PanAbstractControlsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanCheckBox shadingCB_;
    private PanIntSpinner sOpacitySpinner_;
    private PanTextField subsolarLonTF_;
    private PanTextField subsolarLatTF_;

    public PanLonLatShadingControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("shading-controls", pmeta, mbar);
        this.createLayout();
        this.attachListeners();
    }

    private final void createLayout() {
        PanLabel s1Label = PanLabel.createSmall("Shading: ");
        this.shadingCB_ = PanCheckBox.createSmall("lonlat.proj.shading.vis", "Darken nightside", this.pmeta_.getBoolean("lonlat.proj.shading.vis"));
        QuickBox s1Box = QuickBox.createLeftBox(s1Label, this.shadingCB_);
        PanLabel s2Label1 = PanLabel.createSmall(" ");
        PanLabel s2Label2 = PanLabel.createSmall("Darkness: ");
        PanLabel s2Label3 = PanLabel.createSmall("%");
        this.sOpacitySpinner_ = PanIntSpinner.createSmallPct("lonlat.proj.shading.opacity", this.pmeta_.getInt("lonlat.proj.shading.opacity"));
        QuickBox s2Box = QuickBox.createLeftBox(s2Label1, s2Label2, this.sOpacitySpinner_, s2Label3);
        PanLabel s3Label1 = PanLabel.createSmall(" ");
        PanLabel s3Label2 = PanLabel.createSmall("Subsolar Pt: ");
        PanLabel s3Label3 = PanLabel.createSmall("Lon: ");
        PanLabel s3Label4 = PanLabel.createSmall("\u00b0E, Lat: ");
        PanLabel s3Label5 = PanLabel.createSmall("\u00b0N");
        this.subsolarLonTF_ = PanTextField.createSmallDoubleField("lonlat.proj.subsolar.lon", this.pmeta_.getDouble("lonlat.proj.subsolar.lon"));
        this.subsolarLatTF_ = PanTextField.createSmallDoubleField("lonlat.proj.subsolar.lat", this.pmeta_.getDouble("lonlat.proj.subsolar.lat"));
        QuickBox s3Box = QuickBox.createLeftBox(s3Label1, s3Label2, s3Label3, this.subsolarLonTF_, s3Label4, this.subsolarLatTF_, s3Label5);
        GuiUtils.matchLabelWidths(s1Label, s2Label1, s3Label1);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)s1Box, new FGConstraint(0, 0));
        this.add((Component)s2Box, new FGConstraint(0, 1));
        this.add((Component)s3Box, new FGConstraint(0, 2));
        this.refresh();
    }

    private final void attachListeners() {
        this.shadingCB_.addItemListener(e -> this.pmeta_.setBoolean("lonlat.proj.shading.vis", this.shadingCB_.isSelected()));
        this.sOpacitySpinner_.addChangeListener(e -> this.pmeta_.setInt("lonlat.proj.shading.opacity", this.sOpacitySpinner_.getIntValue()));
        FocusAdapter lonlatFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatShadingControls.this.handleSubsolarTF();
            }
        };
        this.subsolarLonTF_.addFocusListener(lonlatFL);
        this.subsolarLatTF_.addFocusListener(lonlatFL);
        this.subsolarLonTF_.addActionListener(e -> this.handleSubsolarTF());
        this.subsolarLatTF_.addActionListener(e -> this.handleSubsolarTF());
    }

    private final void handleSubsolarTF() {
        double lat;
        if (this.subsolarLonTF_ == null || this.subsolarLatTF_ == null || this.pmeta_ == null) {
            return;
        }
        double lon = this.getSubsolarLon();
        if (Double.isNaN(lon)) {
            lon = this.pmeta_.getDouble("lonlat.proj.subsolar.lon");
            this.subsolarLonTF_.setText(PrintfFormat.PFORMAT_7G.sprintg(lon));
        }
        boolean shifted = false;
        while (lon > 180.0) {
            lon -= 360.0;
            shifted = true;
        }
        while (lon < -180.0) {
            lon += 360.0;
            shifted = true;
        }
        if (shifted) {
            this.subsolarLonTF_.setText(PrintfFormat.PFORMAT_7G.sprintg(lon));
        }
        if ((lat = this.getSubsolarLat()) < -90.0 || lat > 90.0) {
            lat = MathUtils.minmax(-90.0, 90.0, lat);
            this.subsolarLatTF_.setText(PrintfFormat.PFORMAT_7G.sprintg(lat));
        }
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup({"lonlat.proj.subsolar.lon", lon}, {"lonlat.proj.subsolar.lat", lat});
        }
    }

    private double getSubsolarLon() {
        String s = this.subsolarLonTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lon TF '{}'", (Object)s);
            return Double.NaN;
        }
    }

    private double getSubsolarLat() {
        String s = this.subsolarLatTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lat TF '{}')", (Object)s);
            return Double.NaN;
        }
    }
}

