/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanRadioButton;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JSeparator;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLonLatTrajectoryControls
extends PanAbstractControlsPanel {
    private PanColorComboBox[] strokeColorCombos_ = new PanColorComboBox[2];
    private PanEnumComboBox[] strokeStyleMenus_ = new PanEnumComboBox[2];
    private PanIntSpinner[] strokeWeightSpinners_ = new PanIntSpinner[2];
    private PanEnumComboBox[] ptSymbolMenus_ = new PanEnumComboBox[2];
    private PanFloatComboBox[] ptSymbolSizeMenus_ = new PanFloatComboBox[2];
    private PanRadioButton[] capDfltButtons_ = new PanRadioButton[2];
    private PanRadioButton[] capUserButtons_ = new PanRadioButton[2];
    private PanTextField[] captionTF_ = new PanTextField[2];
    private PanColorComboBox bgColorCombo_;
    private PanCheckBox skipNaNsCB_;

    public PanLonLatTrajectoryControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("trajectory-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        PanLabel bgLabel1 = PanLabel.createSmall("Background: ");
        this.bgColorCombo_ = PanColorComboBox.createSmallGrayscale("feature.background");
        this.bgColorCombo_.setSelectedColor(this.pmeta_.getColor("feature.background"));
        this.skipNaNsCB_ = PanCheckBox.createSmall("feature.nanskip", "Skip points with NaN value", this.pmeta_.getBoolean("feature.nanskip"));
        QuickBox topBox = QuickBox.createCenterBox(bgLabel1, this.bgColorCombo_, Box.createHorizontalStrut(30), this.skipNaNsCB_);
        PanLabel t1Label = PanLabel.createSmall("Trajectory 1: ");
        PanLabel t2Label = PanLabel.createSmall("Trajectory 2: ");
        QuickBox[] strokeStyleBoxes = new QuickBox[2];
        QuickBox[] strokeColorBoxes = new QuickBox[2];
        QuickBox[] symbolBoxes = new QuickBox[2];
        QuickBox[] captionBoxes = new QuickBox[2];
        for (int i = 0; i < 2; ++i) {
            PanLabel t1SymbolLabel1 = PanLabel.createSmall("Point: ");
            PanLabel t1SymbolLabel2 = PanLabel.createSmall("Symbol: ");
            PanLabel t1SymbolLabel3 = PanLabel.createSmall(", Size: ");
            this.ptSymbolMenus_[i] = PanEnumComboBox.createSmall(PanParameterKeys.FEATURE_SYMBOL_ID[i], SymbolID.class);
            this.ptSymbolSizeMenus_[i] = PanFloatComboBox.createSmall(PanParameterKeys.FEATURE_SYMBOL_SIZE[i], 1.0f, 20.0f);
            this.ptSymbolMenus_[i].setSelectedItem(this.pmeta_.getString(PanParameterKeys.FEATURE_SYMBOL_ID[i]));
            this.ptSymbolSizeMenus_[i].setValue(this.pmeta_.getFloat(PanParameterKeys.FEATURE_SYMBOL_SIZE[i]));
            symbolBoxes[i] = QuickBox.createLeftBox(t1SymbolLabel1, t1SymbolLabel2, this.ptSymbolMenus_[i], t1SymbolLabel3, this.ptSymbolSizeMenus_[i]);
            PanLabel t1StrokeLabel1 = PanLabel.createSmall("Stroke: ");
            PanLabel t1StrokeLabel2 = PanLabel.createSmall("Style: ");
            PanLabel t2StrokeLabel1 = PanLabel.createSmall(" ");
            PanLabel t2StrokeLabel2 = PanLabel.createSmall("Color: ");
            PanLabel t2StrokeLabel3 = PanLabel.createSmall(", Weight: ");
            PanLabel t2StrokeLabel4 = PanLabel.createSmall("%");
            this.strokeStyleMenus_[i] = PanEnumComboBox.createSmall(PanParameterKeys.STROKE_STYLE[i], PanStrokeStyle.class);
            this.strokeStyleMenus_[i].setSelectedItem(this.pmeta_.getString(PanParameterKeys.STROKE_STYLE[i]));
            this.strokeColorCombos_[i] = PanColorComboBox.createSmallRainbow(PanParameterKeys.STROKE_COLOR[i]);
            this.strokeColorCombos_[i].setSelectedColor(this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i] = PanIntSpinner.createSmallWeightX5(PanParameterKeys.STROKE_WEIGHT[i], this.pmeta_.getInt(PanParameterKeys.STROKE_WEIGHT[i]), 500);
            strokeStyleBoxes[i] = QuickBox.createLeftBox(t1StrokeLabel1, t1StrokeLabel2, this.strokeStyleMenus_[i]);
            strokeColorBoxes[i] = QuickBox.createLeftBox(t2StrokeLabel1, t2StrokeLabel2, this.strokeColorCombos_[i], t2StrokeLabel3, this.strokeWeightSpinners_[i], t2StrokeLabel4, Box.createHorizontalStrut(12));
            PanLabel t1CapLabel1 = PanLabel.createSmall("Caption: ");
            this.capDfltButtons_[i] = PanRadioButton.createSmall(PanParameterKeys.STROKE_LABEL_CUSTOM[i], "Default", !this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[i]));
            this.capUserButtons_[i] = PanRadioButton.createSmall(PanParameterKeys.STROKE_LABEL_CUSTOM[i], "Other:", this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[i]));
            ButtonGroup t1CapChoices = new ButtonGroup();
            t1CapChoices.add(this.capDfltButtons_[i]);
            t1CapChoices.add(this.capUserButtons_[i]);
            this.captionTF_[i] = PanTextField.createSmall(PanParameterKeys.STROKE_LABEL_TEXT[i], this.pmeta_.getString(PanParameterKeys.STROKE_LABEL_TEXT[i]), 20);
            captionBoxes[i] = QuickBox.createLeftBox(t1CapLabel1, this.capDfltButtons_[i], this.capUserButtons_[i], this.captionTF_[i]);
            GuiUtils.matchLabelWidths(t1SymbolLabel1, t1StrokeLabel1, t2StrokeLabel1);
            GuiUtils.matchLabelWidths(t1SymbolLabel2, t1StrokeLabel2, t2StrokeLabel2);
        }
        int tfh = this.captionTF_[0].getPreferredSize().height;
        this.captionTF_[0].setMinimumSize(new Dimension(150, tfh));
        this.captionTF_[0].setPreferredSize(new Dimension(225, tfh));
        this.captionTF_[0].setMaximumSize(new Dimension(1000, tfh));
        this.captionTF_[1].setMinimumSize(new Dimension(150, tfh));
        this.captionTF_[1].setPreferredSize(new Dimension(225, tfh));
        this.captionTF_[1].setMaximumSize(new Dimension(1000, tfh));
        FlexingGridLayout fgl = new FlexingGridLayout(4, 5, 0, 2);
        fgl.setColumnWeight(1, 9999.0f);
        fgl.setColumnWeight(3, 9999.0f);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)topBox, new FGConstraint(0, 0, 4, 1, 0.5, 0.5));
        this.add((Component)new JSeparator(), new FGConstraint(0, 1, 4, 1));
        this.add((Component)t1Label, new FGConstraint(0, 2));
        this.add((Component)symbolBoxes[0], new FGConstraint(1, 2));
        this.add((Component)strokeStyleBoxes[0], new FGConstraint(1, 3));
        this.add((Component)strokeColorBoxes[0], new FGConstraint(1, 4));
        this.add((Component)t2Label, new FGConstraint(2, 2));
        this.add((Component)symbolBoxes[1], new FGConstraint(3, 2));
        this.add((Component)strokeStyleBoxes[1], new FGConstraint(3, 3));
        this.add((Component)strokeColorBoxes[1], new FGConstraint(3, 4));
    }

    private final void attachListeners() {
        this.bgColorCombo_.addItemListener(e -> {
            Color cold;
            if (e.getStateChange() != 1) {
                return;
            }
            int index = this.bgColorCombo_.getSelectedIndex();
            if (index < 0 || index >= this.bgColorCombo_.getItemCount()) {
                return;
            }
            Color cnew = this.bgColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("feature.background"))) {
                this.pmeta_.setColor("feature.background", cnew);
            }
        });
        this.skipNaNsCB_.addItemListener(e -> {
            boolean checked = this.skipNaNsCB_.isSelected();
            this.pmeta_.setBoolean("feature.nanskip", checked);
        });
        int i = 0;
        while (i < 2) {
            final int ii = i++;
            this.strokeColorCombos_[ii].addItemListener(e -> {
                Color cold;
                if (e.getStateChange() != 1) {
                    return;
                }
                int index = this.strokeColorCombos_[ii].getSelectedIndex();
                if (index < 0 || index >= this.strokeColorCombos_[ii].getItemCount()) {
                    return;
                }
                Color cnew = this.strokeColorCombos_[ii].getSelectedColor();
                if (!cnew.equals(cold = this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[ii]))) {
                    this.pmeta_.setColor(PanParameterKeys.STROKE_COLOR[ii], cnew);
                }
            });
            this.strokeStyleMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParameterKeys.STROKE_STYLE[ii], this.strokeStyleMenus_[ii].getStringValue());
            });
            this.strokeWeightSpinners_[ii].addChangeListener(e -> this.pmeta_.setInt(PanParameterKeys.STROKE_WEIGHT[ii], this.strokeWeightSpinners_[ii].getIntValue()));
            this.ptSymbolMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParameterKeys.FEATURE_SYMBOL_ID[ii], this.ptSymbolMenus_[ii].getStringValue());
            });
            this.ptSymbolSizeMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.setFloat(PanParameterKeys.FEATURE_SYMBOL_SIZE[ii], this.ptSymbolSizeMenus_[ii].getValue());
            });
            this.capDfltButtons_[0].addActionListener(e -> this.pmeta_.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0], this.capUserButtons_[0].isSelected()));
            this.capUserButtons_[ii].addActionListener(e -> this.pmeta_.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[ii], this.capUserButtons_[ii].isSelected()));
            this.captionTF_[ii].addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (PanLonLatTrajectoryControls.this.captionTF_[ii] == null || PanLonLatTrajectoryControls.this.pmeta_ == null) {
                        return;
                    }
                    PanLonLatTrajectoryControls.this.pmeta_.setString(PanParameterKeys.STROKE_LABEL_TEXT[ii], PanLonLatTrajectoryControls.this.captionTF_[ii].getText());
                }
            });
            this.captionTF_[ii].addActionListener(e -> this.pmeta_.setString(PanParameterKeys.STROKE_LABEL_TEXT[ii], this.captionTF_[ii].getText()));
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
        boolean enable1 = true;
        boolean enable2 = false;
        if (ctype == PanCombinationType.COMPARE) {
            enable2 = true;
        } else if (ctype == PanCombinationType.A2_ONLY) {
            enable1 = false;
            enable2 = true;
        }
        this.ptSymbolMenus_[0].setEnabled(enable1);
        this.ptSymbolSizeMenus_[0].setEnabled(enable1);
        this.strokeColorCombos_[0].setEnabled(enable1);
        this.strokeStyleMenus_[0].setEnabled(enable1);
        this.strokeWeightSpinners_[0].setEnabled(enable1);
        this.capDfltButtons_[0].setEnabled(enable1);
        this.capUserButtons_[0].setEnabled(enable1);
        this.captionTF_[0].setEnabled(enable1);
        this.ptSymbolMenus_[1].setEnabled(enable2);
        this.ptSymbolSizeMenus_[1].setEnabled(enable2);
        this.strokeColorCombos_[1].setEnabled(enable2);
        this.strokeStyleMenus_[1].setEnabled(enable2);
        this.strokeWeightSpinners_[1].setEnabled(enable2);
        this.capDfltButtons_[1].setEnabled(enable2);
        this.capUserButtons_[1].setEnabled(enable2);
        this.captionTF_[1].setEnabled(enable2);
    }
}

