/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.panoply.plotui.table.PanArray2DTableModel;
import gov.nasa.giss.text.PrintfFormat;

public class PanArray2DAverageTableModel
extends PanArray2DTableModel {
    public PanArray2DAverageTableModel(NcArray2D array) {
        super(array);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        try {
            return this.array_.getYAxis().getLength();
        }
        catch (Exception exc) {
            return 0;
        }
    }

    @Override
    public String getColumnName(int col) {
        return "Avg.";
    }

    @Override
    public String getRowName(int row) {
        try {
            int rowx;
            int n = rowx = this.flippedBT_ ? this.getRowCount() - 1 - row : row;
            if (this.showCellIndex_) {
                return Integer.toString(rowx + 1);
            }
            double val = this.array_.getYAxis().valueAt(rowx);
            return PrintfFormat.PFORMAT_7G.sprintg(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            int rowx = this.flippedBT_ ? this.getRowCount() - 1 - row : row;
            return this.valFormatter_.sprintf((Object)this.array_.rowAverageOf(rowx));
        }
        catch (Exception exc) {
            return "ERR";
        }
    }
}

