/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.panoply.plotui.table.PanArrayTableModel;
import gov.nasa.giss.text.PrintfFormat;

public class PanArray2DTableModel
extends PanArrayTableModel {
    protected NcArray2D array_;

    public PanArray2DTableModel(NcArray2D array) {
        this.array_ = array;
    }

    @Override
    public int getColumnCount() {
        try {
            return this.array_.getXAxis().getLength();
        }
        catch (Exception exc) {
            return 0;
        }
    }

    @Override
    public int getRowCount() {
        try {
            return this.array_.getYAxis().getLength();
        }
        catch (Exception exc) {
            return 0;
        }
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        try {
            int colx;
            int n = colx = this.flippedLR_ ? this.getColumnCount() - 1 - col : col;
            if (this.showCellIndex_) {
                return Integer.toString(colx + 1);
            }
            double val = this.array_.getXAxis().valueAt(colx);
            return PrintfFormat.PFORMAT_7G.sprintg(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public String getRowName(int row) {
        try {
            int rowx;
            int n = rowx = this.flippedBT_ ? this.getRowCount() - 1 - row : row;
            if (this.showCellIndex_) {
                return Integer.toString(rowx + 1);
            }
            double val = this.array_.getYAxis().valueAt(rowx);
            return PrintfFormat.PFORMAT_7G.sprintg(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            int rowx = this.flippedBT_ ? this.getRowCount() - 1 - row : row;
            int colx = this.flippedLR_ ? this.getColumnCount() - 1 - col : col;
            return this.valFormatter_.sprintf((Object)this.array_.valueAt(colx, rowx));
        }
        catch (Exception ignore) {
            return "ERR";
        }
    }

    @Override
    public void setFlipBT(boolean flipped) {
        this.flippedBT_ = flipped;
        this.fireTableDataChanged();
    }

    @Override
    public void setFlipLR(boolean flipped) {
        this.flippedLR_ = flipped;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }
}

