/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.data.nc.NcVarClass;
import gov.nasa.giss.data.nc.NcVarSorting;
import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableOutlierShape;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.graphics.PaperSize;
import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.bookmarks.PanBookmark;
import gov.nasa.giss.panoply.bookmarks.PanBookmarkFolder;
import gov.nasa.giss.panoply.bookmarks.PanBookmarkList;
import gov.nasa.giss.panoply.bookmarks.PanBookmarkNode;
import gov.nasa.giss.panoply.bookmarks.PanBookmarkType;
import gov.nasa.giss.panoply.bookmarks.PanHistoryFolder;
import gov.nasa.giss.panoply.bookmarks.PanHistoryList;
import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.panoply.util.PanAlphaMethod;
import gov.nasa.giss.panoply.util.PanAnimationFormat;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanAxisTickColor;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanContourLocation;
import gov.nasa.giss.panoply.util.PanContourStyle;
import gov.nasa.giss.panoply.util.PanLonLatPlotType;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanPlotSize;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanScaleCaptionLocation;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.panoply.util.PanVectorStyle;
import gov.nasa.giss.prefs.AbstractPreferences;
import gov.nasa.giss.prefs.PreferencesHash;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import gov.nasa.giss.util.EasyXmlParser;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Objects;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanPreferences
extends AbstractPreferences {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String LATEST_PREFS_VERSION = "4.1.2";

    public static PanPreferences getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanPreferences() {
        super("gov.nasa.giss", "Panoply");
    }

    @Override
    public synchronized void restoreDefaults() {
        super.set("beta:numberlays", FALSE);
        super.set("beta:underlays", FALSE);
        super.set("files:open.path", System.getProperty("user.home"));
        super.set("files:save.path", System.getProperty("user.home"));
        super.set("files:launch.dialog", TRUE);
        super.set("files:save.image.dialog", FALSE);
        super.set("files:save.image.extension", "PNG");
        super.set("files:save.pspdf.paper", PaperSize.LETTER.name().toLowerCase());
        super.set("files:save.pspdf.vectorized", FALSE);
        super.set("files:save.kmz.scale", TRUE);
        super.set("files:save.kmz.knockout", TRUE);
        super.set("files:save.kmz.border", FALSE);
        super.set("files:save.animation.extension", PanAnimationFormat.MP4.name().toLowerCase());
        super.set("files:save.animation.frate", 8);
        super.set("files:save.animation.quality", 100);
        super.set("files:save.animation.subtitles.vis", TRUE);
        super.set("files:save.animation.subtitles.type", "value");
        super.set("files:save.animation.options", FALSE);
        super.set("files:save.export.warning", TRUE);
        super.set("files:grib.strict", TRUE);
        super.set("files:history.days", 30);
        super.set("files:autoimport.colorbars", FALSE);
        super.set("files:autoimport.overlays", FALSE);
        super.set("files:autoimport.underlays", FALSE);
        super.set("app:version.enabled", TRUE);
        super.set("app:version.count", 0);
        super.set("app:version.last", PanProperties.VERSION_PROPS.getString("build-date"));
        super.set("app:version.next", PanProperties.VERSION_PROPS.getString("build-date"));
        super.set("app:version.skip", "");
        super.set("sources:bounds.left", -1);
        super.set("sources:bounds.top", -1);
        super.set("sources:bounds.width", 600);
        super.set("sources:bounds.height", 500);
        super.set("sources:nodes.expanded", TRUE);
        super.set("sources:toolbar.labels", TRUE);
        super.set("sources:info.vis", TRUE);
        super.set("sources:info.width", 30);
        super.set("sources:info.enhanced", FALSE);
        super.set("sources:datasets.sorting", NcVarSorting.ALPHA.name().toLowerCase());
        super.set("sources:datasets.varclass", NcVarClass.ALL.name().toLowerCase());
        super.set("sources:datasets.find.vis", FALSE);
        super.set("sources:catalogs.find.vis", FALSE);
        super.set("sources:catalogs.find.warned", FALSE);
        super.set("sources:bookmarks.find.vis", FALSE);
        if (PanPreferences.isPreferencesFileDisabled() || PlatformUtils.isHeadless()) {
            super.set("plot:size.factor", 140);
        } else if (PanPlotSize.fitsDisplay(140)) {
            super.set("plot:size.factor", 140);
        } else if (PanPlotSize.fitsDisplay(120)) {
            super.set("plot:size.factor", 120);
        } else if (PanPlotSize.fitsDisplay(100)) {
            super.set("plot:size.factor", 100);
        } else {
            super.set("plot:size.factor", 80);
        }
        super.set("plot:color.background", Color.WHITE);
        super.set("plot:font.master", "SansSerif");
        super.set("plot:1d.grid.style", PanStrokeStyle.SOLID.name().toLowerCase());
        super.set("plot:1d.grid.weight", 50);
        super.set("plot:1d.axes.offset", TRUE);
        super.set("plot:1d.axes.tickmark.weight", 100);
        super.set("plot:1d.axes.tickmark.color", PanAxisTickColor.BORDER.name().toLowerCase());
        super.set("plot:1d.xaxis.label.size", Float.valueOf(11.0f));
        super.set("plot:1d.yaxis.label.size", Float.valueOf(11.0f));
        super.set("plot:1d.xaxis.tick.size", Float.valueOf(9.0f));
        super.set("plot:1d.yaxis.tick.size", Float.valueOf(9.0f));
        super.set("plot:2d.grid.color", Color.BLACK);
        super.set("plot:2d.grid.style", PanStrokeStyle.SOLID.name().toLowerCase());
        super.set("plot:2d.grid.weight", 50);
        super.set("plot:2d.axes.offset", FALSE);
        super.set("plot:2d.axes.tickmark.weight", 100);
        super.set("plot:2d.axes.tickmark.color", PanAxisTickColor.BORDER.name().toLowerCase());
        super.set("plot:2d.xaxis.label.size", Float.valueOf(11.0f));
        super.set("plot:2d.yaxis.label.size", Float.valueOf(11.0f));
        super.set("plot:2d.xaxis.tick.size", Float.valueOf(9.0f));
        super.set("plot:2d.yaxis.tick.size", Float.valueOf(9.0f));
        super.set("plot:xaxis.div.major", 6);
        super.set("plot:yaxis.div.major", 6);
        super.set("plot:xaxis.div.minor", 2);
        super.set("plot:yaxis.div.minor", 2);
        super.set("plot:interpolate", TRUE);
        super.set("plot:scale.autofit", FALSE);
        super.set("plot:scale.method", PanScaleMethod.SCALAR.name().toLowerCase());
        super.set("plot:scale.tick.format", "%.1f");
        super.set("plot:scale.div.major", 5);
        super.set("plot:scale.div.minor", 2);
        super.set("plot:scale.minmax.note", TRUE);
        super.set("plot:scale.minmax.format", "Same");
        super.set("plot:scale.colorbar", PanUtils.getColorTableResourceList().getBackingObject("panoply.act"));
        super.set("plot:scale.invalids", new Color(191, 191, 191));
        super.set("plot:scale.width", 60);
        super.set("plot:scale.reverse", FALSE);
        super.set("plot:scale.outlier.shape", ColorTableOutlierShape.TRIANGLE.name().toLowerCase());
        super.set("plot:scale.outlier.side", PanColorbarOutlierSide.BOTH.name().toLowerCase());
        super.set("plot:scale.outlier.gap", PanColorbarOutlierGap.THIN.name().toLowerCase());
        super.set("plot:scale.tick.size", Float.valueOf(11.0f));
        super.set("plot:scale.label.location", PanScaleCaptionLocation.ABOVE.name().toLowerCase());
        super.set("plot:contour.style", PanContourStyle.NONE.name().toLowerCase());
        super.set("plot:contour.color", Color.BLACK);
        super.set("plot:contour.weight", 75);
        super.set("plot:contour.location", PanContourLocation.MAJOR.name().toLowerCase());
        super.set("plot:contour.label.vis", FALSE);
        super.set("plot:contour.label.size", Float.valueOf(6.5f));
        super.set("plot:vector.style", PanVectorStyle.ARROW.name().toLowerCase());
        super.set("plot:vector.color", Color.BLACK);
        super.set("plot:vector.weight", 75);
        super.set("plot:vector.spacing", 110);
        super.set("plot:vector.sample", TRUE);
        super.set(PanParameterKeys.P_LINE_STROKE_COLOR[0], Color.RED);
        super.set(PanParameterKeys.P_LINE_STROKE_COLOR[1], Color.BLUE);
        super.set(PanParameterKeys.P_LINE_STROKE_STYLE[0], PanStrokeStyle.SOLID.name().toLowerCase());
        super.set(PanParameterKeys.P_LINE_STROKE_STYLE[1], PanStrokeStyle.SOLID.name().toLowerCase());
        super.set(PanParameterKeys.P_LINE_STROKE_WEIGHT[0], 150);
        super.set(PanParameterKeys.P_LINE_STROKE_WEIGHT[1], 150);
        super.set(PanParameterKeys.P_TRAJ_STROKE_COLOR[0], Color.BLACK);
        super.set(PanParameterKeys.P_TRAJ_STROKE_COLOR[1], Color.RED);
        super.set(PanParameterKeys.P_TRAJ_STROKE_STYLE[0], "NONE");
        super.set(PanParameterKeys.P_TRAJ_STROKE_STYLE[1], "NONE");
        super.set(PanParameterKeys.P_TRAJ_STROKE_WEIGHT[0], 50);
        super.set(PanParameterKeys.P_TRAJ_STROKE_WEIGHT[1], 50);
        super.set("plot:xy.size.width", 80);
        super.set("plot:xy.size.height", 40);
        super.set("plot:xy.xaxis.div.major", 5);
        super.set("plot:xy.xaxis.div.minor", 2);
        super.set("plot:xy.xaxis.tick.format", "%.1f");
        super.set("plot:xy.yaxis.div.major", 5);
        super.set("plot:xy.yaxis.div.minor", 2);
        super.set("plot:xy.yaxis.tick.format", "%.1f");
        super.set("plot:xy.yaxis.posup", TRUE);
        super.set("plot:lonlat.lltype", PanLonLatPlotType.MAP.name().toLowerCase());
        super.set("plot:lonlat.size.width", 100);
        super.set("plot:lonlat.size.height", 50);
        super.set("plot:lonlat.proj.name", "Equirectangular");
        super.set("plot:lonlat.proj.lon0", 0.0);
        super.set("plot:lonlat.proj.lat0", 0.0);
        super.set("plot:lonlat.border.weight", 150);
        super.set("plot:grid.spacing.lon", Float.valueOf(15.0f));
        super.set("plot:grid.spacing.lat", Float.valueOf(15.0f));
        super.set("plot:grid.offset.lat", FALSE);
        super.set("plot:grid.label.step", 0);
        super.set("plot:grid.label.size", Float.valueOf(6.5f));
        super.set(PanParameterKeys.P_LON_LAT_OVERLAY_NAME[0], PanUtils.getOverlayResourceList().getBackingObject("Earth.cno"));
        super.set(PanParameterKeys.P_LON_LAT_OVERLAY_COLOR[0], Color.BLACK);
        super.set(PanParameterKeys.P_LON_LAT_OVERLAY_INVERT[0], FALSE);
        super.set(PanParameterKeys.P_LON_LAT_OVERLAY_STYLE[0], PanStrokeStyle.SOLID.name().toLowerCase());
        super.set(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_ID[0], SymbolID.DOT.name().toLowerCase());
        super.set(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_SIZE[0], Float.valueOf(6.0f));
        super.set(PanParameterKeys.P_LON_LAT_OVERLAY_WEIGHT[0], 75);
        try {
            for (int i = 1; i < 3; ++i) {
                super.set(PanParameterKeys.P_LON_LAT_OVERLAY_NAME[i], null);
                super.set(PanParameterKeys.P_LON_LAT_OVERLAY_COLOR[i], Color.GRAY);
                super.set(PanParameterKeys.P_LON_LAT_OVERLAY_INVERT[i], FALSE);
                super.set(PanParameterKeys.P_LON_LAT_OVERLAY_STYLE[i], PanStrokeStyle.SOLID.name().toLowerCase());
                super.set(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_ID[i], SymbolID.DOT.name().toLowerCase());
                super.set(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_SIZE[i], Float.valueOf(6.0f));
                super.set(PanParameterKeys.P_LON_LAT_OVERLAY_WEIGHT[i], 50);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.set("plot:lonlat.vector.dir1", "East");
        super.set("plot:lonlat.vector.dir2", "North");
        super.set("plot:lonlat.zonal.xaxis.left", -90.0);
        super.set("plot:lonlat.zonal.xaxis.right", 90.0);
        super.set("plot:lonlat.proj.shading.vis", FALSE);
        super.set("plot:lonlat.proj.shading.opacity", 40);
        super.set("plot:lonlat.proj.subsolar.lon", -74.0);
        super.set("plot:lonlat.proj.subsolar.lat", 23.0);
        super.set("plot:lonlat.underlay.vis", FALSE);
        super.set("plot:lonlat.underlay.name", null);
        super.set("plot:main.alpha.method", PanAlphaMethod.MINMAX.name());
        super.set("plot:main.alpha.1", 25);
        super.set("plot:main.alpha.2", 100);
        super.set("plot:main.alpha.knockout", true);
        super.set("plot:lonlat.numbers.vis", FALSE);
        super.set("plot:lonlat.numbers.invalids", TRUE);
        super.set("plot:lonlat.numbers.color", Color.BLACK);
        super.set("plot:lonlat.numbers.weight", 75);
        super.set("plot:lonlat.numbers.size", Float.valueOf(6.5f));
        super.set("plot:lonlat.numbers.spacing.lon", 10.0);
        super.set("plot:lonlat.numbers.spacing.lat", 8.0);
        super.set("plot:lonlat.numbers.offset.lon", FALSE);
        super.set("plot:lonlat.numbers.offset.lat", TRUE);
        super.set(PanParameterKeys.P_FEATURE_SYMBOL_ID[0], SymbolID.CIRCLE.name().toLowerCase());
        super.set(PanParameterKeys.P_FEATURE_SYMBOL_SIZE[0], Float.valueOf(6.0f));
        super.set(PanParameterKeys.P_FEATURE_SYMBOL_FILL[0], TRUE);
        super.set(PanParameterKeys.P_FEATURE_SYMBOL_ID[1], SymbolID.SQUARE.name().toLowerCase());
        super.set(PanParameterKeys.P_FEATURE_SYMBOL_SIZE[1], Float.valueOf(6.0f));
        super.set(PanParameterKeys.P_FEATURE_SYMBOL_FILL[1], TRUE);
        super.set("plot:feature.background", new Color(127, 127, 127));
        super.set("plot:feature.nanskip", TRUE);
        super.set("plot:lattime.size.width", 80);
        super.set("plot:lattime.size.height", 45);
        super.set("plot:lattime.xaxis.left", -90.0);
        super.set("plot:lattime.xaxis.right", 90.0);
        super.set("plot:latvert.size.width", 80);
        super.set("plot:latvert.size.height", 45);
        super.set("plot:latvert.xaxis.left", -90.0);
        super.set("plot:latvert.xaxis.right", 90.0);
        super.set("plot:latvert.yaxis.method", PanAxisMethod.SCALAR.name().toLowerCase());
        super.set("plot:latvert.yaxis.tick.format", "%.1f");
        super.set("plot:lontime.size.width", 80);
        super.set("plot:lontime.size.height", 45);
        super.set("plot:lontime.xaxis.left", -180.0);
        super.set("plot:lontime.xaxis.right", 180.0);
        super.set("plot:lonvert.size.width", 80);
        super.set("plot:lonvert.size.height", 45);
        super.set("plot:lonvert.xaxis.left", -180.0);
        super.set("plot:lonvert.xaxis.right", 180.0);
        super.set("plot:lonvert.yaxis.method", PanAxisMethod.SCALAR.name().toLowerCase());
        super.set("plot:lonvert.yaxis.tick.format", "%.1f");
        super.set("plot:timelat.size.width", 80);
        super.set("plot:timelat.size.height", 45);
        super.set("plot:timelat.xaxis.div.major", 5);
        super.set("plot:timelat.xaxis.div.minor", 2);
        super.set("plot:timelat.yaxis.top", 90.0);
        super.set("plot:timelat.yaxis.bottom", -90.0);
        super.set("plot:timevert.size.width", 80);
        super.set("plot:timevert.size.height", 45);
        super.set("plot:timevert.xaxis.div.major", 5);
        super.set("plot:timevert.xaxis.div.minor", 2);
        super.set("plot:timevert.yaxis.method", PanAxisMethod.SCALAR.name().toLowerCase());
        super.set("plot:timevert.yaxis.tick.format", "%.1f");
        super.set("plot:lineplot.grid.style", PanStrokeStyle.SOLID.name().toLowerCase());
        super.set("plot:lineplot.grid.weight", 50);
        super.set("plot:lineplot.horz.size.width", 80);
        super.set("plot:lineplot.horz.size.height", 40);
        super.set("plot:lineplot.vert.size.width", 80);
        super.set("plot:lineplot.vert.size.height", 60);
        super.set("units:c_is_celsius", FALSE);
        super.set("units:mb_is_millibar", FALSE);
        super.set("units:fraction_is_percent", FALSE);
        if (this.get("plot:scale.colorbar") == null) {
            super.set("plot:scale.colorbar", PanUtils.getColorTableResourceList().getBackingObject(0));
        }
        if (this.get(PanParameterKeys.P_LON_LAT_OVERLAY_NAME[0]) == null) {
            super.set(PanParameterKeys.P_LON_LAT_OVERLAY_NAME[0], PanUtils.getOverlayResourceList().getBackingObject(0));
        }
        PanProjectionPrefs.getSharedInstance();
    }

    @Override
    protected void readStream(InputStream istream) throws IOException, JDOMException {
        Document document = EasyXmlParser.parseDocument(istream);
        Element root = document.getRootElement();
        String rootName = root.getName();
        if (!"application".equals(rootName)) {
            LOGGER.warn("Root of prefs XML tree is not 'application'.");
            LOGGER.warn("Prefs file content will be ignored.");
            LOGGER.warn("Prefs file content will be overwritten when Panoply is exited.");
            return;
        }
        try {
            String name = root.getAttribute("name").getValue();
            if (!name.equalsIgnoreCase(this.getAppName())) {
                LOGGER.warn("Root of prefs file XML tree has wrong application name.");
                LOGGER.warn("Prefs file content will be ignored.");
                LOGGER.warn("Prefs file content will be overwritten when Panoply is exited.");
                return;
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read application name in prefs.");
            LOGGER.warn("Prefs file content will be ignored.");
            LOGGER.warn("Prefs file content will be overwritten when Panoply is exited.");
            return;
        }
        String version = LATEST_PREFS_VERSION;
        try {
            Attribute versionA = root.getAttribute("version");
            version = versionA.getValue();
            if (version == null || version.isEmpty()) {
                version = LATEST_PREFS_VERSION;
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse prefs version.");
            LOGGER.warn("Prefs file content will be ignored.");
            LOGGER.warn("Prefs file content will be overwritten when Panoply exits.");
            return;
        }
        if (version.compareTo(LATEST_PREFS_VERSION) < 0) {
            LOGGER.warn("Prefs file is older version.");
            LOGGER.warn("Defunct pref keys will be ignored if encountered.");
        } else if (version.compareTo(LATEST_PREFS_VERSION) > 0) {
            LOGGER.warn("Prefs file is newer version.");
            LOGGER.warn("Unknown pref keys will be ignored if encountered.");
        }
        boolean skipMost = false;
        try {
            Attribute plocaleA = root.getAttribute("locale");
            if (plocaleA == null) {
                LOGGER.trace("No prefs locale specified");
            } else {
                String locale = Locale.getDefault().toString();
                String plocale = plocaleA.getValue();
                if (!plocale.equalsIgnoreCase(locale)) {
                    LOGGER.warn("Prefs locale {} does not match default system locale {}.", (Object)plocale, (Object)locale);
                    LOGGER.warn("Prefs content will not be read except for bookmarks and history.");
                    LOGGER.warn("Prefs content will be overwritten when Panoply is exited.");
                    skipMost = true;
                }
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read prefs locale.");
            LOGGER.warn("Prefs content will not be read except for bookmarks and history.");
            LOGGER.warn("Prefs content will be overwritten when Panoply is exited.");
            skipMost = true;
        }
        for (Element child : root.getChildren()) {
            String tagName = child.getName();
            if ("property".equals(tagName)) {
                this.readProperty(this, child);
                continue;
            }
            if ("group".equals(tagName)) {
                String pkey = null;
                try {
                    pkey = child.getAttribute("key").getValue();
                }
                catch (Exception exc) {
                    LOGGER.warn("Unable to extract pref group key.");
                    return;
                }
                if (pkey == null) {
                    LOGGER.warn("Pref group has no key.");
                    continue;
                }
                if ("bookmarks".equals(pkey) || "history".equals(pkey)) {
                    this.readBookmarks(child);
                    continue;
                }
                if ("projections".equals(pkey)) {
                    this.readProjections(child);
                    continue;
                }
                if ("colortables".equals(pkey) || "overlays".equals(pkey) || skipMost) continue;
                this.readGroup(this, child);
                continue;
            }
            LOGGER.warn("Ignoring unknown pref key {} in root group.", (Object)tagName);
        }
    }

    private final void readGroup(PreferencesHash parent, Element group) {
        String pkey = null;
        try {
            pkey = group.getAttribute("key").getValue();
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to extract pref group key.");
            return;
        }
        if (pkey == null) {
            LOGGER.warn("Pref group has no key.");
            return;
        }
        Object already = parent.get(pkey);
        if (already == null) {
            LOGGER.warn("Ignoring unknown pref group with key {}.", (Object)pkey);
            return;
        }
        if (!(already instanceof PreferencesHash)) {
            LOGGER.warn("Existing pref {} is not a subgroup.", (Object)pkey);
            return;
        }
        PreferencesHash pg = (PreferencesHash)already;
        for (Element child : group.getChildren()) {
            String tagName = child.getName();
            if ("property".equals(tagName)) {
                this.readProperty(pg, child);
                continue;
            }
            if ("group".equals(tagName)) {
                this.readGroup(pg, child);
                continue;
            }
            LOGGER.warn("Ignoring key {} in group {}; probably an old ID.", (Object)tagName, (Object)pkey);
        }
    }

    private final void readProperty(PreferencesHash parent, Element child) {
        String pkey = null;
        String pvalue = null;
        try {
            pkey = child.getAttribute("key").getValue();
            pvalue = child.getAttribute("value").getValue();
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to parse a pref property.");
            return;
        }
        if (pkey == null) {
            LOGGER.warn("Pref property has no key.");
            return;
        }
        if (!parent.containsKey(pkey = this.updateKey(pkey))) {
            LOGGER.warn("Ignoring unknown pref key {} in {}", (Object)pkey, (Object)parent.getName());
            return;
        }
        Object already = parent.get(pkey);
        if (already == null && !pkey.contains("lonlat.overlay.") && !pkey.endsWith("name")) {
            LOGGER.warn("Ignoring pref for key {} as type is unknown", (Object)pkey);
            return;
        }
        if (pkey.contains("lonlat.overlay.") && pkey.endsWith("name")) {
            if (pvalue == null) {
                parent.set(pkey, null);
                return;
            }
            OverlayResourceList pol = PanUtils.getOverlayResourceList();
            Object o = PanUtils.getOverlayResourceList().getBackingObject(pvalue);
            if (o == null) {
                pvalue = pvalue.replaceAll(" outline$", ".CNO");
                o = pol.getBackingObject(pvalue);
            }
            if (o == null) {
                pvalue = pvalue.replaceAll("\\.CNO$", ".CNOB");
                o = pol.getBackingObject(pvalue);
            }
            if (o == null) {
                pvalue = pvalue.replaceAll(" mask$", ".GIF");
                o = pol.getBackingObject(pvalue);
            }
            parent.set(pkey, o);
        } else if (pkey.contains("lonlat.underlay.name") && pkey.endsWith("name")) {
            if (pvalue == null) {
                parent.set(pkey, null);
                return;
            }
            Object o = PanUtils.getUnderlayResourceList().getBackingObject(pvalue);
            parent.set(pkey, o);
        } else if (already instanceof AbstractColorTable) {
            ColorTableResourceList reslist = PanUtils.getColorTableResourceList();
            Object o = reslist.getBackingObject(pvalue);
            if (o == null) {
                LOGGER.warn("No color table for key {}", (Object)pvalue);
            } else {
                parent.set(pkey, o);
            }
        } else if (already instanceof Double) {
            try {
                parent.setDouble(pkey, pvalue);
            }
            catch (Exception exc) {
                LOGGER.warn("Bad double for key {}", (Object)pkey);
            }
        } else if (already instanceof Float) {
            try {
                parent.setFloat(pkey, pvalue);
            }
            catch (Exception exc) {
                LOGGER.warn("Bad float for key {}", (Object)pkey);
            }
        } else if (already instanceof Integer) {
            try {
                parent.setInt(pkey, pvalue);
            }
            catch (Exception exc) {
                LOGGER.warn("Bad int for key {}", (Object)pkey);
            }
        } else if (already instanceof Boolean) {
            parent.set(pkey, Boolean.valueOf(pvalue));
        } else if (already instanceof String) {
            parent.set(pkey, pvalue);
        } else if (already instanceof Color) {
            try {
                parent.setColor(pkey, pvalue);
            }
            catch (Exception exc) {
                LOGGER.warn("Bad color for key {}", (Object)pkey);
            }
        } else {
            LOGGER.warn("No class handler for pref property key {}", (Object)pkey);
            LOGGER.warn("Object is {}", already);
        }
    }

    private final void readBookmarks(Element bookmarksElement) {
        this.readBookmarksFolder(null, bookmarksElement);
    }

    private final void readBookmarksFolder(PanBookmarkNode parentNode, Element folderElement) {
        String folderType = folderElement.getName();
        if (parentNode == null && "group".equals(folderType)) {
            try {
                folderType = folderElement.getAttribute("key").getValue();
            }
            catch (Exception exc) {
                folderType = "unknown";
            }
        }
        PanBookmarkNode folder = null;
        if ("bookmarks".equals(folderType)) {
            folder = PanBookmarkList.getSharedInstance();
        } else if ("history".equals(folderType)) {
            folder = PanHistoryList.getSharedInstance();
        } else if ("folder".equals(folderType)) {
            if (parentNode instanceof PanHistoryList) {
                try {
                    String date = folderElement.getAttribute("name").getValue();
                    folder = new PanHistoryFolder(parentNode, date);
                    parentNode.add(folder);
                }
                catch (Exception exc) {
                    LOGGER.warn("Could not parse history folder date.");
                    if (LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                }
            } else {
                Attribute nameAttr = folderElement.getAttribute("name");
                String name = nameAttr != null ? nameAttr.getValue() : "Unnamed Folder";
                folder = new PanBookmarkFolder(parentNode, name);
                parentNode.add(folder);
            }
        } else {
            LOGGER.warn("Unknown bookmarks folder type.");
            return;
        }
        for (Element lchild : folderElement.getChildren()) {
            String lchildName = lchild.getName();
            if ("folder".equals(lchildName) || "day".equals(lchildName)) {
                this.readBookmarksFolder(folder, lchild);
                continue;
            }
            if (!"link".equals(lchildName)) continue;
            Attribute typeAttr = lchild.getAttribute("atype");
            Attribute addressAttr = lchild.getAttribute("address");
            Attribute nameAttr = lchild.getAttribute("name");
            if (typeAttr == null || addressAttr == null) continue;
            String address = addressAttr.getValue();
            String name = nameAttr != null ? nameAttr.getValue() : null;
            PanBookmark b = null;
            try {
                b = new PanBookmark(typeAttr.getValue(), (Object)address, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (b == null) continue;
            folder.add(b);
        }
        if ("folder".equals(folderType) && parentNode instanceof PanHistoryList && folder.getChildCount() < 1) {
            parentNode.remove(folder);
        }
    }

    private final void readProjections(Element projections) {
        LOGGER.trace("");
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        for (String pname : pprefs.getAllNames()) {
            pprefs.setFavorite(pname, true);
        }
        for (Element lchild : projections.getChildren()) {
            String lchildName = lchild.getName();
            if (!"projection".equals(lchildName)) continue;
            pprefs.initProjectionFromElement(lchild);
        }
    }

    @Override
    protected void saveStream(OutputStream ostream) throws IOException {
        block2: {
            Objects.requireNonNull(ostream, "Null output stream.");
            Element root = new Element("application");
            root.setAttribute("name", this.getAppName().toLowerCase());
            root.setAttribute("version", LATEST_PREFS_VERSION);
            root.setAttribute("locale", Locale.getDefault().toString());
            this.writeGroup(this, root);
            this.writeProjections(root);
            this.writeBookmarks(root);
            Document d = new Document(root);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            try {
                outputter.output(d, ostream);
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }

    private final void writeGroup(PreferencesHash group, Element element) {
        for (String pkey : group.keySet()) {
            Object pvalue = group.get(pkey);
            Element ex = null;
            if (pvalue instanceof PreferencesHash) {
                PreferencesHash pg = (PreferencesHash)pvalue;
                ex = new Element("group");
                ex.setAttribute("key", pkey);
                this.writeGroup(pg, ex);
            } else {
                ex = new Element("property");
                ex.setAttribute("key", pkey);
                if (pkey.contains("lonlat.overlay.") && !pkey.contains("lonlat.overlay.1") && !pkey.contains("lonlat.overlay.2") && !pkey.contains("lonlat.overlay.3")) continue;
                if (pkey.contains("lonlat.overlay.") && pkey.endsWith("name") && pvalue == null) {
                    ex.setAttribute("value", "NONE");
                } else if (pkey.contains("lonlat.underlay.name") && pkey.endsWith("name") && pvalue == null) {
                    ex.setAttribute("value", "NONE");
                } else if (pvalue instanceof Double || pvalue instanceof Float) {
                    ex.setAttribute("value", PrintfFormat.PFORMAT_10G.sprintg(pvalue));
                } else if (pvalue instanceof Color) {
                    String s = ColorUtils.colorToString((Color)pvalue);
                    ex.setAttribute("value", s);
                } else if (pvalue instanceof AbstractColorTable) {
                    ex.setAttribute("value", ((AbstractColorTable)pvalue).toString());
                } else if (pvalue instanceof MapOverlay) {
                    ex.setAttribute("value", ((MapOverlay)pvalue).toString());
                } else {
                    try {
                        ex.setAttribute("value", pvalue.toString());
                    }
                    catch (Exception exc) {
                        LOGGER.error("Exception setting value for pref {}", (Object)pkey);
                        LOGGER.error("Exception is {}", (Object)exc.toString());
                    }
                }
            }
            element.addContent(ex);
        }
    }

    private final void writeBookmarks(Element parentElement) throws IOException {
        PanBookmarkList blist = PanBookmarkList.getSharedInstance();
        this.writeBookmarksFolder(parentElement, blist);
        blist = PanHistoryList.getSharedInstance();
        ((PanHistoryList)blist).enforceAgeLimit(this.getInt("files:history.days"));
        this.writeBookmarksFolder(parentElement, blist);
    }

    private final void writeBookmarksFolder(Element parentElement, PanBookmarkNode folder) throws IOException {
        TreeTableNode[] children;
        Element ffex;
        if (folder instanceof PanHistoryList) {
            ffex = new Element("group");
            ffex.setAttribute("key", "history");
        } else if (folder instanceof PanHistoryFolder) {
            ffex = new Element("folder");
            ffex.setAttribute("name", ((PanHistoryFolder)folder).getDateString());
        } else if (folder instanceof PanBookmarkList) {
            ffex = new Element("group");
            ffex.setAttribute("key", "bookmarks");
        } else if (folder instanceof PanBookmarkFolder) {
            ffex = new Element("folder");
            if (folder.isNameSet()) {
                ffex.setAttribute("name", folder.getName());
            }
        } else {
            LOGGER.warn("Unknown bookmarks 'folder' type.");
            return;
        }
        block5: for (TreeTableNode child : children = folder.getChildren()) {
            PanBookmarkNode node = (PanBookmarkNode)child;
            if (node instanceof PanBookmark) {
                Element bfex = new Element("link");
                PanBookmark b = (PanBookmark)node;
                Object o = node.getObject();
                PanBookmarkType btype = b.getAccessType();
                switch (btype) {
                    case LOCAL_DATASET: {
                        bfex.setAttribute("atype", "local");
                        bfex.setAttribute("address", o.toString());
                        break;
                    }
                    case REMOTE_DATASET: {
                        bfex.setAttribute("atype", "remote");
                        bfex.setAttribute("address", o.toString());
                        break;
                    }
                    case CATALOG: {
                        bfex.setAttribute("atype", "catalog");
                        bfex.setAttribute("address", o.toString());
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                if (b.isNameSet()) {
                    bfex.setAttribute("name", b.getName());
                }
                ffex.addContent(bfex);
                continue;
            }
            if (!(node instanceof PanBookmarkFolder) && !(node instanceof PanHistoryFolder)) continue;
            this.writeBookmarksFolder(ffex, node);
        }
        parentElement.addContent(ffex);
    }

    private final void writeProjections(Element parent) throws IOException {
        Element group = new Element("group");
        group.setAttribute("key", "projections");
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        for (String pname : pprefs.getAllNames()) {
            Element fex = new Element("projection");
            fex.setAttribute("name", pname);
            boolean fave = pprefs.isFavorite(pname);
            if (!fave) {
                fex.setAttribute("fave", Boolean.toString(fave));
            }
            boolean hasParams = false;
            for (int i = 0; i < 5; ++i) {
                String pval = pprefs.getParam(pname, i);
                if (pval == null) continue;
                fex.setAttribute("param" + i, pval);
                hasParams = true;
            }
            if (!hasParams && fave) continue;
            group.addContent(fex);
        }
        parent.addContent(group);
    }

    @Override
    public Object get(String key) {
        Object o = super.get(key);
        if (o == null && key.equals("plot:scale.colorbar")) {
            o = PanUtils.getColorTableResourceList().getBackingObject(0);
        }
        return o;
    }

    private String updateKey(String pkey) {
        if (pkey.equals("grid.spacing")) {
            return "grid.spacing.lon";
        }
        return pkey;
    }

    private static class Singleton {
        private static final PanPreferences INSTANCE = new PanPreferences();

        private Singleton() {
        }
    }
}

