/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanAxisTickColor;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class Pan2DGridPrefsPanel
extends PanAbstractPrefsPanel {
    private PanEnumComboBox gridStyleCombo_;
    private PanColorComboBox gridColorCombo_;
    private PanIntSpinner gridWeightSpinner_;
    private PanCheckBox axesOffsetCB_;
    private PanEnumComboBox tickColorCombo_;
    private PanIntSpinner tickWeightSpinner_;
    private PanFloatComboBox xtickSizeCombo_;
    private PanFloatComboBox ytickSizeCombo_;

    public Pan2DGridPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("2D Color-Fill Grid Defaults"));
        PanLabel topText = PanLabel.create("When creating a color-fill plot, set\u2026");
        this.gridStyleCombo_ = PanEnumComboBox.create(PanStrokeStyle.class);
        this.gridColorCombo_ = PanColorComboBox.createRainbow(null);
        this.gridColorCombo_.setSelectedColor(prefs_.getColor("plot:2d.grid.color"));
        this.gridWeightSpinner_ = PanIntSpinner.createWeight(null, prefs_.getInt("plot:2d.grid.weight"), 200);
        this.axesOffsetCB_ = PanCheckBox.create("Offset axes from grid edges", prefs_.getBoolean("plot:2d.axes.offset"));
        this.tickColorCombo_ = PanEnumComboBox.create("plot:2d.axes.tickmark.color", PanAxisTickColor.class);
        this.tickWeightSpinner_ = PanIntSpinner.createWeight("plot:2d.axes.tickmark.weight", 50, 200);
        QuickBox tickBox = QuickBox.createLeftBox(PanLabel.create("Color: "), this.tickColorCombo_, PanLabel.create(", Weight"), this.tickWeightSpinner_, PanLabel.create("%"));
        this.xtickSizeCombo_ = PanFloatComboBox.create("plot:2d.xaxis.tick.size", 5.0f, 14.0f);
        this.ytickSizeCombo_ = PanFloatComboBox.create("plot:2d.yaxis.tick.size", 5.0f, 14.0f);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 8, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)PanLabel.create("Grid: "), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Style:"), this.gridStyleCombo_), new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Color: "), this.gridColorCombo_, PanLabel.create(", Weight: "), this.gridWeightSpinner_, PanLabel.create("%")), new FGConstraint(1, ++row));
        this.add((Component)this.axesOffsetCB_, new FGConstraint(1, ++row));
        this.add((Component)PanLabel.create("Axes Ticks: "), new FGConstraint(0, ++row, 1.0));
        this.add((Component)tickBox, new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("X-Axis Tick Label Size:"), this.xtickSizeCombo_), new FGConstraint(1, ++row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Y-Axis Tick Label Size:"), this.ytickSizeCombo_), new FGConstraint(1, ++row));
    }

    private final void attachListeners() {
        this.xtickSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.xtickSizeCombo_.getValue();
            prefs_.setFloat("plot:2d.xaxis.tick.size", value);
        });
        this.ytickSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.ytickSizeCombo_.getValue();
            prefs_.setFloat("plot:2d.yaxis.tick.size", value);
        });
        this.tickColorCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:2d.axes.tickmark.color", this.tickColorCombo_.getStringValue());
        });
        this.tickWeightSpinner_.addChangeListener(e -> prefs_.setInt("plot:2d.axes.tickmark.weight", this.tickWeightSpinner_.getIntValue()));
        this.gridStyleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:2d.grid.style", this.gridStyleCombo_.getStringValue());
        });
        this.gridColorCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:2d.grid.color", this.gridColorCombo_.getSelectedColor());
        });
        this.gridWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:2d.grid.weight", this.gridWeightSpinner_.getIntValue());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        this.gridStyleCombo_.setSelectedItem(prefs_.getString("plot:2d.grid.style"));
        this.gridColorCombo_.setSelectedColor(prefs_.getColor("plot:2d.grid.color"));
        this.gridWeightSpinner_.setValue(prefs_.getInt("plot:2d.grid.weight"));
        this.axesOffsetCB_.setSelected(prefs_.getBoolean("plot:2d.axes.offset"));
        this.xtickSizeCombo_.setValue(prefs_.getFloat("plot:2d.xaxis.tick.size"));
        this.ytickSizeCombo_.setValue(prefs_.getFloat("plot:2d.yaxis.tick.size"));
        this.tickColorCombo_.setSelectedItem(prefs_.getString("plot:2d.axes.tickmark.color"));
        this.tickWeightSpinner_.setValue(prefs_.getInt("plot:2d.axes.tickmark.weight"));
        this.refreshing_ = false;
    }
}

