/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanBetaPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox underlaysCB_;
    private PanCheckBox numberlaysCB_;

    public PanBetaPrefsPanel() {
        this.createLayout();
        this.attachListeners();
    }

    private final void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Beta Features"));
        PanLabel topText = PanLabel.create("What beta features should be enabled?");
        PanLabel restartText = PanLabel.createSmall("Changing beta settings may require restart.");
        this.underlaysCB_ = PanCheckBox.create("Enable lon-lat map plot KMZ underlays");
        this.numberlaysCB_ = PanCheckBox.create("Enable lon-lat map plot number layers");
        FlexingGridLayout fgl = new FlexingGridLayout(1, 8, 0, 2);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, 1));
        this.add((Component)this.underlaysCB_, new FGConstraint(0, 2));
        this.add((Component)this.numberlaysCB_, new FGConstraint(0, 3));
        this.add((Component)restartText, new FGConstraint(0, 5));
        this.refreshPrivate();
    }

    private final void attachListeners() {
        this.underlaysCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("beta:underlays", this.underlaysCB_.isSelected());
        });
        this.numberlaysCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("beta:numberlays", this.numberlaysCB_.isSelected());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        this.underlaysCB_.setSelected(prefs_.getBoolean("beta:underlays"));
        this.numberlaysCB_.setSelected(prefs_.getBoolean("beta:numberlays"));
        this.refreshing_ = false;
    }
}

