/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.colortable.PanColorTableFrame;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanColorbarTableModel;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTable;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import net.schmunk.ui.PlusMinus;

public class PanColorbarPrefsPanel
extends PanAbstractPrefsPanel
implements DropTargetListener {
    private JScrollPane ppanel_;
    private PlusMinus pmwidget_;
    private PanCommonPrefsTable table_;
    private PanCheckBox autoimportCB_;
    private KeyStroke cutKS_;
    private Border focusedTableBorder_;
    private Border unfocusedTableBorder_;

    public PanColorbarPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Color Tables Library"));
        this.setOpaque(false);
        this.autoimportCB_ = PanCheckBox.create("Always import new color tables into support library", false);
        this.ppanel_ = this.createTable();
        Border ob = this.ppanel_.getBorder();
        this.focusedTableBorder_ = new CompoundBorder(PanGuiConstants.THIN_FOCUSED_BORDER, ob);
        this.unfocusedTableBorder_ = new CompoundBorder(PanGuiConstants.THIN_UNFOCUSED_BORDER, ob);
        this.ppanel_.setBorder(this.unfocusedTableBorder_);
        GuiUtils.makeRecursiveDropTarget(this.ppanel_, this);
        this.pmwidget_ = new PlusMinus();
        this.pmwidget_.setMaximumSize(this.pmwidget_.getPreferredSize());
        this.pmwidget_.setIconEnabled(2001, false);
        PanLabel bText = PanLabel.createSmall("Built-in color tables cannot be removed.");
        FlexingGridLayout fgl = new FlexingGridLayout(2, 3, 12, 2);
        fgl.setRowWeight(1, 9999.0f);
        fgl.setColumnWeight(1, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)this.autoimportCB_, new FGConstraint(0, 0, 2, 1));
        this.add((Component)this.ppanel_, new FGConstraint(0, 1, 2, 1, true));
        this.add((Component)this.pmwidget_, new FGConstraint(0, 2));
        this.add((Component)bText, new FGConstraint(1, 2, 1.0));
    }

    private JScrollPane createTable() {
        this.table_ = new PanCommonPrefsTable(new PanColorbarTableModel());
        JScrollPane jsp = new JScrollPane(this.table_);
        jsp.setVerticalScrollBarPolicy(22);
        jsp.setHorizontalScrollBarPolicy(30);
        jsp.setOpaque(false);
        jsp.setMinimumSize(new Dimension(this.getPreferredSize().width / 2, 160));
        return jsp;
    }

    private final void attachListeners() {
        this.autoimportCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("files:autoimport.colorbars", this.autoimportCB_.isSelected());
        });
        this.pmwidget_.addActionListener(e -> {
            if (e.getID() == 2000) {
                PanFrame pf = (PanFrame)this.getTopLevelAncestor();
                File[] ff = PanFileUtils.showOpenColorTableFileChooser(pf);
                if (ff != null) {
                    PanUtils.getColorTableResourceList().addAlphabetic((Component)pf, ff);
                }
            } else if (e.getID() == 2001) {
                int row = this.table_.getSelectedRow();
                this.table_.getSelectionModel().clearSelection();
                this.deletionRequested(row);
            }
            this.refreshPrivate();
        });
        this.table_.getModel().addTableModelListener(e -> this.refreshPrivate());
        this.table_.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PanColorbarPrefsPanel.this.refreshPrivate();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PanColorbarPrefsPanel.this.refreshPrivate();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Point p = e.getPoint();
                int row = PanColorbarPrefsPanel.this.table_.rowAtPoint(p);
                Object o = PanColorbarPrefsPanel.this.table_.getModel().getValueAt(row, 0);
                if (!(o instanceof AbstractColorTable)) {
                    return;
                }
                AbstractColorTable act = (AbstractColorTable)o;
                PanColorTableFrame.getSharedInstance().reveal();
                PanColorTableFrame.getSharedInstance().setColorTable(act);
            }
        });
        Action cut = TransferHandler.getCutAction();
        ActionMap am = this.table_.getActionMap();
        Object cutKey = null;
        for (Object key : am.allKeys()) {
            Action a = am.get(key);
            if (a != cut) continue;
            cutKey = key;
            break;
        }
        InputMap im = this.table_.getInputMap(1);
        this.cutKS_ = null;
        for (KeyStroke ks : im.allKeys()) {
            Object o = im.get(ks);
            if (!o.equals(cutKey)) continue;
            this.cutKS_ = ks;
            break;
        }
        this.table_.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = PanColorbarPrefsPanel.this.table_.getSelectedRow();
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if (PanColorbarPrefsPanel.this.cutKS_ != null && ks.equals(PanColorbarPrefsPanel.this.cutKS_)) {
                    PanColorbarPrefsPanel.this.deletionRequested(row);
                    PanColorbarPrefsPanel.this.refreshPrivate();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int row = PanColorbarPrefsPanel.this.table_.getSelectedRow();
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if ((e.getKeyCode() == 8 || e.getKeyCode() == 127) && e.getModifiersEx() == 0) {
                    PanColorbarPrefsPanel.this.deletionRequested(row);
                } else if (PanColorbarPrefsPanel.this.cutKS_ != null && ks.equals(PanColorbarPrefsPanel.this.cutKS_)) {
                    PanColorbarPrefsPanel.this.deletionRequested(row);
                }
                PanColorbarPrefsPanel.this.refreshPrivate();
            }
        });
    }

    private final void deletionRequested(int index) {
        ColorTableResourceList reslist = PanUtils.getColorTableResourceList();
        reslist.remove(index);
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        this.autoimportCB_.setSelected(prefs_.getBoolean("files:autoimport.colorbars"));
        this.pmwidget_.setIconEnabled(2000, true);
        int row = this.table_.getSelectedRow();
        ColorTableResourceList reslist = PanUtils.getColorTableResourceList();
        if (row >= reslist.getSize()) {
            this.pmwidget_.setIconEnabled(2001, false);
        } else if (row >= 0) {
            this.pmwidget_.setIconEnabled(2001, reslist.canRemove(row));
        } else {
            this.pmwidget_.setIconEnabled(2001, false);
        }
        this.refreshing_ = false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.ppanel_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> droplist = FileUtils.getTransferredFileList(t);
            if (droplist != null) {
                ArrayList<File> addlist = new ArrayList<File>();
                for (File f : droplist) {
                    if (!ColorTableFilenameFilter.isColorTableName(f)) continue;
                    addlist.add(f);
                }
                PanUtils.getColorTableResourceList().addAlphabetic((Component)this, addlist);
            }
            e.dropComplete(true);
            this.repaint();
        } else {
            e.rejectDrop();
        }
        this.ppanel_.setBorder(this.unfocusedTableBorder_);
        this.ppanel_.invalidate();
        this.validate();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.ppanel_.setBorder(this.unfocusedTableBorder_);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.ppanel_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.ppanel_.setBorder(this.focusedTableBorder_);
        this.repaint();
    }
}

