/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanContourLocation;
import gov.nasa.giss.panoply.util.PanContourStyle;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanContourPrefsPanel
extends PanAbstractPrefsPanel {
    private PanEnumComboBox styleCombo_;
    private PanEnumComboBox locationCombo_;
    private PanColorComboBox colorCombo_;
    private PanIntSpinner weightSpinner_;
    private PanCheckBox clabelVisCB_;
    private PanLabel clabelSizeLabel_;
    private PanFloatComboBox clabelSizeCombo_;

    public PanContourPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.styleCombo_ = PanEnumComboBox.create(PanContourStyle.class);
        this.locationCombo_ = PanEnumComboBox.create(PanContourLocation.class);
        this.colorCombo_ = PanColorComboBox.createRainbow(null);
        this.weightSpinner_ = PanIntSpinner.createWeight(null, 100, 200);
        this.clabelVisCB_ = PanCheckBox.create("Visible,");
        this.clabelSizeLabel_ = PanLabel.create(" Size: ");
        this.clabelSizeCombo_ = PanFloatComboBox.create(5.0f, 10.0f);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 5, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtils.createPaddedTitleBorder("Contour Defaults"));
        this.add((Component)PanLabel.create("Style: "), new FGConstraint(0, 0, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.styleCombo_), new FGConstraint(1, 0));
        this.add((Component)PanLabel.create("Location: "), new FGConstraint(0, 1, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.locationCombo_), new FGConstraint(1, 1));
        this.add((Component)PanLabel.create("Color: "), new FGConstraint(0, 2, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.colorCombo_, PanLabel.create(", Weight: "), this.weightSpinner_), new FGConstraint(1, 2));
        this.add((Component)PanLabel.create("Labels: "), new FGConstraint(0, 3, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.clabelVisCB_, this.clabelSizeLabel_, this.clabelSizeCombo_), new FGConstraint(1, 3));
    }

    private final void attachListeners() {
        this.styleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            PanContourStyle cstyle = (PanContourStyle)this.styleCombo_.getSelectedItem();
            prefs_.set("plot:contour.style", cstyle.toString());
            this.clabelVisCB_.setEnabled(cstyle != PanContourStyle.NONE);
            this.clabelSizeLabel_.setEnabled(cstyle != PanContourStyle.NONE);
            this.clabelSizeCombo_.setEnabled(cstyle != PanContourStyle.NONE);
        });
        this.locationCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:contour.location", this.locationCombo_.getStringValue());
        });
        this.colorCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:contour.color", this.colorCombo_.getSelectedColor());
        });
        this.weightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:contour.weight", this.weightSpinner_.getIntValue());
        });
        this.clabelVisCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:contour.label.vis", this.clabelVisCB_.isSelected());
        });
        this.clabelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.clabelSizeCombo_.getValue();
            prefs_.setFloat("plot:contour.label.size", value);
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        PanContourStyle cstyle = PanContourStyle.matching(prefs_.getString("plot:contour.style"));
        this.styleCombo_.setSelectedItem(cstyle);
        this.locationCombo_.setSelectedItem(prefs_.getString("plot:contour.location"));
        this.colorCombo_.setSelectedColor(prefs_.getColor("plot:contour.color"));
        this.weightSpinner_.setValue(prefs_.getInt("plot:contour.weight"));
        this.clabelVisCB_.setSelected(prefs_.getBoolean("plot:contour.label.vis"));
        this.clabelSizeCombo_.setValue(prefs_.getFloat("plot:contour.label.size"));
        this.clabelVisCB_.setEnabled(cstyle != PanContourStyle.NONE);
        this.clabelSizeLabel_.setEnabled(cstyle != PanContourStyle.NONE);
        this.clabelSizeCombo_.setEnabled(cstyle != PanContourStyle.NONE);
        this.refreshing_ = false;
    }
}

