/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanTrajectoryPrefsPanel
extends PanAbstractPrefsPanel {
    private PanColorComboBox[] strokeColorCombos_ = new PanColorComboBox[2];
    private PanEnumComboBox[] strokeStyleMenus_ = new PanEnumComboBox[2];
    private PanIntSpinner[] strokeWeightSpinners_ = new PanIntSpinner[2];
    private PanEnumComboBox[] ptSymbolMenus_ = new PanEnumComboBox[2];
    private PanFloatComboBox[] ptSymbolSizeMenus_ = new PanFloatComboBox[2];
    private PanColorComboBox bgColorCombo_;
    private PanCheckBox skipNaNsCB_;

    public PanTrajectoryPrefsPanel() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Trajectory Plot Defaults"));
        this.setOpaque(false);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        PanLabel topText = PanLabel.create("When creating a trajctory plot, set\u2026");
        PanLabel bgLabel1 = PanLabel.create("Background: ");
        this.bgColorCombo_ = PanColorComboBox.createGrayscale("plot:feature.background");
        this.bgColorCombo_.setSelectedColor(prefs_.getColor("plot:feature.background"));
        this.skipNaNsCB_ = PanCheckBox.create("plot:feature.nanskip", "Skip points with NaN value", prefs_.getBoolean("plot:feature.nanskip"));
        PanLabel t1Label = PanLabel.create("Trajectory 1: ");
        PanLabel t2Label = PanLabel.create("Trajectory 2: ");
        QuickBox[] strokeStyleBoxes = new QuickBox[2];
        QuickBox[] strokeColorBoxes = new QuickBox[2];
        QuickBox[] symbolBoxes = new QuickBox[2];
        for (int i = 0; i < 2; ++i) {
            PanLabel t1SymbolLabel1 = PanLabel.create("Point: ");
            PanLabel t1SymbolLabel2 = PanLabel.create("Symbol: ");
            PanLabel t1SymbolLabel3 = PanLabel.create(", Size: ");
            this.ptSymbolMenus_[i] = PanEnumComboBox.create(PanParameterKeys.P_FEATURE_SYMBOL_ID[i], SymbolID.class);
            this.ptSymbolSizeMenus_[i] = PanFloatComboBox.create(PanParameterKeys.P_FEATURE_SYMBOL_SIZE[i], 1.0f, 12.0f);
            this.ptSymbolMenus_[i].setSelectedItem(prefs_.getString(PanParameterKeys.P_FEATURE_SYMBOL_ID[i]));
            this.ptSymbolSizeMenus_[i].setValue(prefs_.getFloat(PanParameterKeys.P_FEATURE_SYMBOL_SIZE[i]));
            symbolBoxes[i] = QuickBox.createLeftBox(t1SymbolLabel1, t1SymbolLabel2, this.ptSymbolMenus_[i], t1SymbolLabel3, this.ptSymbolSizeMenus_[i]);
            PanLabel t1StrokeLabel1 = PanLabel.create("Stroke: ");
            PanLabel t1StrokeLabel2 = PanLabel.create("Style: ");
            PanLabel t2StrokeLabel2 = PanLabel.create(" ");
            PanLabel t2StrokeLabel3 = PanLabel.create("Color: ");
            PanLabel t2StrokeLabel4 = PanLabel.create(", Weight: ");
            PanLabel t2StrokeLabel5 = PanLabel.create("%");
            this.strokeStyleMenus_[i] = PanEnumComboBox.create(PanParameterKeys.P_TRAJ_STROKE_STYLE[i], PanStrokeStyle.class);
            this.strokeStyleMenus_[i].setSelectedItem(prefs_.getString(PanParameterKeys.P_TRAJ_STROKE_STYLE[i]));
            this.strokeColorCombos_[i] = PanColorComboBox.createRainbow(PanParameterKeys.P_TRAJ_STROKE_COLOR[i]);
            this.strokeColorCombos_[i].setSelectedColor(prefs_.getColor(PanParameterKeys.P_TRAJ_STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i] = PanIntSpinner.createWeightX5(PanParameterKeys.P_TRAJ_STROKE_WEIGHT[i], prefs_.getInt(PanParameterKeys.P_TRAJ_STROKE_WEIGHT[i]), 500);
            strokeStyleBoxes[i] = QuickBox.createLeftBox(t1StrokeLabel1, t1StrokeLabel2, this.strokeStyleMenus_[i]);
            strokeColorBoxes[i] = QuickBox.createLeftBox(t2StrokeLabel2, t2StrokeLabel3, this.strokeColorCombos_[i], t2StrokeLabel4, this.strokeWeightSpinners_[i], t2StrokeLabel5, Box.createHorizontalStrut(12));
            GuiUtils.matchLabelWidths(t1StrokeLabel1, t2StrokeLabel2, t1SymbolLabel1);
            GuiUtils.matchLabelWidths(t1StrokeLabel2, t2StrokeLabel3, t1SymbolLabel2);
        }
        GuiUtils.matchLabelWidths(bgLabel1, t1Label, t2Label);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 11, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 2, 1));
        this.add(Box.createVerticalStrut(8), new FGConstraint(0, 1));
        this.add((Component)bgLabel1, new FGConstraint(0, 2));
        this.add((Component)this.bgColorCombo_, new FGConstraint(1, 2));
        this.add((Component)this.skipNaNsCB_, new FGConstraint(1, 3));
        this.add(Box.createVerticalStrut(8), new FGConstraint(0, 4));
        this.add((Component)t1Label, new FGConstraint(0, 5));
        this.add((Component)symbolBoxes[0], new FGConstraint(1, 5));
        this.add((Component)strokeStyleBoxes[0], new FGConstraint(1, 6));
        this.add((Component)strokeColorBoxes[0], new FGConstraint(1, 7));
        this.add((Component)t2Label, new FGConstraint(0, 8));
        this.add((Component)symbolBoxes[1], new FGConstraint(1, 8));
        this.add((Component)strokeStyleBoxes[1], new FGConstraint(1, 9));
        this.add((Component)strokeColorBoxes[1], new FGConstraint(1, 10));
        this.refreshPrivate();
    }

    private final void attachListeners() {
        this.bgColorCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:feature.background", this.bgColorCombo_.getSelectedColor());
        });
        this.skipNaNsCB_.addItemListener(e -> {
            boolean checked = this.skipNaNsCB_.isSelected();
            prefs_.setBoolean("plot:feature.nanskip", checked);
        });
        int i = 0;
        while (i < 2) {
            int ii = i++;
            this.strokeStyleMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParameterKeys.P_TRAJ_STROKE_STYLE[ii], this.strokeStyleMenus_[ii].getStringValue());
            });
            this.strokeColorCombos_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.refreshing_) {
                    return;
                }
                prefs_.set(PanParameterKeys.P_TRAJ_STROKE_COLOR[ii], this.strokeColorCombos_[ii].getSelectedColor());
            });
            this.strokeWeightSpinners_[ii].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setInt(PanParameterKeys.P_TRAJ_STROKE_WEIGHT[ii], this.strokeWeightSpinners_[ii].getIntValue());
            });
            this.ptSymbolMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParameterKeys.P_FEATURE_SYMBOL_ID[ii], this.ptSymbolMenus_[ii].getStringValue());
            });
            this.ptSymbolSizeMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.setFloat(PanParameterKeys.P_FEATURE_SYMBOL_SIZE[ii], this.ptSymbolSizeMenus_[ii].getValue());
            });
        }
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        for (int i = 0; i < 2; ++i) {
            this.strokeStyleMenus_[i].setSelectedItem(prefs_.getString(PanParameterKeys.P_TRAJ_STROKE_STYLE[i]));
            this.strokeColorCombos_[i].setSelectedColor(prefs_.getColor(PanParameterKeys.P_TRAJ_STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i].setValue(prefs_.getInt(PanParameterKeys.P_TRAJ_STROKE_WEIGHT[i]));
            this.ptSymbolMenus_[i].setSelectedItem(prefs_.getString(PanParameterKeys.P_FEATURE_SYMBOL_ID[i]));
            this.ptSymbolSizeMenus_[i].setValue(prefs_.getFloat(PanParameterKeys.P_FEATURE_SYMBOL_SIZE[i]));
        }
        this.bgColorCombo_.setSelectedColor(prefs_.getColor("plot:feature.background"));
        this.refreshing_ = false;
    }
}

