/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.data.nc.NcFilenameFilter;
import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.sources.PanDnVTreeTablePanel;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.File;
import java.util.List;

public class PanDnVPanelDropTargetAdapter
extends DropTargetAdapter {
    private final PanDnVTreeTablePanel target_;

    public PanDnVPanelDropTargetAdapter(PanDnVTreeTablePanel target) {
        this.target_ = target;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.target_.toggleBorderActive(true);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.target_.toggleBorderActive(true);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.target_.toggleBorderActive(false);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> flist = FileUtils.getTransferredFileList(t);
            if (flist != null) {
                PanSourcesFrame sourcesFrame = PanSourcesFrame.getSharedInstance();
                sourcesFrame.toFront();
                for (File f : flist) {
                    if (!NcFilenameFilter.accept(f)) continue;
                    PanFileUtils.openDataset(f);
                }
            }
            e.dropComplete(true);
        } else {
            e.rejectDrop();
        }
        this.target_.toggleBorderActive(false);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.target_.toggleBorderActive(false);
    }
}

