/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.plaf.GissComboBoxUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public final class PanGuiUtils {
    public static Component gutterGap() {
        return Box.createHorizontalStrut(12);
    }

    public static void setSizeVariant(PanGuiSize size, JComponent jc) {
        jc.setOpaque(false);
        for (Component c : jc.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            PanGuiUtils.setSizeVariant(size, (JComponent)c);
        }
        if (size == PanGuiSize.SMALL) {
            GuiUtils.setSizeSmall(jc);
        } else if (size == PanGuiSize.REGULAR) {
            GuiUtils.setSizeRegular(jc);
        }
    }

    public static void setSizeSmall(JComponent jc) {
        jc.setOpaque(false);
        for (Component c : jc.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            PanGuiUtils.setSizeSmall((JComponent)c);
        }
        GuiUtils.setSizeSmall(jc);
    }

    public static void setSizeRegular(JComponent jc) {
        jc.setOpaque(false);
        for (Component c : jc.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            PanGuiUtils.setSizeRegular((JComponent)c);
        }
    }

    public static void applyComboBoxUI(PanGuiSize size, JComboBox<?> jcb) {
        jcb.setPreferredSize(null);
        if (size == PanGuiSize.SMALL) {
            PanGuiUtils.setSizeSmall(jcb);
        } else if (size == PanGuiSize.REGULAR) {
            PanGuiUtils.setSizeRegular(jcb);
        }
        jcb.setUI(new GissComboBoxUI());
    }

    public static void setMaxWidth(JComponent jc, int width) {
        Dimension dd = jc.getPreferredSize();
        if (dd.width > width) {
            dd.width = width;
            jc.setPreferredSize(dd);
            jc.setMaximumSize(dd);
        }
    }

    public static PanPlotFrame[] getPlotFrames() {
        ArrayList<PanPlotFrame> fList = new ArrayList<PanPlotFrame>(20);
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof PanPlotFrame) || !frame.isVisible()) continue;
            fList.add((PanPlotFrame)frame);
        }
        fList.sort((frame1, frame2) -> frame1.getTitle().compareTo(frame2.getTitle()));
        return fList.toArray(new PanPlotFrame[0]);
    }

    public static PanPlotFrame[] getListOf2DFrames() {
        ArrayList<PanPlotFrame> fList = new ArrayList<PanPlotFrame>(20);
        for (Frame frame : Frame.getFrames()) {
            PanPlotType ptype;
            if (!(frame instanceof PanPlotFrame) && !frame.isVisible() || (ptype = ((PanPlotFrame)frame).getMeta().getType()).isLinePlot()) continue;
            fList.add((PanPlotFrame)frame);
        }
        fList.sort((frame1, frame2) -> frame1.getTitle().compareTo(frame2.getTitle()));
        return fList.toArray(new PanPlotFrame[0]);
    }

    public static int countVisibleFrames() {
        int count = 0;
        for (Frame f : Frame.getFrames()) {
            if (!(f instanceof PanPlotFrame) || !f.isVisible()) continue;
            ++count;
        }
        return count;
    }

    private PanGuiUtils() {
    }
}

