/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import java.util.Collection;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class PanActionHash
extends Hashtable<String, Action> {
    private final EventListenerList listenerList_ = new EventListenerList();

    public PanActionHash() {
    }

    public PanActionHash(int capacity) {
        super(capacity);
    }

    public void enable(String key, boolean enabled) {
        Action a = (Action)this.get(key);
        if (a != null) {
            a.setEnabled(enabled);
            this.fireChange();
        }
    }

    public void disableAll() {
        Collection actions = this.values();
        for (Action a : actions) {
            a.setEnabled(false);
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        PanActionHash panActionHash = this;
        synchronized (panActionHash) {
            this.listenerList_.add(ChangeListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        PanActionHash panActionHash = this;
        synchronized (panActionHash) {
            this.listenerList_.remove(ChangeListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListeners() {
        PanActionHash panActionHash = this;
        synchronized (panActionHash) {
            for (ChangeListener listener : (ChangeListener[])this.listenerList_.getListeners(ChangeListener.class)) {
                this.removeChangeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        PanActionHash panActionHash = this;
        synchronized (panActionHash) {
            for (ChangeListener listener : (ChangeListener[])this.listenerList_.getListeners(ChangeListener.class)) {
                listener.stateChanged(e);
            }
        }
    }
}

