/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanContourStyle implements DescribedItem
{
    NONE("None"),
    SOLID("Solid"),
    DOTNEG("Dotted Negative"),
    DOTMINOR("Dotted Minor"),
    DOTS("Dotted");

    private final String description_;

    private PanContourStyle(String description) {
        this.description_ = description;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanContourStyle matching(String s) {
        for (PanContourStyle item : PanContourStyle.values()) {
            if (!item.matches(s)) continue;
            return item;
        }
        return null;
    }
}

