/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.data.nc.NcConfig;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.panoply.authentication.PanAuthenticationManager;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.util.PlatformUtils;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanNetcdfUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static synchronized void initNetcdf(Hashtable<Key, Object> opts) {
        LOGGER.trace("Customizing NC settings");
        if (opts.containsKey((Object)Key.DEVO_MODE) && ((Boolean)opts.get((Object)Key.DEVO_MODE)).booleanValue()) {
            NcConfig.setDevoMode();
        }
        boolean serverMode = opts.containsKey((Object)Key.SERVER_MODE) && (Boolean)opts.get((Object)Key.SERVER_MODE) != false;
        boolean headless = opts.containsKey((Object)Key.HEADLESS) && (Boolean)opts.get((Object)Key.HEADLESS) != false || PlatformUtils.isHeadless();
        boolean isDesktop = !serverMode && !headless;
        PanAuthenticationManager pam = isDesktop ? new PanAuthenticationManager() : null;
        NcConfig.initHttpClient(PanUtils.getUserAgent(), pam);
        try {
            NcConfig.initCache("Panoply", "gov.nasa.giss.Panoply");
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to access cache directory.");
            LOGGER.debug("There could be errors if you are working with GRIB data or remote");
            LOGGER.debug("data and your process does not have write access to disk.");
        }
        boolean gribStrict = true;
        if (opts.containsKey((Object)Key.GRIB_STRICT)) {
            gribStrict = (Boolean)opts.get((Object)Key.GRIB_STRICT);
        } else {
            PanPreferences prefs = PanPreferences.getSharedInstance();
            gribStrict = prefs.getBoolean("files:grib.strict");
        }
        try {
            NcConfig.initGribHandling(gribStrict);
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to initialize GRIB handling.");
            LOGGER.debug("There could be errors if you are working with GRIB data and your");
            LOGGER.debug("process does not have write access to disk.");
        }
        if (isDesktop) {
            try {
                NcConfig.readNj22Config();
            }
            catch (Exception exc) {
                LOGGER.warn("Unable to read nj22config file.");
            }
        }
        if (isDesktop) {
            PanNetcdfUtils.updateAltUnits();
        }
    }

    public static void updateAltUnits() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        NcUnitUtils.setAltEnabled(true);
        if (prefs.getBoolean("units:c_is_celsius")) {
            NcUnitUtils.addAlternative("C", "celsius");
        } else {
            NcUnitUtils.removeAlternative("C");
        }
        if (prefs.getBoolean("units:mb_is_millibar")) {
            NcUnitUtils.addAlternative("mb", "millibar");
        } else {
            NcUnitUtils.removeAlternative("mb");
        }
        if (prefs.getBoolean("units:fraction_is_percent")) {
            NcUnitUtils.addAlternative("fraction", "percent");
        } else {
            NcUnitUtils.removeAlternative("fraction");
        }
    }

    private PanNetcdfUtils() {
    }

    public static enum Key {
        DEVO_MODE("DevoMode"),
        HEADLESS("Headless"),
        SERVER_MODE("ServerMode"),
        GRIB_STRICT("GribStrict");


        private Key(String value) {
        }
    }
}

