/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanPlotHeight implements DescribedItem
{
    HEIGHT_025(25, "Height 25%", "height-025"),
    HEIGHT_050(50, "Height 50%", "height-050"),
    HEIGHT_075(75, "Height 75%", "height-075"),
    HEIGHT_100(100, "Height 100%", "height-100"),
    HEIGHT_150(150, "Height 150%", "height-150"),
    HEIGHT_200(200, "Height 200%", "height-200");

    private int ratio_;
    private String description_;
    private String actionID_;

    private PanPlotHeight(int ratio, String description, String actionID) {
        this.ratio_ = ratio;
        this.description_ = description;
        this.actionID_ = actionID;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public int getHeightFactor() {
        return this.ratio_;
    }

    public String getActionID() {
        return this.actionID_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text) || this.actionID_ != null && this.actionID_.equalsIgnoreCase(text);
    }

    public static PanPlotHeight matching(String s) {
        for (PanPlotHeight item : PanPlotHeight.values()) {
            if (!item.matches(s)) continue;
            return item;
        }
        return null;
    }

    public static PanPlotHeight matching(int hratio) {
        for (PanPlotHeight item : PanPlotHeight.values()) {
            if (item.getHeightFactor() != hratio) continue;
            return item;
        }
        return null;
    }
}

