/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanPlotOutputFormat implements DescribedItem
{
    GIF(new String[]{"GIF"}),
    JPEG(new String[]{"JPEG", "JPG"}),
    PDF(new String[]{"PDF"}),
    PNG(new String[]{"PNG"}),
    PS(new String[]{"PS"}),
    TIFF(new String[]{"TIFF", "TIF"});

    private String[] extensions_;

    private PanPlotOutputFormat(String[] extensions) {
        this.extensions_ = extensions;
    }

    @Override
    public String getDescription() {
        return this.name();
    }

    public String toString() {
        return this.name();
    }

    @Override
    public boolean matches(String text) {
        for (int i = 0; i < this.extensions_.length; ++i) {
            if (!this.extensions_[i].equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public static PanPlotOutputFormat matching(String text) {
        for (PanPlotOutputFormat value : PanPlotOutputFormat.values()) {
            if (!value.matches(text)) continue;
            return value;
        }
        return null;
    }
}

