/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import java.lang.invoke.MethodHandles;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static String getMinusSign() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        return Character.toString(symbols.getMinusSign());
    }

    public static String getDecimalSeparator() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        return Character.toString(symbols.getDecimalSeparator());
    }

    public static String getGroupSeparator() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        return Character.toString(symbols.getGroupingSeparator());
    }

    public static String convertUnicode(String s) throws ParseException {
        if (s.indexOf("\\u") < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int sint = 0;
        int slength = s.length();
        while (sint < slength) {
            int uint = s.indexOf("\\u", sint);
            if (uint < 0) {
                sb.append(s.substring(sint));
                break;
            }
            int xint = uint + 2;
            int zint = xint + 4;
            if (zint > slength) {
                sb.append(s.substring(sint));
                break;
            }
            try {
                String s1 = s.substring(sint, uint);
                String s2 = s.substring(xint, zint);
                char uu = (char)Integer.parseInt(s2, 16);
                sb.append(s1).append(uu);
                sint = zint;
            }
            catch (Exception exc) {
                throw new ParseException(s, uint);
            }
        }
        return sb.toString();
    }

    public static float parseFloat(String fs) throws NumberFormatException {
        return (float)StringUtils.parseDouble(fs);
    }

    public static double parseDouble(String d) throws NumberFormatException {
        String groupSep = StringUtils.getGroupSeparator();
        String dd = d.replaceAll("\\s", "");
        String ddd = dd.replaceAll("\\" + groupSep, "");
        if (ddd.length() == 0) {
            throw new NumberFormatException("String does not look like a numeric text value");
        }
        LOGGER.trace("Trying to parse {} : {} : {}", d, dd, ddd);
        int eindex = ddd.toLowerCase().indexOf(101);
        if (eindex > -1) {
            int eindex0 = eindex++;
            if (eindex == 1 || eindex == ddd.length()) {
                throw new NumberFormatException("E notation in unexpected place.");
            }
            if (ddd.substring(eindex, eindex + 1).equals("+")) {
                ++eindex;
            }
            if (eindex == ddd.length()) {
                throw new NumberFormatException("E notation in unexpected place.");
            }
            LOGGER.trace("Trying to parse as exponential");
            double exponent = 0.0;
            try {
                exponent = Integer.parseInt(ddd.substring(eindex));
            }
            catch (Exception exc) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Integer failed to exponent {}", (Object)ddd.substring(eindex));
                    exc.printStackTrace();
                }
                throw new NumberFormatException("Could not parse apparent exponent " + d + " : " + ddd);
            }
            double base = StringUtils.parseDouble(ddd.substring(0, eindex0));
            double result = base * Math.pow(10.0, exponent);
            LOGGER.trace("Exponential result is {}", (Object)result);
            return result;
        }
        try {
            LOGGER.trace("Trying to parse with NumberFormat");
            NumberFormat nfi = NumberFormat.getNumberInstance();
            double result = nfi.parse(dd).doubleValue();
            LOGGER.trace("NumberFormat result is {}", (Object)result);
            return result;
        }
        catch (Exception nfi) {
            try {
                LOGGER.trace("Trying to parse with Double");
                double result = Double.parseDouble(ddd);
                LOGGER.trace("Double result is ", (Object)result);
                return result;
            }
            catch (Exception exception) {
                throw new NumberFormatException("String does not look like a numeric text value");
            }
        }
    }

    public static String escapeHtmlSimplistic(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return StringUtils.escapeHtmlSimplistic(new StringBuilder(s));
    }

    public static String escapeHtmlSimplistic(StringBuilder sb) {
        if (sb == null) {
            return null;
        }
        int isize = sb.length();
        if (isize == 0) {
            return "";
        }
        block8: for (int i = isize - 1; i >= 0; --i) {
            char c = sb.charAt(i);
            switch (c) {
                case '&': {
                    sb.replace(i, i + 1, "&amp;");
                    continue block8;
                }
                case '<': {
                    sb.replace(i, i + 1, "&lt;");
                    continue block8;
                }
                case '>': {
                    sb.replace(i, i + 1, "&gt;");
                    continue block8;
                }
                case '\"': {
                    sb.replace(i, i + 1, "&quot;");
                    continue block8;
                }
                case '\'': {
                    sb.replace(i, i + 1, "&#39;");
                    continue block8;
                }
                case '/': {
                    sb.replace(i, i + 1, "&#47;");
                    continue block8;
                }
            }
        }
        return sb.toString();
    }

    private StringUtils() {
    }
}

