/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.util.DescribedItem;
import javax.swing.JComboBox;

public class EnumComboBox
extends JComboBox<DescribedItem> {
    public EnumComboBox(Class<DescribedItem> ee) {
        if (!ee.isEnum()) {
            throw new IllegalArgumentException("Not an enum");
        }
        for (DescribedItem o : ee.getEnumConstants()) {
            this.addItem(o);
        }
    }

    public String getStringValue() {
        int idx = this.getSelectedIndex();
        DescribedItem item = (DescribedItem)this.getItemAt(idx);
        return item.name();
    }

    public void setSelectedItem(String s) {
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            DescribedItem ditem = (DescribedItem)this.getItemAt(i);
            if (!ditem.matches(s)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }
}

