/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private Color color_;
    private int size_;

    public ColorIcon(Color color, int size) {
        this.color_ = color;
        this.size_ = size;
    }

    @Override
    public int getIconHeight() {
        return this.size_;
    }

    @Override
    public int getIconWidth() {
        return this.size_;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        GuiUtils.updateGraphicsIfDisabled(g2d, c);
        g2d.setColor(g.getColor());
        g2d.fillRect(x - 1, y - 1, this.size_ + 2, this.size_ + 2);
        g2d.setColor(this.color_);
        g2d.fillRect(x, y, this.size_, this.size_);
        g2d.dispose();
    }
}

