/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.MouseInputAdapter;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class RgbSliderPanel
extends AbstractColorChooserPanel {
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final Color SHADOW = new Color(51, 51, 51);
    private static final Color HIGHLIGHT = new Color(153, 153, 153);
    private static ImageIcon tickIcon_;
    private static Image tickImage_;
    private static int tickIconWidth_;
    private RgbTextField rField_;
    private RgbTextField gField_;
    private RgbTextField bField_;

    public RgbSliderPanel() {
        this.setOpaque(false);
        if (tickIcon_ == null) {
            tickIcon_ = new ImageIcon(RgbSliderPanel.class.getResource("resources/slidertick.png"));
            tickImage_ = tickIcon_.getImage();
        }
        JLabel rLabel = new JLabel("R", 4);
        JLabel gLabel = new JLabel("G", 4);
        JLabel bLabel = new JLabel("B", 4);
        rLabel.setFont(rLabel.getFont().deriveFont((float)((double)rLabel.getFont().getSize() - 3.0)));
        gLabel.setFont(rLabel.getFont());
        bLabel.setFont(rLabel.getFont());
        this.rField_ = new RgbTextField(0);
        this.gField_ = new RgbTextField(1);
        this.bField_ = new RgbTextField(2);
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(8, 5), 2, 12);
        fgl.setColumnWeight(0, 9999.0f);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setColumnWeight(7, 9999.0f);
        fgl.setRowWeight(0, 9999.0f);
        fgl.setRowWeight(4, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)new ColorBox(), new Rectangle(1, 1, 1, 3));
        this.add((Component)rLabel, new Rectangle(3, 1, 1, 1));
        this.add((Component)gLabel, new Rectangle(3, 2, 1, 1));
        this.add((Component)bLabel, new Rectangle(3, 3, 1, 1));
        this.add((Component)new Slider(0), new FGConstraint(new Rectangle(4, 1, 1, 1), 0.5, 0.5));
        this.add((Component)new Slider(1), new FGConstraint(new Rectangle(4, 2, 1, 1), 0.5, 0.5));
        this.add((Component)new Slider(2), new FGConstraint(new Rectangle(4, 3, 1, 1), 0.5, 0.5));
        this.add((Component)this.rField_, new FGConstraint(new Rectangle(5, 1, 1, 1), 0.5, 0.5));
        this.add((Component)this.gField_, new FGConstraint(new Rectangle(5, 2, 1, 1), 0.5, 0.5));
        this.add((Component)this.bField_, new FGConstraint(new Rectangle(5, 3, 1, 1), 0.5, 0.5));
        this.add(Box.createGlue(), new Rectangle(0, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(2, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(7, 4, 1, 1));
    }

    public Color getColor() {
        return this.getColorSelectionModel().getSelectedColor();
    }

    public void setColor(Color c) {
        this.getColorSelectionModel().setSelectedColor(c);
        this.rField_.refresh();
        this.gField_.refresh();
        this.bField_.refresh();
        this.repaint();
    }

    private void setRgb(int which, int value) {
        Color c = this.getColorSelectionModel().getSelectedColor();
        try {
            if (which == 0) {
                c = new Color(value, c.getGreen(), c.getBlue());
            } else if (which == 1) {
                c = new Color(c.getRed(), value, c.getBlue());
            } else if (which == 2) {
                c = new Color(c.getRed(), c.getGreen(), value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setColor(c);
    }

    @Override
    public void buildChooser() {
    }

    @Override
    public void updateChooser() {
        this.rField_.refresh();
        this.gField_.refresh();
        this.bField_.refresh();
        this.repaint();
    }

    @Override
    public String getDisplayName() {
        return "RGB";
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    private class Slider
    extends JComponent {
        private int whichRgb_;
        private MouseInputAdapter mouseListener_;
        private int barWidth_ = 128;
        private int barHeight_ = 5;
        private int barLeft_;
        private int barTop_;
        private int barBottom_;
        private int pad_ = 6;
        private int tickWidth2_;
        private int tickHeight2_;

        Slider(int which) {
            this.whichRgb_ = which;
            this.setOpaque(false);
            if (tickIconWidth_ == 0) {
                tickIconWidth_ = tickIcon_.getIconWidth();
            }
            Dimension size = new Dimension(this.barWidth_ + 2 * (this.pad_ + 1), this.barHeight_ + 8);
            this.setPreferredSize(size);
            this.mouseListener_ = new SliderMouseHandler();
            this.addMouseListener(this.mouseListener_);
            this.addMouseMotionListener(this.mouseListener_);
        }

        @Override
        public void paintComponent(Graphics g) {
            int h = this.getHeight();
            int w = this.getWidth();
            this.barHeight_ = h / 3;
            this.tickHeight2_ = 12;
            this.tickWidth2_ = 12;
            this.barWidth_ = w - 2 * (this.pad_ + 1);
            this.barLeft_ = this.pad_ + 1;
            this.barTop_ = (h - 16) / 2 + this.barHeight_;
            this.barBottom_ = this.barTop_ + this.barHeight_ + 1;
            g.setColor(SHADOW);
            g.drawLine(this.pad_ + 0, this.barTop_, this.pad_ + 1 + this.barWidth_, this.barTop_);
            g.drawLine(this.pad_ + 0, this.barTop_, this.pad_ + 0, this.barBottom_);
            g.setColor(HIGHLIGHT);
            g.drawLine(this.pad_ + 1, this.barBottom_, this.pad_ + 1 + this.barWidth_, this.barBottom_);
            g.drawLine(this.pad_ + 1 + this.barWidth_, this.barTop_ + 1, this.pad_ + 1 + this.barWidth_, this.barBottom_);
            Color c = RgbSliderPanel.this.getColorSelectionModel().getSelectedColor();
            for (int i = 0; i < this.barWidth_; ++i) {
                int ii = (int)(255.0 * (double)i / (double)this.barWidth_);
                if (this.whichRgb_ == 0) {
                    g.setColor(new Color(ii, c.getGreen(), c.getBlue()));
                } else if (this.whichRgb_ == 1) {
                    g.setColor(new Color(c.getRed(), ii, c.getBlue()));
                } else if (this.whichRgb_ == 2) {
                    g.setColor(new Color(c.getRed(), c.getGreen(), ii));
                }
                g.drawLine(this.pad_ + 1 + i, this.barTop_ + 1, this.pad_ + 1 + i, this.barTop_ + this.barHeight_);
            }
            g.drawImage(tickImage_, this.pad_ + 1 + this.getTickX() - this.tickWidth2_ / 2, (this.barTop_ + this.barBottom_ - this.tickHeight2_) / 2, this.tickWidth2_, this.tickHeight2_, new Color(0, 0, 0, 0), RgbSliderPanel.this);
        }

        private int getTickX() {
            Color c = RgbSliderPanel.this.getColorSelectionModel().getSelectedColor();
            if (this.whichRgb_ == 0) {
                return (int)((double)this.barWidth_ * (double)c.getRed() / 255.0);
            }
            if (this.whichRgb_ == 1) {
                return (int)((double)this.barWidth_ * (double)c.getGreen() / 255.0);
            }
            if (this.whichRgb_ == 2) {
                return (int)((double)this.barWidth_ * (double)c.getBlue() / 255.0);
            }
            return 0;
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        private class SliderMouseHandler
        extends MouseInputAdapter {
            boolean dragInProgress;

            SliderMouseHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int tick = Slider.this.getTickX();
                int x = e.getX() - Slider.this.pad_;
                if (x < tick - Slider.this.tickWidth2_ / 2 || x > tick + Slider.this.tickWidth2_ / 2 || x < 0 || x > Slider.this.barWidth_) {
                    return;
                }
                this.handleMouse(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseClicked(e);
                this.dragInProgress = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!this.dragInProgress) {
                    return;
                }
                this.handleMouse(e);
                this.dragInProgress = false;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!this.dragInProgress) {
                    return;
                }
                this.handleMouse(e);
            }

            public void handleMouse(MouseEvent e) {
                int x = e.getX() - Slider.this.pad_ - 1;
                int value = (int)(255.0 * (double)x / (double)Slider.this.barWidth_);
                RgbSliderPanel.this.setRgb(Slider.this.whichRgb_, value);
            }
        }
    }

    private class RgbTextField
    extends JTextField {
        private int whichRgb_;

        RgbTextField(int which) {
            super(4);
            this.setFont(this.getFont().deriveFont((float)((double)this.getFont().getSize() - 2.0)));
            this.whichRgb_ = which;
            this.setText("255");
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    RgbTextField.this.respond();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.addActionListener(e -> this.respond());
        }

        private void refresh() {
            ColorSelectionModel csm = RgbSliderPanel.this.getColorSelectionModel();
            if (csm == null) {
                return;
            }
            Color c = csm.getSelectedColor();
            if (this.whichRgb_ == 0) {
                this.setText(Integer.toString(c.getRed()));
            } else if (this.whichRgb_ == 1) {
                this.setText(Integer.toString(c.getGreen()));
            } else if (this.whichRgb_ == 2) {
                this.setText(Integer.toString(c.getBlue()));
            }
        }

        private void respond() {
            try {
                RgbSliderPanel.this.setRgb(this.whichRgb_, Integer.parseInt(this.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refresh();
        }
    }

    private class ColorBox
    extends JComponent {
        ColorBox() {
            Dimension size = new Dimension(34, 34);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
        }

        @Override
        public void paintComponent(Graphics g) {
            int h = this.getHeight();
            int w = this.getWidth();
            int l = (w - 34) / 2;
            int t = (h - 34) / 2;
            g.setColor(SHADOW);
            g.drawLine(l, t, l + 34, t);
            g.drawLine(l, t, l, t + 34);
            g.setColor(HIGHLIGHT);
            g.drawLine(l + 1, t + 34, l + 1 + 32, t + 34);
            g.drawLine(l + 34, t + 1, l + 34, t + 34);
            g.setColor(RgbSliderPanel.this.getColorSelectionModel().getSelectedColor());
            g.fillRect(l + 1, t + 1, 32, 32);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }
    }
}

