/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.plaf.EmphasizedLabelUI;
import gov.nasa.giss.ui.table.TableHeaderTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;

public class ColumnHeaderRenderer
extends JLabel
implements TableCellRenderer {
    private static final String EMPHASIZED_CLASS_ID = "EmphasizedLabelUI";
    private JTable table_;
    private TableHeaderTheme theme_;
    private int[] pressedCols_ = new int[]{-1, -1};
    private int[] selectedCols_ = new int[]{-1, -1};
    private Color topColor_;
    private Color bottomColor_;
    private boolean emphasized_;

    public ColumnHeaderRenderer() {
        this(TableHeaderTheme.getMacosYosemiteTheme());
    }

    public ColumnHeaderRenderer(JTable table) {
        this();
        this.table_ = table;
    }

    public ColumnHeaderRenderer(TableHeaderTheme theme) {
        super("");
        this.setTheme(theme);
        this.setOpaque(false);
    }

    public TableHeaderTheme getTheme() {
        return this.theme_;
    }

    public void setTheme(TableHeaderTheme theme) {
        this.theme_ = theme;
        this.topColor_ = this.theme_.getColor(TableHeaderTheme.ThemeKey.UNSELECTED_TOP_COLOR);
        this.bottomColor_ = this.theme_.getColor(TableHeaderTheme.ThemeKey.UNSELECTED_BOTTOM_COLOR);
        int fstyle = this.theme_.getInt(TableHeaderTheme.ThemeKey.FONT_STYLE);
        this.setFont(UIManager.getFont("TableHeader.font").deriveFont(fstyle));
        this.emphasized_ = this.theme_.getBoolean(TableHeaderTheme.ThemeKey.FONT_EMPHASIZED);
    }

    @Override
    public void updateUI() {
        if (this.emphasized_) {
            if (UIManager.get(this.getUIClassID()) != null) {
                this.setUI((EmphasizedLabelUI)UIManager.getUI(this));
            } else {
                this.setUI(EmphasizedLabelUI.createUI(this));
            }
        } else {
            super.updateUI();
        }
    }

    @Override
    public String getUIClassID() {
        if (this.emphasized_) {
            return EMPHASIZED_CLASS_ID;
        }
        return super.getUIClassID();
    }

    public void clear() {
        this.pressedCols_[0] = -1;
        this.pressedCols_[1] = -1;
        this.selectedCols_[0] = -1;
        this.selectedCols_[1] = -1;
    }

    public void setPressedColumns(int col0, int col1) {
        this.pressedCols_[0] = col0;
        this.pressedCols_[1] = col1;
        this.selectedCols_[0] = -1;
        this.selectedCols_[1] = -1;
    }

    public int[] getSelectedColumns() {
        return this.selectedCols_;
    }

    public void setSelectedColumns(int col0, int col1) {
        this.selectedCols_[0] = col0;
        this.selectedCols_[1] = col1;
        this.pressedCols_[0] = -1;
        this.pressedCols_[1] = -1;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setText(value.toString());
        Window window = SwingUtilities.getWindowAncestor(this.table_);
        if (window == null) {
            return this;
        }
        boolean windowHasFocus = window.isFocused();
        int modelColumn = this.table_.convertColumnIndexToModel(col);
        Color bcolor = this.theme_.getColor(TableHeaderTheme.ThemeKey.BOTTOM_BORDER_COLOR);
        CompoundBorder leftSpacerBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.getLeftBorderColor(modelColumn, windowHasFocus)), BorderFactory.createEmptyBorder(1, 4, 0, 4));
        CompoundBorder bottomRightBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, bcolor), BorderFactory.createMatteBorder(0, 0, 0, 1, this.getRightBorderColor(modelColumn, windowHasFocus)));
        this.setBorder(BorderFactory.createCompoundBorder(bottomRightBorder, leftSpacerBorder));
        this.topColor_ = this.getTopColor(modelColumn, windowHasFocus);
        this.bottomColor_ = this.getBottomColor(modelColumn, windowHasFocus);
        return this;
    }

    private Color getTopColor(int col, boolean windowHasFocus) {
        if (!windowHasFocus) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.UNSELECTED_TOP_COLOR);
        }
        if (this.isSelectedColumn(col) && this.isPressedColumn(col)) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.PRESSED_SELECTED_TOP_COLOR);
        }
        if (this.isSelectedColumn(col)) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.SELECTED_TOP_COLOR);
        }
        if (this.isPressedColumn(col)) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.PRESSED_UNSELECTED_TOP_COLOR);
        }
        return this.theme_.getColor(TableHeaderTheme.ThemeKey.UNSELECTED_TOP_COLOR);
    }

    private Color getBottomColor(int col, boolean windowHasFocus) {
        if (!windowHasFocus) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.UNSELECTED_BOTTOM_COLOR);
        }
        if (this.isSelectedColumn(col) && this.isPressedColumn(col)) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.PRESSED_SELECTED_BOTTOM_COLOR);
        }
        if (this.isSelectedColumn(col)) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.SELECTED_BOTTOM_COLOR);
        }
        if (this.isPressedColumn(col)) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.PRESSED_UNSELECTED_BOTTOM_COLOR);
        }
        return this.theme_.getColor(TableHeaderTheme.ThemeKey.UNSELECTED_BOTTOM_COLOR);
    }

    private Color getLeftBorderColor(int col, boolean windowHasFocus) {
        if (!windowHasFocus) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.LEFT_UNSELECTED_BORDER_COLOR);
        }
        if (this.isSelectedColumn(col) && this.isPressedColumn(col)) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.LEFT_SELECTED_BORDER_COLOR);
        }
        if (this.isSelectedColumn(col)) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.LEFT_SELECTED_BORDER_COLOR);
        }
        if (this.isPressedColumn(col)) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.LEFT_PRESSED_UNSELECTED_BORDER_COLOR);
        }
        return this.theme_.getColor(TableHeaderTheme.ThemeKey.LEFT_UNSELECTED_BORDER_COLOR);
    }

    private Color getRightBorderColor(int col, boolean windowHasFocus) {
        if (windowHasFocus && this.isSelectedColumn(col)) {
            return this.theme_.getColor(TableHeaderTheme.ThemeKey.RIGHT_SELECTED_BORDER_COLOR);
        }
        return this.theme_.getColor(TableHeaderTheme.ThemeKey.RIGHT_UNSELECTED_BORDER_COLOR);
    }

    private boolean isPressedColumn(int col) {
        if (this.pressedCols_[0] == -1 || this.pressedCols_[1] == -1) {
            return false;
        }
        if (this.pressedCols_[1] < this.pressedCols_[0]) {
            return col >= this.pressedCols_[1] & col <= this.pressedCols_[0];
        }
        return col >= this.pressedCols_[0] & col <= this.pressedCols_[1];
    }

    private boolean isSelectedColumn(int col) {
        if (this.selectedCols_[0] == -1 || this.selectedCols_[1] == -1) {
            return false;
        }
        if (this.selectedCols_[1] < this.selectedCols_[0]) {
            return col >= this.selectedCols_[1] & col <= this.selectedCols_[0];
        }
        return col >= this.selectedCols_[0] & col <= this.selectedCols_[1];
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.topColor_, 0.0f, this.getHeight(), this.bottomColor_);
        g2d.setPaint(paint);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.dispose();
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        int padding = this.theme_.getInt(TableHeaderTheme.ThemeKey.TOP_BOTTOM_PADDING);
        Dimension d = super.getPreferredSize();
        d.height += 2 * padding;
        return d;
    }
}

