/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.windoid;

import gov.nasa.giss.ui.windoid.WindoidSectionHeader;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class WindoidSection
extends JPanel {
    private WindoidSectionHeader header_;
    private JComponent content_;
    private boolean expanded_ = true;

    public WindoidSection(String title, JComponent content) {
        this(title, content, true);
    }

    public WindoidSection(String title, JComponent content, boolean expanded) {
        this.content_ = content;
        this.header_ = new WindoidSectionHeader(title);
        this.setBorder(null);
        this.setLayout(null);
        this.add(this.header_);
        this.add(this.content_);
        this.setExpanded(expanded);
        this.header_.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WindoidSection.this.setExpanded(!WindoidSection.this.expanded_);
            }
        });
    }

    public boolean isExpanded() {
        return this.expanded_;
    }

    public void setExpanded(boolean expanded) {
        if (expanded == this.expanded_) {
            return;
        }
        this.expanded_ = expanded;
        this.header_.setExpanded(this.expanded_);
        this.content_.setVisible(this.expanded_);
        this.validate();
        this.invalidate();
        this.repaint();
        this.firePropertyChange("expanded", (Object)(!expanded ? 1 : 0), (Object)expanded);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension hsize = this.header_.getPreferredSize();
        if (this.expanded_) {
            Dimension cpref = this.content_.getPreferredSize();
            int minw = Math.max(cpref.width, hsize.width);
            return new Dimension(minw, hsize.height + cpref.height);
        }
        return new Dimension(hsize.width, hsize.height + 2);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 4000;
        return d;
    }

    @Override
    public void doLayout() {
        this.header_.setBounds(0, 0, this.getSize().width, this.header_.getPreferredSize().height);
        this.content_.setBounds(0, this.header_.getPreferredSize().height, this.getSize().width, this.content_.getPreferredSize().height);
        super.doLayout();
    }
}

