/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import gov.nasa.giss.text.PrintfFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final PrintfFormat PFORMAT = new PrintfFormat("%06d");

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        String sqstr = PFORMAT.sprintf((Object)record.getSequenceNumber());
        String cname = record.getSourceClassName();
        cname = cname.replaceAll(".*\\.", "");
        cname = cname.replaceAll(".*\\$", "");
        sb.append(sqstr).append(' ').append(record.getLevel()).append(": ").append(cname).append(' ').append(record.getSourceMethodName()).append(" - ").append(record.getMessage()).append('\n');
        return sb.toString();
    }
}

