/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.ui;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.schmunk.gfx.filter.DarkFilter;

public class PlusMinus
extends JPanel {
    private Object lock_ = new Object();
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int PLUS = 2000;
    public static final int MINUS = 2001;
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);
    private static ImageIcon plusIcon_;
    private static ImageIcon minusIcon_;
    private Action plusAction_;
    private Action minusAction_;
    private boolean plusEnabled_;
    private boolean minusEnabled_;

    public PlusMinus() {
        this(0, null);
    }

    public PlusMinus(int axis, String name) {
        this.setLayout(new BoxLayout(this, axis));
        this.setOpaque(false);
        this.setName(name);
        if (plusIcon_ == null) {
            plusIcon_ = new ImageIcon(PlusMinus.class.getResource("resources/plusbutton.png"));
            minusIcon_ = new ImageIcon(PlusMinus.class.getResource("resources/minusbutton.png"));
        }
        this.plusAction_ = new PlusAction();
        this.minusAction_ = new MinusAction();
        WidgetButton plusButton = new WidgetButton(this.plusAction_, plusIcon_);
        WidgetButton minusButton = new WidgetButton(this.minusAction_, minusIcon_);
        if (axis == 1) {
            this.add(Box.createVerticalGlue());
            this.add(plusButton);
            this.add(minusButton);
            this.add(Box.createVerticalGlue());
        } else {
            this.add(Box.createHorizontalGlue());
            this.add(plusButton);
            this.add(minusButton);
            this.add(Box.createHorizontalGlue());
        }
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.plusAction_.setEnabled(this.plusEnabled_);
            this.plusAction_.setEnabled(this.minusEnabled_);
        } else {
            this.plusAction_.setEnabled(false);
            this.plusAction_.setEnabled(false);
        }
    }

    public boolean isIconEnabled(int iconID) {
        if (iconID != 2000 && iconID != 2001) {
            throw new IllegalArgumentException("Invalid icon ID.");
        }
        if (iconID == 2000) {
            return this.plusEnabled_;
        }
        if (iconID == 2001) {
            return this.minusEnabled_;
        }
        return false;
    }

    public void setIconEnabled(int iconID, boolean enabled) {
        if (iconID != 2000 && iconID != 2001) {
            throw new IllegalArgumentException("Invalid icon ID.");
        }
        if (iconID == 2000) {
            this.plusEnabled_ = enabled;
            this.plusAction_.setEnabled(this.plusEnabled_);
        } else if (iconID == 2001) {
            this.minusEnabled_ = enabled;
            this.minusAction_.setEnabled(this.minusEnabled_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList.add(ActionListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList.remove(ActionListener.class, l);
        }
    }

    private void fireAction(int iconID) {
        ActionEvent e;
        if (iconID == 2000) {
            e = new ActionEvent(this, 2000, "plus");
        } else if (iconID == 2001) {
            e = new ActionEvent(this, 2001, "minus");
        } else {
            throw new IllegalArgumentException("Invalid icon ID.");
        }
        ActionListener[] listeners = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].actionPerformed(e);
        }
    }

    private class WidgetButton
    extends JButton {
        private final ImageIcon icon_;

        WidgetButton(Action action, ImageIcon icon) {
            this.icon_ = icon;
            this.setAction(action);
            this.setText(null);
            this.setOpaque(false);
            this.setMargin(NO_MARGIN);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
            this.setDisabledIcon(icon);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Image pImage = tk.createImage(new FilteredImageSource(icon.getImage().getSource(), new DarkFilter(33)));
            ImageIcon pIcon = new ImageIcon(pImage);
            this.setSelectedIcon(pIcon);
            this.setPressedIcon(pIcon);
            Dimension d = new Dimension(icon.getIconWidth() / 2, icon.getIconHeight() / 2);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            if (!this.isEnabled()) {
                g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
            }
            super.paintComponent(g2d);
            g2d.scale(0.5, 0.5);
            this.icon_.paintIcon(PlusMinus.this, g2d, 0, 0);
            g2d.dispose();
        }
    }

    class MinusAction
    extends AbstractAction {
        MinusAction() {
            super("Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlusMinus.this.fireAction(2001);
        }
    }

    class PlusAction
    extends AbstractAction {
        PlusAction() {
            super("Add");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlusMinus.this.fireAction(2000);
        }
    }
}

