/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Iterator;
import org.esa.beam.dataio.geotiff.Utils;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;

public class BeamImporter {
    public static void main(String[] args) {
        if (args.length == 4 || args.length == 5) {
            String of;
            int ix = 0;
            boolean crop = false;
            if (args[ix].compareToIgnoreCase("-crop") == 0) {
                crop = true;
            }
            int n = ++ix;
            ++ix;
            if (args[n].compareToIgnoreCase("-of") != 0) {
                System.out.println("Syntax error: output format specification (-of) missing.");
                BeamImporter.main(new String[0]);
                return;
            }
            if ((of = args[ix++]).toLowerCase().indexOf("beam") >= 0) {
                of = "BEAM-DIMAP";
            } else if (of.toLowerCase().indexOf("ilwis") >= 0) {
                of = "ILWIS";
            } else if (of.toLowerCase().indexOf("tif") >= 0) {
                of = "GeoTIFF";
            } else {
                System.out.println("Syntax error: output format can only be ilwis, tiff or beam");
                BeamImporter.main(new String[0]);
                return;
            }
            String input = args[ix++];
            String output = args[ix++];
            try {
                System.out.println("Reading file: '" + input + "'");
                ProductIO.setDoNotCrop(!crop);
                Product product = ProductIO.readProduct(input);
                if (product != null) {
                    System.out.println("Successfully read file!");
                    String reader = product.getProductReader().getReaderPlugIn().getDescription(null);
                    System.out.println("Reader used: '" + reader + "'");
                    System.out.println("Bands: (bands with an asterisk will not be imported)");
                    Band[] bandArray = product.getBands();
                    int n2 = bandArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Band band = bandArray[n3];
                        System.out.println("  " + band.getName() + (Utils.shouldWriteNode(band) ? "" : " [*]"));
                        ++n3;
                    }
                    System.out.println("Writing file: '" + output + "'");
                    String formatName = of;
                    String writer = ProductIO.getProductWriter(formatName).getWriterPlugIn().getDescription(null);
                    System.out.println("Writer used: '" + writer + "'");
                    ProductIO.writeProduct(product, output, formatName);
                    System.out.println("Successfully written file!");
                } else {
                    System.out.println("None of the configured drivers for reading recognized the input file.");
                    System.out.println("Configured drivers for reading:");
                    ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
                    Iterator<ProductReaderPlugIn> itRead = registry.getAllReaderPlugIns();
                    while (itRead.hasNext()) {
                        ProductReaderPlugIn plugIn = itRead.next();
                        System.out.println("  " + plugIn.getDescription(null));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage: java -jar BeamImporter.jar [-crop] -of <outputformat> <inputfile> <outputfile>");
            System.out.println("  <outputformat> can be ilwis, tiff or beam");
            System.out.println("Configured drivers for reading:");
            ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
            Iterator<ProductReaderPlugIn> itRead = registry.getAllReaderPlugIns();
            while (itRead.hasNext()) {
                ProductReaderPlugIn plugIn = itRead.next();
                System.out.println("  " + plugIn.getDescription(null));
            }
            System.out.println("Configured drivers for writing:");
            Iterator<ProductWriterPlugIn> itWrite = registry.getAllWriterPlugIns();
            while (itWrite.hasNext()) {
                ProductWriterPlugIn plugIn = itWrite.next();
                System.out.println("  " + plugIn.getDescription(null));
            }
        }
    }
}

