/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

public class ValueRange {
    private final double min;
    private final double max;
    private final boolean minIncluded;
    private final boolean maxIncluded;

    public ValueRange(double min, double max) {
        this(min, max, true, true);
    }

    public ValueRange(double min, double max, boolean minIncluded, boolean maxIncluded) {
        this.min = min;
        this.max = max;
        this.minIncluded = minIncluded;
        this.maxIncluded = maxIncluded;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isMinIncluded() {
        return this.minIncluded;
    }

    public boolean isMaxIncluded() {
        return this.maxIncluded;
    }

    public boolean hasMin() {
        return this.min > Double.NEGATIVE_INFINITY;
    }

    public boolean hasMax() {
        return this.max < Double.POSITIVE_INFINITY;
    }

    public boolean contains(double v) {
        boolean b2;
        boolean b1;
        boolean bl = this.minIncluded ? v >= this.min : (b1 = v > this.min);
        boolean bl2 = this.maxIncluded ? v <= this.max : (b2 = v < this.max);
        return b1 && b2;
    }

    public static ValueRange parseValueRange(String text) throws IllegalArgumentException {
        if (text.length() > 0) {
            char c1 = text.charAt(0);
            if (c1 == '(' || c1 == '[') {
                char c2 = text.charAt(text.length() - 1);
                if (c2 == ')' || c2 == ']') {
                    int d = text.indexOf(44, 1);
                    if (d > 1 && d < text.length() - 2) {
                        String s1 = text.substring(1, d).trim();
                        String s2 = text.substring(d + 1, text.length() - 1).trim();
                        try {
                            return new ValueRange(s1.equals("*") ? Double.NEGATIVE_INFINITY : Double.valueOf(ValueRange.trimNumberString(s1)), s2.equals("*") ? Double.POSITIVE_INFINITY : Double.valueOf(ValueRange.trimNumberString(s2)), c1 == '[', c2 == ']');
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("Invalid number format in interval.");
                        }
                    }
                    throw new IllegalArgumentException("Missing ',' in interval.");
                }
                throw new IllegalArgumentException("Missing trailing ')' or ']' in interval.");
            }
            throw new IllegalArgumentException("Missing leading '(' or '[' in interval.");
        }
        throw new IllegalArgumentException("Empty string.");
    }

    private static String trimNumberString(String s) {
        if ((s = s.trim()).startsWith("+")) {
            s = s.substring(1);
        }
        return s;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.minIncluded ? (char)'[' : '(');
        sb.append(this.hasMin() ? ValueRange.toString(this.min) : "*");
        sb.append(',');
        sb.append(this.hasMax() ? ValueRange.toString(this.max) : "*");
        sb.append(this.maxIncluded ? (char)']' : ')');
        return sb.toString();
    }

    private static String toString(double d) {
        long l = Math.round(d);
        return d == (double)l ? Long.toString(l) : Double.toString(d);
    }
}

