/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ExtensibleObject;
import com.bc.ceres.glayer.Composite;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.grender.Rendering;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Layer
extends ExtensibleObject {
    private static volatile AtomicInteger instanceCount = new AtomicInteger(0);
    private final LayerType layerType;
    private Layer parent;
    private final LayerList children;
    private String id;
    private String name;
    private boolean visible;
    private double transparency;
    private Composite composite;
    private final transient ArrayList<LayerListener> layerListenerList;
    private final transient ConfigurationPCL configurationPCL;
    private final PropertySet configuration;

    protected Layer(LayerType layerType) {
        this(layerType, new PropertyContainer());
    }

    protected Layer(LayerType layerType, PropertySet configuration) {
        this.configuration = configuration;
        Assert.notNull(layerType, "layerType");
        this.layerType = layerType;
        this.name = Layer.createDefaultName(layerType);
        this.parent = null;
        this.id = Long.toHexString(System.nanoTime() + (long)instanceCount.incrementAndGet());
        this.children = new LayerList();
        this.visible = true;
        this.transparency = 0.0;
        this.composite = Composite.SRC_OVER;
        this.layerListenerList = new ArrayList(8);
        this.configurationPCL = new ConfigurationPCL();
        configuration.addPropertyChangeListener(this.configurationPCL);
    }

    public LayerType getLayerType() {
        return this.layerType;
    }

    public PropertySet getConfiguration() {
        return this.configuration;
    }

    public Layer getParent() {
        return this.parent;
    }

    public boolean isCollectionLayer() {
        return false;
    }

    public List<Layer> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Assert.notNull(name, "name");
        String oldValue = this.name;
        if (!oldValue.equals(name)) {
            this.name = name;
            this.fireLayerPropertyChanged("name", oldValue, this.name);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Assert.notNull(id, "id");
        this.id = id;
    }

    public int getChildIndex(String id) {
        Assert.notNull(id, "id");
        int i = 0;
        while (i < this.children.size()) {
            Layer child = this.children.get(i);
            if (id.equals(child.getId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        if (oldValue != visible) {
            this.visible = visible;
            this.fireLayerPropertyChanged("visible", oldValue, this.visible);
        }
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double transparency) {
        double oldValue = this.transparency;
        if (oldValue != transparency) {
            this.transparency = transparency;
            this.fireLayerPropertyChanged("transparency", oldValue, this.transparency);
        }
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        Composite oldValue = this.composite;
        if (oldValue != composite) {
            this.composite = composite;
            this.fireLayerPropertyChanged("composite", (Object)oldValue, (Object)this.composite);
        }
    }

    protected final <T> T getConfigurationProperty(String propertyName, T defaultValue) {
        Object value = defaultValue;
        PropertySet configuration = this.getConfiguration();
        Property model = configuration.getProperty(propertyName);
        if (model != null) {
            Class<?> descriptorType;
            Class<?> expectedType = defaultValue.getClass();
            if (expectedType.isAssignableFrom(descriptorType = model.getDescriptor().getType())) {
                if (model.getValue() != null) {
                    value = model.getValue();
                } else if (model.getDescriptor().getDefaultValue() != null) {
                    value = model.getDescriptor().getDefaultValue();
                }
            } else {
                throw new IllegalArgumentException(MessageFormat.format("Class ''{0}'' is not assignable from class ''{1}''.", expectedType, descriptorType));
            }
        }
        return value;
    }

    public final Rectangle2D getModelBounds() {
        Rectangle2D layerBounds = this.getLayerModelBounds();
        Rectangle2D childrenBounds = this.getChildrenModelBounds();
        if (layerBounds == null) {
            return childrenBounds;
        }
        if (childrenBounds == null) {
            return layerBounds;
        }
        Rectangle2D bounds = (Rectangle2D)layerBounds.clone();
        bounds.add(childrenBounds);
        return bounds;
    }

    protected Rectangle2D getLayerModelBounds() {
        return null;
    }

    protected Rectangle2D getChildrenModelBounds() {
        Rectangle2D bounds = null;
        for (Layer layer : this.children) {
            Rectangle2D childBounds = layer.getModelBounds();
            if (childBounds == null) continue;
            if (bounds == null) {
                bounds = (Rectangle2D)childBounds.clone();
                continue;
            }
            bounds.add(childBounds);
        }
        return bounds;
    }

    public final void render(Rendering rendering) {
        this.render(rendering, null);
    }

    public final void render(Rendering rendering, LayerFilter filter) {
        double transparency = this.getTransparency();
        if (!this.isVisible() || transparency == 1.0) {
            return;
        }
        Graphics2D g = rendering.getGraphics();
        java.awt.Composite oldComposite = null;
        try {
            if (transparency > 0.0) {
                oldComposite = g.getComposite();
                g.setComposite(this.getComposite().getAlphaComposite((float)(1.0 - transparency)));
            }
            if (filter == null) {
                this.renderLayer(rendering);
                this.renderChildren(rendering, null);
            } else {
                if (filter.accept(this)) {
                    this.renderLayer(rendering);
                }
                this.renderChildren(rendering, filter);
            }
        }
        finally {
            if (oldComposite != null) {
                g.setComposite(oldComposite);
            }
        }
    }

    protected void renderLayer(Rendering rendering) {
    }

    protected void renderChildren(Rendering rendering, LayerFilter filter) {
        int i = this.children.size() - 1;
        while (i >= 0) {
            this.children.get(i).render(rendering, filter);
            --i;
        }
    }

    public final void dispose() {
        this.configuration.removePropertyChangeListener(this.configurationPCL);
        this.layerListenerList.clear();
        this.disposeChildren();
        this.disposeLayer();
    }

    protected void disposeLayer() {
    }

    protected void disposeChildren() {
        this.children.dispose();
    }

    public void addListener(LayerListener listener) {
        Assert.notNull(listener, "listener");
        if (!this.layerListenerList.contains(listener)) {
            this.layerListenerList.add(listener);
        }
    }

    public void removeListener(LayerListener listener) {
        this.layerListenerList.remove(listener);
    }

    public LayerListener[] getListeners() {
        return this.layerListenerList.toArray(new LayerListener[this.layerListenerList.size()]);
    }

    LayerListener[] getReachableListeners() {
        ArrayList<LayerListener> list = new ArrayList<LayerListener>(16);
        list.addAll(Arrays.asList(this.getListeners()));
        Layer currentParent = this.getParent();
        while (currentParent != null) {
            list.addAll(Arrays.asList(currentParent.getListeners()));
            currentParent = currentParent.getParent();
        }
        return list.toArray(new LayerListener[list.size()]);
    }

    protected void fireLayerPropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.fireLayerPropertyChanged(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
    }

    protected void fireLayerPropertyChanged(PropertyChangeEvent event) {
        LayerListener[] layerListenerArray = this.getReachableListeners();
        int n = layerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayerListener listener = layerListenerArray[n2];
            listener.handleLayerPropertyChanged(this, event);
            ++n2;
        }
    }

    protected void fireLayerDataChanged(Rectangle2D modelRegion) {
        LayerListener[] layerListenerArray = this.getReachableListeners();
        int n = layerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayerListener listener = layerListenerArray[n2];
            listener.handleLayerDataChanged(this, modelRegion);
            ++n2;
        }
    }

    protected void fireLayersAdded(Layer[] layers) {
        LayerListener[] layerListenerArray = this.getReachableListeners();
        int n = layerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayerListener listener = layerListenerArray[n2];
            listener.handleLayersAdded(this, layers);
            ++n2;
        }
    }

    protected void fireLayersRemoved(Layer[] layers) {
        LayerListener[] layerListenerArray = this.getReachableListeners();
        int n = layerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayerListener listener = layerListenerArray[n2];
            listener.handleLayersRemoved(this, layers);
            ++n2;
        }
    }

    public String toString() {
        return this.getName();
    }

    void setParent(Layer parent) {
        this.parent = parent;
    }

    public void regenerate() {
    }

    private static String createDefaultName(LayerType layerType) {
        String name = layerType.getClass().getSimpleName();
        if (name.endsWith("Type")) {
            return name.substring(0, name.length() - "Type".length());
        }
        return name;
    }

    private class ConfigurationPCL
    implements PropertyChangeListener {
        private ConfigurationPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Layer.this.fireLayerPropertyChanged(event);
        }
    }

    private class LayerList
    extends AbstractList<Layer> {
        private final List<Layer> layerList = new Vector<Layer>(8);

        LayerList() {
        }

        @Override
        public int size() {
            return this.layerList.size();
        }

        @Override
        public Layer get(int i) {
            return this.layerList.get(i);
        }

        @Override
        public Layer set(int i, Layer layer) {
            Layer oldLayer = this.layerList.set(i, layer);
            if (layer != oldLayer) {
                oldLayer.setParent(null);
                layer.setParent(Layer.this);
                Layer.this.fireLayersRemoved(new Layer[]{oldLayer});
                Layer.this.fireLayersAdded(new Layer[]{layer});
            }
            return oldLayer;
        }

        @Override
        public void add(int i, Layer layer) {
            this.layerList.add(i, layer);
            layer.setParent(Layer.this);
            Layer.this.fireLayersAdded(new Layer[]{layer});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            List<Layer> list = this.layerList;
            synchronized (list) {
                int i = this.indexOf(o);
                if (i != -1) {
                    return this.remove(i) == o;
                }
                return false;
            }
        }

        @Override
        public Layer remove(int i) {
            Layer layer = this.layerList.remove(i);
            layer.setParent(null);
            Layer.this.fireLayersRemoved(new Layer[]{layer});
            return layer;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.layerList.toArray(array);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            List<Layer> list = this.layerList;
            synchronized (list) {
                Layer[] layers = this.layerList.toArray(new Layer[this.layerList.size()]);
                this.layerList.clear();
                Layer[] layerArray = layers;
                int n = layers.length;
                int n2 = 0;
                while (n2 < n) {
                    Layer layer = layerArray[n2];
                    layer.dispose();
                    layer.setParent(null);
                    ++n2;
                }
            }
        }
    }
}

