/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.support;

import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.filters.IdFilter;
import com.bc.ceres.glayer.support.filters.NameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LayerUtils {
    public static final SearchMode SEARCH_FLAT = SearchMode.FLAT;
    public static final SearchMode SEARCH_DEEP = SearchMode.DEEP;

    private LayerUtils() {
    }

    public static int getChildLayerIndex(Layer root, SearchMode mode, int defaultIndex, LayerFilter filter) {
        Layer child;
        Assert.notNull(root, "root");
        Assert.notNull(filter, "filter");
        Assert.notNull((Object)mode, "mode");
        List<Layer> children = root.getChildren();
        int index = 0;
        while (index < children.size()) {
            child = children.get(index);
            if (filter.accept(child)) {
                return index;
            }
            ++index;
        }
        if (mode == SEARCH_DEEP) {
            index = 0;
            while (index < children.size()) {
                child = children.get(index);
                if (LayerUtils.getChildLayer(child, SEARCH_DEEP, filter) != null) {
                    return index;
                }
                ++index;
            }
        }
        return defaultIndex;
    }

    public static Layer getChildLayerById(Layer root, String id) {
        return LayerUtils.getChildLayer(root, SEARCH_DEEP, new IdFilter(id));
    }

    public static Layer getChildLayerByName(Layer root, String name) {
        return LayerUtils.getChildLayer(root, SEARCH_DEEP, new NameFilter(name));
    }

    public static Layer getChildLayer(Layer root, SearchMode mode, LayerFilter filter) {
        Assert.notNull(root, "root");
        Assert.notNull(filter, "filter");
        Assert.notNull((Object)mode, "mode");
        for (Layer child : root.getChildren()) {
            if (!filter.accept(child)) continue;
            return child;
        }
        if (mode == SEARCH_DEEP) {
            for (Layer child : root.getChildren()) {
                Layer acceptedLayer = LayerUtils.getChildLayer(child, SEARCH_DEEP, filter);
                if (acceptedLayer == null) continue;
                return acceptedLayer;
            }
        }
        return null;
    }

    public static List<Layer> getChildLayers(Layer root, SearchMode mode, LayerFilter filter) {
        Assert.notNull(root, "root");
        Assert.notNull((Object)mode, "mode");
        Assert.notNull(filter, "filter");
        ArrayList<Layer> layers = new ArrayList<Layer>(16);
        LayerUtils.getChildLayers(root, mode, filter, layers);
        return layers;
    }

    private static void getChildLayers(Layer root, SearchMode mode, LayerFilter filter, List<Layer> layers) {
        for (Layer child : root.getChildren()) {
            if (!filter.accept(child)) continue;
            layers.add(child);
        }
        if (mode == SEARCH_DEEP) {
            for (Layer child : root.getChildren()) {
                LayerUtils.getChildLayers(child, SEARCH_DEEP, filter, layers);
            }
        }
    }

    public static Layer getRootLayer(Layer layer) {
        Layer rootLayer = layer;
        Layer parent = layer.getParent();
        while (parent != null) {
            rootLayer = parent;
            parent = rootLayer.getParent();
        }
        return rootLayer;
    }

    public static Layer[] getLayerPath(Layer root, Layer layer) {
        Assert.notNull(root, "root");
        Assert.notNull(layer, "layer");
        if (root == layer) {
            return new Layer[]{root};
        }
        ArrayList<Layer> layerArrayList = new ArrayList<Layer>();
        LayerUtils.collectLayerPath(root, layer, layerArrayList);
        return layerArrayList.toArray(new Layer[layerArrayList.size()]);
    }

    public static Collection<Layer[]> getLayerPaths(Layer root, LayerFilter filter) {
        throw new IllegalStateException("not implemented");
    }

    private static boolean collectLayerPath(Layer root, Layer layer, List<Layer> collection) {
        List<Layer> children = root.getChildren();
        if (children.contains(layer)) {
            collection.add(root);
            collection.add(layer);
            return true;
        }
        for (Layer child : children) {
            if (!LayerUtils.collectLayerPath(child, layer, collection)) continue;
            collection.add(0, root);
            return true;
        }
        return false;
    }

    @Deprecated
    public static int getChildLayerIndex(Layer root, LayerFilter filter, SearchMode mode, int defaultIndex) {
        return LayerUtils.getChildLayerIndex(root, mode, defaultIndex, filter);
    }

    @Deprecated
    public static Layer getChildLayer(Layer root, LayerFilter filter, SearchMode mode) {
        return LayerUtils.getChildLayer(root, mode, filter);
    }

    public static enum SearchMode {
        FLAT,
        DEEP;

    }
}

