/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glevel.support;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.Interpolation;
import javax.media.jai.OpImage;
import javax.media.jai.TileCache;
import javax.media.jai.operator.ScaleDescriptor;

public class DefaultMultiLevelSource
extends AbstractMultiLevelSource {
    public static final Interpolation DEFAULT_INTERPOLATION = Interpolation.getInstance(0);
    public static final MultiLevelSource NULL = DefaultMultiLevelSource.createNull();
    private final RenderedImage sourceImage;
    private final Interpolation interpolation;

    public DefaultMultiLevelSource(RenderedImage sourceImage, int levelCount) {
        this(sourceImage, levelCount, DEFAULT_INTERPOLATION);
    }

    public DefaultMultiLevelSource(RenderedImage sourceImage, int levelCount, Interpolation interpolation) {
        this(sourceImage, DefaultMultiLevelSource.createDefaultMultiLevelModel(sourceImage, levelCount), interpolation);
    }

    public DefaultMultiLevelSource(RenderedImage sourceImage, MultiLevelModel multiLevelModel) {
        this(sourceImage, multiLevelModel, DEFAULT_INTERPOLATION);
    }

    public DefaultMultiLevelSource(RenderedImage sourceImage, MultiLevelModel multiLevelModel, Interpolation interpolation) {
        super(multiLevelModel);
        this.sourceImage = sourceImage;
        this.interpolation = interpolation;
    }

    public RenderedImage getSourceImage() {
        return this.sourceImage;
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    @Override
    public synchronized RenderedImage getImage(int level) {
        if (level == 0) {
            return this.sourceImage;
        }
        return super.getImage(level);
    }

    @Override
    protected RenderedImage createImage(int level) {
        if (level == 0) {
            return this.sourceImage;
        }
        double scale = this.getModel().getScale(level);
        double invScale = 1.0 / scale;
        int jaiW = DefaultMultiLevelSource.getLevelImageSizeJAI(this.sourceImage.getWidth(), scale);
        int jaiH = DefaultMultiLevelSource.getLevelImageSizeJAI(this.sourceImage.getHeight(), scale);
        int j2kW = DefaultMultiLevelSource.getLevelImageSizeJ2K(this.sourceImage.getWidth(), scale);
        int j2kH = DefaultMultiLevelSource.getLevelImageSizeJ2K(this.sourceImage.getHeight(), scale);
        float scaleX = jaiW == j2kW ? (float)invScale : (float)((double)j2kW / (double)this.sourceImage.getWidth());
        float scaleY = jaiH == j2kH ? (float)invScale : (float)((double)j2kH / (double)this.sourceImage.getHeight());
        return ScaleDescriptor.create(this.sourceImage, Float.valueOf(scaleX), Float.valueOf(scaleY), Float.valueOf(0.0f), Float.valueOf(0.0f), this.interpolation, null);
    }

    @Override
    public void reset() {
        DefaultMultiLevelSource.removeTilesFromCache(this.sourceImage);
        super.reset();
    }

    public static MultiLevelModel createDefaultMultiLevelModel(RenderedImage sourceImage, int levelCount) {
        return new DefaultMultiLevelModel(levelCount, new AffineTransform(), sourceImage.getWidth(), sourceImage.getHeight());
    }

    public static Rectangle getLevelImageBounds(Rectangle sourceBounds, double scale) {
        return new Rectangle(DefaultMultiLevelSource.getLevelImageSizeJ2K(sourceBounds.x, scale), DefaultMultiLevelSource.getLevelImageSizeJ2K(sourceBounds.y, scale), DefaultMultiLevelSource.getLevelImageSizeJ2K(sourceBounds.width, scale), DefaultMultiLevelSource.getLevelImageSizeJ2K(sourceBounds.height, scale));
    }

    private static int getLevelImageSizeJ2K(int sourceSize, double scale) {
        return (int)Math.ceil((double)sourceSize / scale);
    }

    private static int getLevelImageSizeJAI(int sourceSize, double scale) {
        return (int)Math.ceil((double)sourceSize / scale - 0.5);
    }

    private static MultiLevelSource createNull() {
        BufferedImage image = new BufferedImage(1, 1, 10);
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(1, new AffineTransform(), null);
        return new DefaultMultiLevelSource((RenderedImage)image, model);
    }

    private static void removeTilesFromCache(RenderedImage image) {
        OpImage opImage;
        TileCache tileCache;
        if (image instanceof OpImage && (tileCache = (opImage = (OpImage)image).getTileCache()) != null) {
            tileCache.removeTiles(image);
        }
    }
}

