/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.BorderDescriptor;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.DFTDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.IDFTDescriptor;
import javax.media.jai.operator.MultiplyComplexDescriptor;
import javax.media.jai.operator.RescaleDescriptor;

public class DFTConvolveRIF
implements RenderedImageFactory {
    boolean trace = false;

    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        BorderExtender extender = RIFUtil.getBorderExtenderHint(renderHints);
        KernelJAI kernel = (KernelJAI)paramBlock.getObjectParameter(0);
        RenderedImage kernelFT = (RenderedImage)paramBlock.getObjectParameter(1);
        RenderedImage sourceImage = (RenderedImage)paramBlock.getSource(0);
        this.printImageInfo(sourceImage, "sourceImage");
        int iw = sourceImage.getWidth();
        int ih = sourceImage.getHeight();
        int kw = kernel.getWidth();
        int kh = kernel.getHeight();
        int iw2 = DFTConvolveRIF.getNextBase2Size(iw + 2 * kw);
        int ih2 = DFTConvolveRIF.getNextBase2Size(ih + 2 * kh);
        int leftPad = (iw2 - iw) / 2;
        int rightPad = iw2 - iw - leftPad;
        int topPad = (ih2 - ih) / 2;
        int bottomPad = ih2 - ih - topPad;
        RenderedOp extendedImage = BorderDescriptor.create(DFTConvolveRIF.toFloat(sourceImage, renderHints), leftPad, rightPad, topPad, bottomPad, extender, null);
        this.printImageInfo(extendedImage, "extendedImage");
        if (kernelFT == null) {
            TiledImage kernelImage = DFTConvolveRIF.createKernelImage(extendedImage, extendedImage.getSampleModel().getDataType(), kernel);
            this.printImageInfo(kernelImage, "kernelImage");
            kernelFT = DFTDescriptor.create(kernelImage, DFTDescriptor.SCALING_NONE, DFTDescriptor.REAL_TO_COMPLEX, null);
        }
        this.printImageInfo(kernelFT, "kernelFT");
        RenderedOp sourceFT = DFTDescriptor.create(extendedImage, DFTDescriptor.SCALING_NONE, DFTDescriptor.REAL_TO_COMPLEX, null);
        this.printImageInfo(sourceFT, "sourceFT");
        RenderedOp productFT = MultiplyComplexDescriptor.create(sourceFT, kernelFT, null);
        this.printImageInfo(productFT, "productFT");
        RenderedOp convolvedImage = IDFTDescriptor.create(productFT, DFTDescriptor.SCALING_DIMENSIONS, DFTDescriptor.COMPLEX_TO_REAL, null);
        this.printImageInfo(convolvedImage, "convolvedImage");
        RenderedOp croppedImage = CropDescriptor.create(convolvedImage, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(iw), Float.valueOf(ih), null);
        croppedImage.setProperty("kernelFT", kernelFT);
        this.printImageInfo(croppedImage, "croppedImage");
        return croppedImage;
    }

    public static TiledImage createKernelImage(RenderedImage sourceImage, int dataType, KernelJAI kernel) {
        int kx;
        int x;
        int ky;
        float[] kernelData = kernel.getKernelData();
        if (dataType != 4 && dataType != 5) {
            throw new IllegalArgumentException("dataType");
        }
        ComponentSampleModelJAI sm = new ComponentSampleModelJAI(dataType, sourceImage.getTileWidth(), sourceImage.getTileHeight(), 1, sourceImage.getTileWidth(), new int[1]);
        int iw = sourceImage.getWidth();
        int ih = sourceImage.getHeight();
        int ix0 = sourceImage.getMinX();
        int iy0 = sourceImage.getMinY();
        TiledImage kernelImage = new TiledImage(ix0, iy0, iw, ih, sourceImage.getTileGridXOffset(), sourceImage.getTileGridYOffset(), sm, PlanarImage.createColorModel(sm));
        kernelData = DFTConvolveRIF.normalizeKernelData(kernelData);
        int kw = kernel.getWidth();
        int kx0 = kernel.getXOrigin();
        int ky0 = kernel.getYOrigin();
        int y = 0;
        while (y <= ky0) {
            ky = y + ky0;
            x = 0;
            while (x <= kx0) {
                kx = x + kx0;
                kernelImage.setSample(ix0 + x, iy0 + y, 0, kernelData[ky * kw + kx]);
                ++x;
            }
            x = iw - kx0;
            while (x < iw) {
                kx = x - (iw - kx0);
                kernelImage.setSample(ix0 + x, iy0 + y, 0, kernelData[ky * kw + kx]);
                ++x;
            }
            ++y;
        }
        y = ih - ky0;
        while (y < ih) {
            ky = y - (ih - ky0);
            x = 0;
            while (x <= kx0) {
                kx = x + kx0;
                kernelImage.setSample(ix0 + x, iy0 + y, 0, kernelData[ky * kw + kx]);
                ++x;
            }
            x = iw - kx0;
            while (x < iw) {
                kx = x - (iw - kx0);
                kernelImage.setSample(ix0 + x, iy0 + y, 0, kernelData[ky * kw + kx]);
                ++x;
            }
            ++y;
        }
        return kernelImage;
    }

    public static float[] normalizeKernelData(float[] kernelData) {
        float[] clone = (float[])kernelData.clone();
        float sum = 0.0f;
        int i = 0;
        while (i < kernelData.length) {
            sum += clone[i];
            ++i;
        }
        i = 0;
        while (i < kernelData.length) {
            int n = i++;
            clone[n] = clone[n] / sum;
        }
        return clone;
    }

    public static RenderedImage toFloat(RenderedImage sourceImage, RenderingHints hints) {
        int type = sourceImage.getSampleModel().getDataType();
        if (type == 0 || type == 3) {
            return DFTConvolveRIF.toFloat(sourceImage, 0.0, 255.0, 0.0, 1.0, hints);
        }
        if (type == 2) {
            return DFTConvolveRIF.toFloat(sourceImage, -32768.0, 32767.0, 0.0, 1.0, hints);
        }
        if (type == 1) {
            return DFTConvolveRIF.toFloat(sourceImage, 0.0, 65535.0, 0.0, 1.0, hints);
        }
        return sourceImage;
    }

    public static RenderedImage toFloat(RenderedImage sourceImage, double x1, double x2, double y1, double y2, RenderingHints hints) {
        double a = (y2 - y1) / (x2 - x1);
        double b = y1 - a * x1;
        return RescaleDescriptor.create(FormatDescriptor.create(sourceImage, 4, hints), new double[]{a}, new double[]{b}, hints);
    }

    public static int getNextBase2Size(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (Integer.bitCount(n) == 1) {
            return n;
        }
        return (int)Math.pow(2.0, 1.0 + Math.floor(Math.log(n) / Math.log(2.0)));
    }

    private void printImageInfo(RenderedImage sourceImage, String name) {
        if (this.trace) {
            System.out.println(String.valueOf(name) + ":");
            System.out.println("  minX   = " + sourceImage.getMinX());
            System.out.println("  minY   = " + sourceImage.getMinY());
            System.out.println("  width  = " + sourceImage.getWidth());
            System.out.println("  height = " + sourceImage.getHeight());
            System.out.println("  tileWidth  = " + sourceImage.getTileWidth());
            System.out.println("  tileHeight = " + sourceImage.getTileHeight());
        }
    }
}

